/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.TestPattern;

public class Matcher {
    private final TestPattern pattern;
    private CharSequence input;
    private int start;
    private int end;

    Matcher(TestPattern pattern, CharSequence input) {
        this.pattern = pattern;
        this.input = input;
    }

    public boolean matches() {
        if (this.pattern.pattern().equals(((Object)this.input).toString())) {
            this.start = 0;
            this.end = this.input.length();
            return true;
        }
        return false;
    }

    public Matcher reset() {
        return this.reset(this.input);
    }

    public Matcher reset(CharSequence input) {
        this.input = input;
        this.start = 0;
        this.end = 0;
        return this;
    }

    public int start() {
        return this.start;
    }

    public String replaceAll(String replacement) {
        return this.replace(replacement, Integer.MAX_VALUE);
    }

    public String replaceFirst(String replacement) {
        return this.replace(replacement, 1);
    }

    private String replace(String replacement, int limit) {
        this.reset();
        StringBuilder sb = null;
        int index = 0;
        for (int count = 0; count < limit && index < this.input.length(); ++count) {
            if (this.find(index)) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (this.start > index) {
                    sb.append(this.input.subSequence(index, this.start));
                }
                sb.append(replacement);
                index = this.end;
                continue;
            }
            if (index != 0) break;
            return ((Object)this.input).toString();
        }
        if (index < this.input.length()) {
            sb.append(this.input.subSequence(index, this.input.length()));
        }
        return sb.toString();
    }

    public int end() {
        return this.end;
    }

    public boolean find() {
        return this.find(this.end);
    }

    public boolean find(int start) {
        String p = this.pattern.pattern();
        int i = TestPattern.indexOf(this.input, p, start);
        if (i >= 0) {
            this.start = i;
            this.end = i + p.length();
            return true;
        }
        return false;
    }
}

