/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;

public class TestPattern {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private final int patternFlags;
    private final String pattern;

    protected TestPattern(String pattern, int flags) {
        this.pattern = pattern;
        this.patternFlags = flags;
        if (!TestPattern.trivial(pattern)) {
            throw new UnsupportedOperationException("only trivial regular expressions are supported so far");
        }
    }

    private static boolean trivial(String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }

    public static TestPattern compile(String regex) {
        return new TestPattern(regex, 0);
    }

    public static TestPattern compile(String regex, int flags) {
        return new TestPattern(regex, flags);
    }

    public int flags() {
        return this.patternFlags;
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public static boolean matches(String regex, CharSequence input) {
        return TestPattern.compile(regex).matcher(input).matches();
    }

    public String pattern() {
        return this.pattern;
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public String[] split(CharSequence input, int limit) {
        boolean strip;
        if (limit < 0) {
            strip = false;
            limit = Integer.MAX_VALUE;
        } else if (limit == 0) {
            strip = true;
            limit = Integer.MAX_VALUE;
        } else {
            strip = false;
        }
        LinkedList<CharSequence> list = new LinkedList<CharSequence>();
        int index = 0;
        int trailing = 0;
        int patternLength = this.pattern.length();
        while (index < input.length() && list.size() < limit - 1) {
            int i = patternLength == 0 ? (list.size() == 0 ? 0 : index + 1) : TestPattern.indexOf(input, this.pattern, index);
            if (i < 0) break;
            trailing = patternLength != 0 && i == index ? ++trailing : 0;
            list.add(input.subSequence(index, i));
            index = i + patternLength;
        }
        trailing = strip && index > 0 && index == input.length() ? ++trailing : 0;
        list.add(input.subSequence(index, input.length()));
        String[] result = new String[list.size() - trailing];
        Iterator it = list.iterator();
        for (int i = 0; it.hasNext() && i < result.length; ++i) {
            result[i] = ((Object)((CharSequence)it.next())).toString();
        }
        return result;
    }

    static int indexOf(CharSequence haystack, CharSequence needle, int start) {
        if (needle.length() == 0) {
            return start;
        }
        for (int i = start; i < haystack.length() - needle.length() + 1; ++i) {
            int j;
            for (j = 0; j < needle.length() && haystack.charAt(i + j) == needle.charAt(j); ++j) {
            }
            if (j != needle.length()) continue;
            return i;
        }
        return -1;
    }
}

