/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class CircleShape
extends Shape {
    public final Vec2 m_p;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();

    public CircleShape() {
        super(ShapeType.CIRCLE);
        this.m_p = new Vec2();
        this.m_radius = 0.0f;
    }

    @Override
    public final Shape clone() {
        CircleShape shape = new CircleShape();
        shape.m_p.set(this.m_p);
        shape.m_radius = this.m_radius;
        return shape;
    }

    @Override
    public final int getChildCount() {
        return 1;
    }

    public final int getSupport(Vec2 d) {
        return 0;
    }

    public final Vec2 getSupportVertex(Vec2 d) {
        return this.m_p;
    }

    public final int getVertexCount() {
        return 1;
    }

    public final Vec2 getVertex(int index) {
        assert (index == 0);
        return this.m_p;
    }

    @Override
    public final boolean testPoint(Transform transform, Vec2 p) {
        Vec2 center = this.pool1;
        Rot.mulToOutUnsafe(transform.q, this.m_p, center);
        center.addLocal(transform.p);
        Vec2 d = center.subLocal(p).negateLocal();
        return Vec2.dot(d, d) <= this.m_radius * this.m_radius;
    }

    @Override
    public final boolean raycast(RayCastOutput output, RayCastInput input, Transform transform, int childIndex) {
        Vec2 position = this.pool1;
        Vec2 s = this.pool2;
        Vec2 r = this.pool3;
        Rot.mulToOutUnsafe(transform.q, this.m_p, position);
        position.addLocal(transform.p);
        s.set(input.p1).subLocal(position);
        float b = Vec2.dot(s, s) - this.m_radius * this.m_radius;
        r.set(input.p2).subLocal(input.p1);
        float c = Vec2.dot(s, r);
        float rr = Vec2.dot(r, r);
        float sigma = c * c - rr * b;
        if (sigma < 0.0f || rr < 1.1920929E-7f) {
            return false;
        }
        float a = -(c + MathUtils.sqrt(sigma));
        if (0.0f <= a && a <= input.maxFraction * rr) {
            output.fraction = a /= rr;
            output.normal.set(r).mulLocal(a);
            output.normal.addLocal(s);
            output.normal.normalize();
            return true;
        }
        return false;
    }

    @Override
    public final void computeAABB(AABB aabb, Transform transform, int childIndex) {
        Vec2 p = this.pool1;
        Rot.mulToOutUnsafe(transform.q, this.m_p, p);
        p.addLocal(transform.p);
        aabb.lowerBound.x = p.x - this.m_radius;
        aabb.lowerBound.y = p.y - this.m_radius;
        aabb.upperBound.x = p.x + this.m_radius;
        aabb.upperBound.y = p.y + this.m_radius;
    }

    @Override
    public final void computeMass(MassData massData, float density) {
        massData.mass = density * (float)Math.PI * this.m_radius * this.m_radius;
        massData.center.set(this.m_p);
        massData.I = massData.mass * (0.5f * this.m_radius * this.m_radius + Vec2.dot(this.m_p, this.m_p));
    }
}

