/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Vec2;

public class Transform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 p;
    public final Rot q;
    private static Vec2 pool = new Vec2();

    public Transform() {
        this.p = new Vec2();
        this.q = new Rot();
    }

    public Transform(Transform xf) {
        this.p = xf.p.clone();
        this.q = xf.q.clone();
    }

    public Transform(Vec2 _position, Rot _R) {
        this.p = _position.clone();
        this.q = _R.clone();
    }

    public final Transform set(Transform xf) {
        this.p.set(xf.p);
        this.q.set(xf.q);
        return this;
    }

    public final void set(Vec2 p, float angle) {
        this.p.set(p);
        this.q.set(angle);
    }

    public final void setIdentity() {
        this.p.setZero();
        this.q.setIdentity();
    }

    public static final Vec2 mul(Transform T, Vec2 v) {
        return new Vec2(T.q.c * v.x - T.q.s * v.y + T.p.x, T.q.s * v.x + T.q.c * v.y + T.p.y);
    }

    public static final void mulToOut(Transform T, Vec2 v, Vec2 out) {
        float tempy = T.q.s * v.x + T.q.c * v.y + T.p.y;
        out.x = T.q.c * v.x - T.q.s * v.y + T.p.x;
        out.y = tempy;
    }

    public static final void mulToOutUnsafe(Transform T, Vec2 v, Vec2 out) {
        assert (v != out);
        out.x = T.q.c * v.x - T.q.s * v.y + T.p.x;
        out.y = T.q.s * v.x + T.q.c * v.y + T.p.y;
    }

    public static final Vec2 mulTrans(Transform T, Vec2 v) {
        float px = v.x - T.p.x;
        float py = v.y - T.p.y;
        return new Vec2(T.q.c * px + T.q.s * py, -T.q.s * px + T.q.c * py);
    }

    public static final void mulTransToOut(Transform T, Vec2 v, Vec2 out) {
        float px = v.x - T.p.x;
        float py = v.y - T.p.y;
        float tempy = -T.q.s * px + T.q.c * py;
        out.x = T.q.c * px + T.q.s * py;
        out.y = tempy;
    }

    public static final void mulTransToOutUnsafe(Transform T, Vec2 v, Vec2 out) {
        assert (v != out);
        float px = v.x - T.p.x;
        float py = v.y - T.p.y;
        out.x = T.q.c * px + T.q.s * py;
        out.y = -T.q.s * px + T.q.c * py;
    }

    public static final Transform mul(Transform A2, Transform B2) {
        Transform C2 = new Transform();
        Rot.mulUnsafe(A2.q, B2.q, C2.q);
        Rot.mulToOutUnsafe(A2.q, B2.p, C2.p);
        C2.p.addLocal(A2.p);
        return C2;
    }

    public static final void mulToOut(Transform A2, Transform B2, Transform out) {
        assert (out != A2);
        Rot.mul(A2.q, B2.q, out.q);
        Rot.mulToOut(A2.q, B2.p, out.p);
        out.p.addLocal(A2.p);
    }

    public static final void mulToOutUnsafe(Transform A2, Transform B2, Transform out) {
        assert (out != B2);
        assert (out != A2);
        Rot.mulUnsafe(A2.q, B2.q, out.q);
        Rot.mulToOutUnsafe(A2.q, B2.p, out.p);
        out.p.addLocal(A2.p);
    }

    public static final Transform mulTrans(Transform A2, Transform B2) {
        Transform C2 = new Transform();
        Rot.mulTransUnsafe(A2.q, B2.q, C2.q);
        pool.set(B2.p).subLocal(A2.p);
        Rot.mulTransUnsafe(A2.q, pool, C2.p);
        return C2;
    }

    public static final void mulTransToOut(Transform A2, Transform B2, Transform out) {
        assert (out != A2);
        Rot.mulTrans(A2.q, B2.q, out.q);
        pool.set(B2.p).subLocal(A2.p);
        Rot.mulTrans(A2.q, pool, out.p);
    }

    public static final void mulTransToOutUnsafe(Transform A2, Transform B2, Transform out) {
        assert (out != A2);
        assert (out != B2);
        Rot.mulTransUnsafe(A2.q, B2.q, out.q);
        pool.set(B2.p).subLocal(A2.p);
        Rot.mulTransUnsafe(A2.q, pool, out.p);
    }

    public final String toString() {
        String s = "XForm:\n";
        s = s + "Position: " + this.p + "\n";
        s = s + "R: \n" + this.q + "\n";
        return s;
    }
}

