/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.pooling.normal;

import java.util.HashMap;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Collision;
import org.jbox2d.collision.Distance;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.Rot;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.contacts.ChainAndCircleContact;
import org.jbox2d.dynamics.contacts.ChainAndPolygonContact;
import org.jbox2d.dynamics.contacts.CircleContact;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.EdgeAndCircleContact;
import org.jbox2d.dynamics.contacts.EdgeAndPolygonContact;
import org.jbox2d.dynamics.contacts.PolygonAndCircleContact;
import org.jbox2d.dynamics.contacts.PolygonContact;
import org.jbox2d.pooling.IDynamicStack;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.normal.Generator;
import org.jbox2d.pooling.normal.MutableStack;
import org.jbox2d.pooling.normal.OrderedStack;

public class DefaultWorldPool
implements IWorldPool {
    private final OrderedStack<Vec2> vecs;
    private final OrderedStack<Vec3> vec3s;
    private final OrderedStack<Mat22> mats;
    private final OrderedStack<Mat33> mat33s;
    private final OrderedStack<AABB> aabbs;
    private final OrderedStack<Rot> rots;
    private final HashMap<Integer, float[]> afloats = new HashMap();
    private final HashMap<Integer, int[]> aints = new HashMap();
    private final HashMap<Integer, Vec2[]> avecs = new HashMap();
    private final Class<?>[] classes = new Class[]{IWorldPool.class};
    private final Object[] args = new Object[]{this};
    private final MutableStack<Contact, PolygonContact> pcstack = new MutableStack(new Generator<PolygonContact>(){

        @Override
        public PolygonContact gen() {
            return new PolygonContact(DefaultWorldPool.this);
        }
    }, 10);
    private final MutableStack<Contact, CircleContact> ccstack = new MutableStack(new Generator<CircleContact>(){

        @Override
        public CircleContact gen() {
            return new CircleContact(DefaultWorldPool.this);
        }
    }, 10);
    private final MutableStack<Contact, PolygonAndCircleContact> cpstack = new MutableStack(new Generator<PolygonAndCircleContact>(){

        @Override
        public PolygonAndCircleContact gen() {
            return new PolygonAndCircleContact(DefaultWorldPool.this);
        }
    }, 10);
    private final MutableStack<Contact, EdgeAndCircleContact> ecstack = new MutableStack(new Generator<EdgeAndCircleContact>(){

        @Override
        public EdgeAndCircleContact gen() {
            return new EdgeAndCircleContact(DefaultWorldPool.this);
        }
    }, 10);
    private final MutableStack<Contact, EdgeAndPolygonContact> epstack = new MutableStack(new Generator<EdgeAndPolygonContact>(){

        @Override
        public EdgeAndPolygonContact gen() {
            return new EdgeAndPolygonContact(DefaultWorldPool.this);
        }
    }, 10);
    private final MutableStack<Contact, ChainAndCircleContact> chcstack = new MutableStack(new Generator<ChainAndCircleContact>(){

        @Override
        public ChainAndCircleContact gen() {
            return new ChainAndCircleContact(DefaultWorldPool.this);
        }
    }, 10);
    private final MutableStack<Contact, ChainAndPolygonContact> chpstack = new MutableStack(new Generator<ChainAndPolygonContact>(){

        @Override
        public ChainAndPolygonContact gen() {
            return new ChainAndPolygonContact(DefaultWorldPool.this);
        }
    }, 10);
    private final Collision collision;
    private final TimeOfImpact toi;
    private final Distance dist;

    public DefaultWorldPool(int argSize, int argContainerSize) {
        this.vecs = new OrderedStack<Vec2>(new Generator<Vec2>(){

            @Override
            public Vec2 gen() {
                return new Vec2();
            }
        }, argSize, new Vec2[argContainerSize]);
        this.vec3s = new OrderedStack<Vec3>(new Generator<Vec3>(){

            @Override
            public Vec3 gen() {
                return new Vec3();
            }
        }, argSize, new Vec3[argContainerSize]);
        this.mats = new OrderedStack<Mat22>(new Generator<Mat22>(){

            @Override
            public Mat22 gen() {
                return new Mat22();
            }
        }, argSize, new Mat22[argContainerSize]);
        this.aabbs = new OrderedStack<AABB>(new Generator<AABB>(){

            @Override
            public AABB gen() {
                return new AABB();
            }
        }, argSize, new AABB[argContainerSize]);
        this.rots = new OrderedStack<Rot>(new Generator<Rot>(){

            @Override
            public Rot gen() {
                return new Rot();
            }
        }, argSize, new Rot[argContainerSize]);
        this.mat33s = new OrderedStack<Mat33>(new Generator<Mat33>(){

            @Override
            public Mat33 gen() {
                return new Mat33();
            }
        }, argSize, new Mat33[argContainerSize]);
        this.dist = new Distance();
        this.collision = new Collision(this);
        this.toi = new TimeOfImpact(this);
    }

    @Override
    public final IDynamicStack<Contact> getPolyContactStack() {
        return this.pcstack;
    }

    @Override
    public final IDynamicStack<Contact> getCircleContactStack() {
        return this.ccstack;
    }

    @Override
    public final IDynamicStack<Contact> getPolyCircleContactStack() {
        return this.cpstack;
    }

    @Override
    public IDynamicStack<Contact> getEdgeCircleContactStack() {
        return this.ecstack;
    }

    @Override
    public IDynamicStack<Contact> getEdgePolyContactStack() {
        return this.epstack;
    }

    @Override
    public IDynamicStack<Contact> getChainCircleContactStack() {
        return this.chcstack;
    }

    @Override
    public IDynamicStack<Contact> getChainPolyContactStack() {
        return this.chpstack;
    }

    @Override
    public final Vec2 popVec2() {
        return this.vecs.pop();
    }

    @Override
    public final Vec2[] popVec2(int argNum) {
        return this.vecs.pop(argNum);
    }

    @Override
    public final void pushVec2(int argNum) {
        this.vecs.push(argNum);
    }

    @Override
    public final Vec3 popVec3() {
        return this.vec3s.pop();
    }

    @Override
    public final Vec3[] popVec3(int argNum) {
        return this.vec3s.pop(argNum);
    }

    @Override
    public final void pushVec3(int argNum) {
        this.vec3s.push(argNum);
    }

    @Override
    public final Mat22 popMat22() {
        return this.mats.pop();
    }

    @Override
    public final Mat22[] popMat22(int argNum) {
        return this.mats.pop(argNum);
    }

    @Override
    public final void pushMat22(int argNum) {
        this.mats.push(argNum);
    }

    @Override
    public final Mat33 popMat33() {
        return this.mat33s.pop();
    }

    @Override
    public final void pushMat33(int argNum) {
        this.mat33s.push(argNum);
    }

    @Override
    public final AABB popAABB() {
        return this.aabbs.pop();
    }

    @Override
    public final AABB[] popAABB(int argNum) {
        return this.aabbs.pop(argNum);
    }

    @Override
    public final void pushAABB(int argNum) {
        this.aabbs.push(argNum);
    }

    @Override
    public final Rot popRot() {
        return this.rots.pop();
    }

    @Override
    public final void pushRot(int num) {
        this.rots.push(num);
    }

    @Override
    public final Collision getCollision() {
        return this.collision;
    }

    @Override
    public final TimeOfImpact getTimeOfImpact() {
        return this.toi;
    }

    @Override
    public final Distance getDistance() {
        return this.dist;
    }

    @Override
    public final float[] getFloatArray(int argLength) {
        if (!this.afloats.containsKey(argLength)) {
            this.afloats.put(argLength, new float[argLength]);
        }
        assert (this.afloats.get(argLength).length == argLength) : "Array not built with correct length";
        return this.afloats.get(argLength);
    }

    @Override
    public final int[] getIntArray(int argLength) {
        if (!this.aints.containsKey(argLength)) {
            this.aints.put(argLength, new int[argLength]);
        }
        assert (this.aints.get(argLength).length == argLength) : "Array not built with correct length";
        return this.aints.get(argLength);
    }

    @Override
    public final Vec2[] getVec2Array(int argLength) {
        if (!this.avecs.containsKey(argLength)) {
            Vec2[] ray = new Vec2[argLength];
            for (int i = 0; i < argLength; ++i) {
                ray[i] = new Vec2();
            }
            this.avecs.put(argLength, ray);
        }
        assert (this.avecs.get(argLength).length == argLength) : "Array not built with correct length";
        return this.avecs.get(argLength);
    }
}

