/*
 * Decompiled with CFR 0.152.
 */
package com.petebevin.markdown;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class CharacterProtector {
    private Map<String, String> protectMap = new HashMap<String, String>();
    private Map<String, String> unprotectMap = new HashMap<String, String>();
    private static final String GOOD_CHARS = "0123456789qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    private Random rnd = new Random();

    CharacterProtector() {
    }

    public String encode(String literal) {
        if (!this.protectMap.containsKey(literal)) {
            this.addToken(literal);
        }
        return this.protectMap.get(literal);
    }

    public String decode(String coded) {
        return this.unprotectMap.get(coded);
    }

    public Collection<String> getAllEncodedTokens() {
        return this.unprotectMap.keySet();
    }

    private void addToken(String literal) {
        String encoded = this.longRandomString();
        this.protectMap.put(literal, encoded);
        this.unprotectMap.put(encoded, literal);
    }

    private String longRandomString() {
        StringBuffer sb = new StringBuffer();
        int CHAR_MAX = GOOD_CHARS.length();
        int i = 0;
        while (i < 20) {
            sb.append(GOOD_CHARS.charAt(this.rnd.nextInt(CHAR_MAX)));
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.protectMap.toString();
    }
}

