/*
 * Decompiled with CFR 0.152.
 */
package us.feras.mdv;

import android.content.Context;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.webkit.WebView;
import com.petebevin.markdown.MarkdownProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import us.feras.mdv.util.HttpHelper;

public class MarkdownView
extends WebView {
    public MarkdownView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MarkdownView(Context context) {
        super(context);
    }

    public void loadMarkdown(String txt, String cssFileUrl) {
        this.loadMarkdownToView(txt, cssFileUrl);
    }

    public void loadMarkdown(String txt) {
        this.loadMarkdown(txt, null);
    }

    public void loadMarkdownFile(String url, String cssFileUrl) {
        new LoadMarkdownUrlTask().execute(new String[]{url, cssFileUrl});
    }

    public void loadMarkdownFile(String url) {
        this.loadMarkdownFile(url, null);
    }

    private String readFileFromAsset(String url) throws IOException {
        BufferedReader input = null;
        StringBuilder contents = new StringBuilder();
        try {
            String assetFileName = url.substring(url.lastIndexOf(47) + 1, url.length());
            input = new BufferedReader(new InputStreamReader(this.getContext().getAssets().open(assetFileName)));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
            String string = contents.toString();
            return string;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void loadMarkdownToView(String txt, String cssFileUrl) {
        MarkdownProcessor m = new MarkdownProcessor();
        String html = m.markdown(txt);
        if (cssFileUrl != null) {
            html = String.format("<link rel=\"stylesheet\" type=\"text/css\" href=\"%s\" />" + html, cssFileUrl);
        }
        this.loadDataWithBaseURL("fake://", html, "text/html", "UTF-8", null);
    }

    private class LoadMarkdownUrlTask
    extends AsyncTask<String, Integer, String> {
        private String cssFileUrl;

        private LoadMarkdownUrlTask() {
        }

        protected String doInBackground(String ... params) {
            try {
                String txt = "";
                String url = params[0];
                this.cssFileUrl = params[1];
                txt = url.startsWith("file:///android_asset") ? MarkdownView.this.readFileFromAsset(url) : HttpHelper.get(url).getResponseMessage();
                return txt;
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(String result) {
            if (result != null) {
                MarkdownView.this.loadMarkdownToView(result, this.cssFileUrl);
            } else {
                MarkdownView.this.loadUrl("about:blank");
            }
        }
    }
}

