/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.content.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;

public class Installation {
    private static String sID = null;
    private static final String INSTALLATION = "ACRA-INSTALLATION";

    public static synchronized String id(Context context) {
        if (sID == null) {
            File installation = new File(context.getFilesDir(), INSTALLATION);
            try {
                if (!installation.exists()) {
                    Installation.writeInstallationFile(installation);
                }
                sID = Installation.readInstallationFile(installation);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInstallationFile(File installation) throws IOException {
        RandomAccessFile f = new RandomAccessFile(installation, "r");
        byte[] bytes = new byte[(int)f.length()];
        try {
            f.readFully(bytes);
        }
        finally {
            f.close();
        }
        return new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInstallationFile(File installation) throws IOException {
        FileOutputStream out = new FileOutputStream(installation);
        try {
            String id = UUID.randomUUID().toString();
            out.write(id.getBytes());
        }
        finally {
            out.close();
        }
    }
}

