/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import android.text.format.Time;
import android.util.Log;
import org.acra.ACRAConfigurationException;
import org.acra.ErrorReporter;
import org.acra.ReportField;
import org.acra.annotation.ReportsCrashes;
import org.acra.sender.EmailIntentSender;
import org.acra.sender.GoogleFormSender;
import org.acra.sender.HttpPostSender;

public class ACRA {
    public static final boolean DEV_LOGGING = false;
    public static final String LOG_TAG = ACRA.class.getSimpleName();
    static final String RES_NOTIF_ICON = "RES_NOTIF_ICON";
    static final String RES_NOTIF_TICKER_TEXT = "RES_NOTIF_TICKER_TEXT";
    static final String RES_NOTIF_TITLE = "RES_NOTIF_TITLE";
    static final String RES_NOTIF_TEXT = "RES_NOTIF_TEXT";
    static final String RES_DIALOG_ICON = "RES_DIALOG_ICON";
    static final String RES_DIALOG_TITLE = "RES_DIALOG_TITLE";
    static final String RES_DIALOG_TEXT = "RES_DIALOG_TEXT";
    static final String RES_DIALOG_COMMENT_PROMPT = "RES_DIALOG_COMMENT_PROMPT";
    static final String RES_DIALOG_OK_TOAST = "RES_DIALOG_OK_TOAST";
    static final String RES_TOAST_TEXT = "RES_TOAST_TEXT";
    static final int NOTIF_CRASH_ID = 666;
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    public static final String PREF_ENABLE_SYSTEM_LOGS = "acra.syslog.enable";
    public static final String PREF_ENABLE_DEVICE_ID = "acra.deviceid.enable";
    public static final String PREF_USER_EMAIL_ADDRESS = "acra.user.email";
    public static final String PREF_ALWAYS_ACCEPT = "acra.alwaysaccept";
    private static Application mApplication;
    private static ReportsCrashes mReportsCrashes;
    private static SharedPreferences.OnSharedPreferenceChangeListener mPrefListener;
    private static Time mAppStartDate;
    public static final ReportField[] DEFAULT_MAIL_REPORT_FIELDS;
    public static final ReportField[] DEFAULT_REPORT_FIELDS;
    public static final String NULL_VALUE = "ACRA-NULL-STRING";

    public static void init(Application app) {
        mAppStartDate = new Time();
        mAppStartDate.setToNow();
        mApplication = app;
        mReportsCrashes = mApplication.getClass().getAnnotation(ReportsCrashes.class);
        if (mReportsCrashes != null) {
            SharedPreferences prefs = ACRA.getACRASharedPreferences();
            Log.d((String)LOG_TAG, (String)"Set OnSharedPreferenceChangeListener.");
            mPrefListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

                public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                    if (ACRA.PREF_DISABLE_ACRA.equals(key) || ACRA.PREF_ENABLE_ACRA.equals(key)) {
                        Boolean disableAcra = false;
                        try {
                            disableAcra = sharedPreferences.getBoolean(ACRA.PREF_DISABLE_ACRA, !sharedPreferences.getBoolean(ACRA.PREF_ENABLE_ACRA, true));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (disableAcra.booleanValue()) {
                            ErrorReporter.getInstance().disable();
                        } else {
                            try {
                                ACRA.initAcra();
                            }
                            catch (ACRAConfigurationException e) {
                                Log.w((String)LOG_TAG, (String)"Error : ", (Throwable)e);
                            }
                        }
                    }
                }
            };
            boolean disableAcra = false;
            try {
                disableAcra = prefs.getBoolean(PREF_DISABLE_ACRA, !prefs.getBoolean(PREF_ENABLE_ACRA, true));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (disableAcra) {
                Log.d((String)LOG_TAG, (String)("ACRA is disabled for " + mApplication.getPackageName() + "."));
            } else {
                try {
                    ACRA.initAcra();
                }
                catch (ACRAConfigurationException e) {
                    Log.w((String)LOG_TAG, (String)"Error : ", (Throwable)e);
                }
            }
            prefs.registerOnSharedPreferenceChangeListener(mPrefListener);
        }
    }

    private static void initAcra() throws ACRAConfigurationException {
        ACRA.checkCrashResources();
        Log.d((String)LOG_TAG, (String)("ACRA is enabled for " + mApplication.getPackageName() + ", intializing..."));
        ErrorReporter errorReporter = ErrorReporter.getInstance();
        errorReporter.setReportingInteractionMode(mReportsCrashes.mode());
        errorReporter.setAppStartDate(mAppStartDate);
        if (!"".equals(mReportsCrashes.mailTo())) {
            Log.w((String)LOG_TAG, (String)(mApplication.getPackageName() + " reports will be sent by email (if accepted by user)."));
            errorReporter.addReportSender(new EmailIntentSender((Context)mApplication));
        } else {
            PackageManager pm = mApplication.getPackageManager();
            if (pm != null) {
                if (pm.checkPermission("android.permission.INTERNET", mApplication.getPackageName()) == 0) {
                    if (mReportsCrashes.formUri() != null && !"".equals(mReportsCrashes.formUri())) {
                        errorReporter.addReportSender(new HttpPostSender(mReportsCrashes.formUri(), null));
                    } else if (mReportsCrashes.formKey() != null && !"".equals(mReportsCrashes.formKey().trim())) {
                        errorReporter.addReportSender(new GoogleFormSender(mReportsCrashes.formKey()));
                    }
                } else {
                    Log.e((String)LOG_TAG, (String)(mApplication.getPackageName() + " should be granted permission " + "android.permission.INTERNET" + " if you want your crash reports to be sent. If you don't want to add this permission to your application you can also enable sending reports by email. If this is your will then provide your email address in @ReportsCrashes(mailTo=\"your.account@domain.com\""));
                }
            }
        }
        errorReporter.init(mApplication.getApplicationContext());
        errorReporter.checkReportsOnApplicationStart();
    }

    static void checkCrashResources() throws ACRAConfigurationException {
        switch (mReportsCrashes.mode()) {
            case TOAST: {
                if (mReportsCrashes.resToastText() != 0) break;
                throw new ACRAConfigurationException("TOAST mode: you have to define the resToastText parameter in your application @ReportsCrashes() annotation.");
            }
            case NOTIFICATION: {
                if (mReportsCrashes.resNotifTickerText() != 0 && mReportsCrashes.resNotifTitle() != 0 && mReportsCrashes.resNotifText() != 0 && mReportsCrashes.resDialogText() != 0) break;
                throw new ACRAConfigurationException("NOTIFICATION mode: you have to define at least the resNotifTickerText, resNotifTitle, resNotifText, resDialogText parameters in your application @ReportsCrashes() annotation.");
            }
        }
    }

    public static SharedPreferences getACRASharedPreferences() {
        if (!"".equals(mReportsCrashes.sharedPreferencesName())) {
            Log.d((String)LOG_TAG, (String)("Retrieve SharedPreferences " + mReportsCrashes.sharedPreferencesName()));
            return mApplication.getSharedPreferences(mReportsCrashes.sharedPreferencesName(), mReportsCrashes.sharedPreferencesMode());
        }
        Log.d((String)LOG_TAG, (String)"Retrieve application default SharedPreferences.");
        return PreferenceManager.getDefaultSharedPreferences((Context)mApplication);
    }

    public static ReportsCrashes getConfig() {
        return mReportsCrashes;
    }

    static {
        DEFAULT_MAIL_REPORT_FIELDS = new ReportField[]{ReportField.USER_COMMENT, ReportField.ANDROID_VERSION, ReportField.APP_VERSION_NAME, ReportField.BRAND, ReportField.PHONE_MODEL, ReportField.CUSTOM_DATA, ReportField.STACK_TRACE};
        DEFAULT_REPORT_FIELDS = new ReportField[]{ReportField.REPORT_ID, ReportField.APP_VERSION_CODE, ReportField.APP_VERSION_NAME, ReportField.PACKAGE_NAME, ReportField.FILE_PATH, ReportField.PHONE_MODEL, ReportField.BRAND, ReportField.PRODUCT, ReportField.ANDROID_VERSION, ReportField.BUILD, ReportField.TOTAL_MEM_SIZE, ReportField.AVAILABLE_MEM_SIZE, ReportField.CUSTOM_DATA, ReportField.IS_SILENT, ReportField.STACK_TRACE, ReportField.INITIAL_CONFIGURATION, ReportField.CRASH_CONFIGURATION, ReportField.DISPLAY, ReportField.USER_COMMENT, ReportField.USER_EMAIL, ReportField.USER_APP_START_DATE, ReportField.USER_CRASH_DATE, ReportField.DUMPSYS_MEMINFO, ReportField.DROPBOX, ReportField.LOGCAT, ReportField.EVENTSLOG, ReportField.RADIOLOG, ReportField.DEVICE_ID, ReportField.INSTALLATION_ID, ReportField.DEVICE_FEATURES, ReportField.ENVIRONMENT, ReportField.SHARED_PREFERENCES, ReportField.SETTINGS_SYSTEM, ReportField.SETTINGS_SECURE};
    }
}

