/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import org.acra.ACRA;
import org.acra.ErrorReporter;

public class CrashReportDialog
extends Activity {
    private SharedPreferences prefs = null;
    private EditText userComment = null;
    private EditText userEmail = null;
    String mReportFileName = null;

    protected void onCreate(Bundle savedInstanceState) {
        int emailPromptId;
        super.onCreate(savedInstanceState);
        this.mReportFileName = this.getIntent().getStringExtra("REPORT_FILE_NAME");
        Log.d((String)ACRA.LOG_TAG, (String)("Opening CrashReportDialog for " + this.mReportFileName));
        if (this.mReportFileName == null) {
            this.finish();
        }
        this.requestWindowFeature(3);
        LinearLayout root = new LinearLayout((Context)this);
        root.setOrientation(1);
        root.setPadding(10, 10, 10, 10);
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        ScrollView scroll = new ScrollView((Context)this);
        root.addView((View)scroll, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        TextView text = new TextView((Context)this);
        text.setText(this.getText(ACRA.getConfig().resDialogText()));
        scroll.addView((View)text, -1, -1);
        int commentPromptId = ACRA.getConfig().resDialogCommentPrompt();
        if (commentPromptId != 0) {
            TextView label = new TextView((Context)this);
            label.setText(this.getText(commentPromptId));
            label.setPadding(label.getPaddingLeft(), 10, label.getPaddingRight(), label.getPaddingBottom());
            root.addView((View)label, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.userComment = new EditText((Context)this);
            this.userComment.setLines(2);
            root.addView((View)this.userComment, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        if ((emailPromptId = ACRA.getConfig().resDialogEmailPrompt()) != 0) {
            TextView label = new TextView((Context)this);
            label.setText(this.getText(emailPromptId));
            label.setPadding(label.getPaddingLeft(), 10, label.getPaddingRight(), label.getPaddingBottom());
            root.addView((View)label, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.userEmail = new EditText((Context)this);
            this.userEmail.setSingleLine();
            this.userEmail.setInputType(33);
            this.prefs = this.getSharedPreferences(ACRA.getConfig().sharedPreferencesName(), ACRA.getConfig().sharedPreferencesMode());
            this.userEmail.setText((CharSequence)this.prefs.getString("acra.user.email", ""));
            root.addView((View)this.userEmail, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        LinearLayout buttons = new LinearLayout((Context)this);
        buttons.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        buttons.setPadding(buttons.getPaddingLeft(), 10, buttons.getPaddingRight(), buttons.getPaddingBottom());
        Button yes = new Button((Context)this);
        yes.setText(17039379);
        yes.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ErrorReporter err = ErrorReporter.getInstance();
                ErrorReporter.ReportsSenderWorker worker = new ErrorReporter.ReportsSenderWorker(err);
                worker.setApprovePendingReports();
                if (CrashReportDialog.this.userComment != null) {
                    worker.setUserComment(CrashReportDialog.this.mReportFileName, CrashReportDialog.this.userComment.getText().toString());
                }
                if (CrashReportDialog.this.prefs != null && CrashReportDialog.this.userEmail != null) {
                    String usrEmail = CrashReportDialog.this.userEmail.getText().toString();
                    SharedPreferences.Editor prefEditor = CrashReportDialog.this.prefs.edit();
                    prefEditor.putString("acra.user.email", usrEmail);
                    prefEditor.commit();
                    worker.setUserEmail(CrashReportDialog.this.mReportFileName, usrEmail);
                }
                Log.v((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from CrashReportDialog");
                worker.start();
                int toastId = ACRA.getConfig().resDialogOkToast();
                if (toastId != 0) {
                    Toast.makeText((Context)CrashReportDialog.this.getApplicationContext(), (int)toastId, (int)1).show();
                }
                CrashReportDialog.this.finish();
            }
        });
        buttons.addView((View)yes, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        Button no = new Button((Context)this);
        no.setText(17039369);
        no.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ErrorReporter.getInstance().deletePendingReports();
                CrashReportDialog.this.finish();
            }
        });
        buttons.addView((View)no, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        root.addView((View)buttons, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.setContentView((View)root);
        int resTitle = ACRA.getConfig().resDialogTitle();
        if (resTitle != 0) {
            this.setTitle(resTitle);
        }
        this.getWindow().setFeatureDrawableResource(3, ACRA.getConfig().resDialogIcon());
        this.cancelNotification();
    }

    protected void cancelNotification() {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.cancel(666);
    }
}

