/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.acra.ACRA;
import org.acra.util.FakeSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpRequest {
    DefaultHttpClient httpClient;
    HttpContext localContext;
    HttpPost httpPost = null;
    HttpGet httpGet = null;
    UsernamePasswordCredentials creds = null;

    public HttpRequest(String login, String password) {
        if (login != null || password != null) {
            this.creds = new UsernamePasswordCredentials(login, password);
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)ACRA.getConfig().socketTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)ACRA.getConfig().socketTimeout());
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)new PlainSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)new FakeSocketFactory(), 443));
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager((HttpParams)httpParams, registry), (HttpParams)httpParams);
        this.localContext = new BasicHttpContext();
    }

    public void clearCookies() {
        this.httpClient.getCookieStore().clear();
    }

    public void abort() {
        try {
            if (this.httpClient != null) {
                Log.d((String)ACRA.LOG_TAG, (String)"Abort HttpClient request.");
                this.httpPost.abort();
            }
        }
        catch (Exception e) {
            Log.e((String)ACRA.LOG_TAG, (String)"Error while aborting HttpClient request", (Throwable)e);
        }
    }

    public String sendPost(String url, String data) throws ClientProtocolException, IOException {
        return this.sendPost(url, data, null);
    }

    public String sendPost(String url, String data, String contentType) throws ClientProtocolException, IOException {
        String ret;
        this.httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        this.httpPost = new HttpPost(url);
        Log.d((String)ACRA.LOG_TAG, (String)"Setting httpPost headers");
        if (this.creds != null) {
            this.httpPost.addHeader(BasicScheme.authenticate((Credentials)this.creds, (String)"UTF-8", (boolean)false));
        }
        this.httpPost.setHeader("User-Agent", "Android");
        this.httpPost.setHeader("Accept", "text/html,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        if (contentType != null) {
            this.httpPost.setHeader("Content-Type", contentType);
        } else {
            this.httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        StringEntity tmp = new StringEntity(data, "UTF-8");
        this.httpPost.setEntity((HttpEntity)tmp);
        Log.d((String)ACRA.LOG_TAG, (String)("Sending request to " + url));
        HttpResponse response = this.httpClient.execute((HttpUriRequest)this.httpPost, this.localContext);
        if (response != null) {
            String statusCode;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null && ((statusCode = Integer.toString(response.getStatusLine().getStatusCode())).startsWith("4") || statusCode.startsWith("5"))) {
                throw new IOException("Host returned error code " + statusCode);
            }
            ret = EntityUtils.toString((HttpEntity)response.getEntity());
        } else {
            ret = null;
        }
        return ret;
    }

    public String sendGet(String url) throws ClientProtocolException, IOException {
        this.httpGet = new HttpGet(url);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)this.httpGet);
        String ret = EntityUtils.toString((HttpEntity)response.getEntity());
        return ret;
    }

    public InputStream getHttpStream(String urlString) throws IOException {
        InputStream in = null;
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException("Not an HTTP connection");
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            httpConn.setAllowUserInteraction(false);
            httpConn.setInstanceFollowRedirects(true);
            httpConn.setRequestMethod("GET");
            httpConn.connect();
            int response = httpConn.getResponseCode();
            if (response == 200) {
                in = httpConn.getInputStream();
            }
        }
        catch (Exception e) {
            throw new IOException("Error connecting");
        }
        return in;
    }
}

