/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import java.lang.reflect.Method;
import org.acra.ACRA;
import org.acra.Compatibility;

public class DeviceFeaturesCollector {
    public static String getFeatures(Context ctx) {
        if (Compatibility.getAPILevel() >= 5) {
            StringBuffer result = new StringBuffer();
            PackageManager pm = ctx.getPackageManager();
            try {
                Object[] features;
                Method getSystemAvailableFeatures = PackageManager.class.getMethod("getSystemAvailableFeatures", null);
                for (Object feature : features = (Object[])getSystemAvailableFeatures.invoke((Object)pm, new Object[0])) {
                    String featureName = (String)feature.getClass().getField("name").get(feature);
                    if (featureName != null) {
                        result.append(featureName);
                    } else {
                        Method getGlEsVersion = feature.getClass().getMethod("getGlEsVersion", null);
                        String glEsVersion = (String)getGlEsVersion.invoke(feature, new Object[0]);
                        result.append("glEsVersion = ");
                        result.append(glEsVersion);
                    }
                    result.append("\n");
                }
            }
            catch (Throwable e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
                result.append("Could not retrieve data: ");
                result.append(e.getMessage());
            }
            return result.toString();
        }
        return "Data available only with API Level > 5";
    }
}

