/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.format.Time;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.acra.ACRA;
import org.acra.ConfigurationInspector;
import org.acra.CrashReportData;
import org.acra.CrashReportDialog;
import org.acra.DeviceFeaturesCollector;
import org.acra.DropBoxCollector;
import org.acra.DumpSysCollector;
import org.acra.LogCatCollector;
import org.acra.ReflectionCollector;
import org.acra.ReportField;
import org.acra.ReportingInteractionMode;
import org.acra.SettingsCollector;
import org.acra.SharedPreferencesCollector;
import org.acra.annotation.ReportsCrashes;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.Installation;

public class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    public static final String REPORTFILE_EXTENSION = ".stacktrace";
    private static boolean enabled = false;
    private static ArrayList<ReportSender> mReportSenders = new ArrayList();
    private static final int MAX_SEND_REPORTS = 5;
    private static CrashReportData mCrashProperties = new CrashReportData();
    Map<String, String> mCustomParameters = new HashMap<String, String>();
    static final String SILENT_SUFFIX = "-" + (Object)((Object)ReportField.IS_SILENT);
    static final String APPROVED_SUFFIX = "-approved";
    static final String EXTRA_REPORT_FILE_NAME = "REPORT_FILE_NAME";
    private Thread.UncaughtExceptionHandler mDfltExceptionHandler;
    private static ErrorReporter mInstanceSingleton;
    private static Context mContext;
    private String mInitialConfiguration;
    private ReportingInteractionMode mReportingInteractionMode = ReportingInteractionMode.SILENT;

    public void approvePendingReports() {
        Log.d((String)ACRA.LOG_TAG, (String)"Mark all pending reports as approved.");
        String[] reportFileNames = this.getCrashReportFilesList();
        File reportFile = null;
        for (String reportFileName : reportFileNames) {
            if (this.isApproved(reportFileName)) continue;
            reportFile = new File(mContext.getFilesDir(), reportFileName);
            String newName = reportFileName.replace(REPORTFILE_EXTENSION, "-approved.stacktrace");
            reportFile.renameTo(new File(mContext.getFilesDir(), newName));
        }
    }

    @Deprecated
    public void addCustomData(String key, String value) {
        this.mCustomParameters.put(key, value);
    }

    public String putCustomData(String key, String value) {
        return this.mCustomParameters.put(key, value);
    }

    public String removeCustomData(String key) {
        return this.mCustomParameters.remove(key);
    }

    public String getCustomData(String key) {
        return this.mCustomParameters.get(key);
    }

    private String createCustomInfoString() {
        String CustomInfo = "";
        for (String CurrentKey : this.mCustomParameters.keySet()) {
            String CurrentVal = this.mCustomParameters.get(CurrentKey);
            CustomInfo = CustomInfo + CurrentKey + " = " + CurrentVal + "\n";
        }
        return CustomInfo;
    }

    public static ErrorReporter getInstance() {
        if (mInstanceSingleton == null) {
            mInstanceSingleton = new ErrorReporter();
        }
        return mInstanceSingleton;
    }

    public void init(Context context) {
        if (this.mDfltExceptionHandler == null) {
            this.mDfltExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            enabled = true;
            Thread.setDefaultUncaughtExceptionHandler(this);
            mContext = context;
            this.mInitialConfiguration = ConfigurationInspector.toString(mContext.getResources().getConfiguration());
        }
    }

    private static long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    private static long getTotalInternalMemorySize() {
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long totalBlocks = stat.getBlockCount();
        return totalBlocks * blockSize;
    }

    private void retrieveCrashData(Context context) {
        try {
            PackageInfo pi;
            PackageManager pm;
            ReportsCrashes config = ACRA.getConfig();
            ReportField[] fields = config.customReportContent();
            if (fields.length == 0) {
                if (config.mailTo() == null || "".equals(config.mailTo())) {
                    fields = ACRA.DEFAULT_REPORT_FIELDS;
                } else if (!"".equals(config.mailTo())) {
                    fields = ACRA.DEFAULT_MAIL_REPORT_FIELDS;
                }
            }
            List<ReportField> fieldsList = Arrays.asList(fields);
            SharedPreferences prefs = ACRA.getACRASharedPreferences();
            if (fieldsList.contains((Object)ReportField.REPORT_ID)) {
                mCrashProperties.put(ReportField.REPORT_ID, UUID.randomUUID().toString());
            }
            if (fieldsList.contains((Object)ReportField.DUMPSYS_MEMINFO)) {
                mCrashProperties.put(ReportField.DUMPSYS_MEMINFO, DumpSysCollector.collectMemInfo());
            }
            if ((pm = context.getPackageManager()) != null) {
                TelephonyManager tm;
                String deviceId;
                if (prefs.getBoolean("acra.syslog.enable", true) && pm.checkPermission("android.permission.READ_LOGS", context.getPackageName()) == 0) {
                    Log.i((String)ACRA.LOG_TAG, (String)"READ_LOGS granted! ACRA can include LogCat and DropBox data.");
                    if (fieldsList.contains((Object)ReportField.LOGCAT)) {
                        mCrashProperties.put(ReportField.LOGCAT, LogCatCollector.collectLogCat(null).toString());
                    }
                    if (fieldsList.contains((Object)ReportField.EVENTSLOG)) {
                        mCrashProperties.put(ReportField.EVENTSLOG, LogCatCollector.collectLogCat("events").toString());
                    }
                    if (fieldsList.contains((Object)ReportField.RADIOLOG)) {
                        mCrashProperties.put(ReportField.RADIOLOG, LogCatCollector.collectLogCat("radio").toString());
                    }
                    if (fieldsList.contains((Object)ReportField.DROPBOX)) {
                        mCrashProperties.put(ReportField.DROPBOX, DropBoxCollector.read(mContext, ACRA.getConfig().additionalDropBoxTags()));
                    }
                } else {
                    Log.i((String)ACRA.LOG_TAG, (String)"READ_LOGS not allowed. ACRA will not include LogCat and DropBox data.");
                }
                if (fieldsList.contains((Object)ReportField.DEVICE_ID) && prefs.getBoolean("acra.deviceid.enable", true) && pm.checkPermission("android.permission.READ_PHONE_STATE", context.getPackageName()) == 0 && (deviceId = (tm = (TelephonyManager)context.getSystemService("phone")).getDeviceId()) != null) {
                    mCrashProperties.put(ReportField.DEVICE_ID, deviceId);
                }
            }
            if (fieldsList.contains((Object)ReportField.INSTALLATION_ID)) {
                mCrashProperties.put(ReportField.INSTALLATION_ID, Installation.id(mContext));
            }
            if (fieldsList.contains((Object)ReportField.INITIAL_CONFIGURATION)) {
                mCrashProperties.put(ReportField.INITIAL_CONFIGURATION, this.mInitialConfiguration);
            }
            if (fieldsList.contains((Object)ReportField.CRASH_CONFIGURATION)) {
                Configuration crashConf = context.getResources().getConfiguration();
                mCrashProperties.put(ReportField.CRASH_CONFIGURATION, ConfigurationInspector.toString(crashConf));
            }
            if ((pi = pm.getPackageInfo(context.getPackageName(), 0)) != null) {
                if (fieldsList.contains((Object)ReportField.APP_VERSION_CODE)) {
                    mCrashProperties.put(ReportField.APP_VERSION_CODE, Integer.toString(pi.versionCode));
                }
                if (fieldsList.contains((Object)ReportField.APP_VERSION_NAME)) {
                    mCrashProperties.put(ReportField.APP_VERSION_NAME, pi.versionName != null ? pi.versionName : "not set");
                }
            } else {
                mCrashProperties.put(ReportField.APP_VERSION_NAME, "Package info unavailable");
            }
            if (fieldsList.contains((Object)ReportField.PACKAGE_NAME)) {
                mCrashProperties.put(ReportField.PACKAGE_NAME, context.getPackageName());
            }
            if (fieldsList.contains((Object)ReportField.BUILD)) {
                mCrashProperties.put(ReportField.BUILD, ReflectionCollector.collectConstants(Build.class));
            }
            if (fieldsList.contains((Object)ReportField.PHONE_MODEL)) {
                mCrashProperties.put(ReportField.PHONE_MODEL, Build.MODEL);
            }
            if (fieldsList.contains((Object)ReportField.ANDROID_VERSION)) {
                mCrashProperties.put(ReportField.ANDROID_VERSION, Build.VERSION.RELEASE);
            }
            if (fieldsList.contains((Object)ReportField.BRAND)) {
                mCrashProperties.put(ReportField.BRAND, Build.BRAND);
            }
            if (fieldsList.contains((Object)ReportField.PRODUCT)) {
                mCrashProperties.put(ReportField.PRODUCT, Build.PRODUCT);
            }
            if (fieldsList.contains((Object)ReportField.TOTAL_MEM_SIZE)) {
                mCrashProperties.put(ReportField.TOTAL_MEM_SIZE, Long.toString(ErrorReporter.getTotalInternalMemorySize()));
            }
            if (fieldsList.contains((Object)ReportField.AVAILABLE_MEM_SIZE)) {
                mCrashProperties.put(ReportField.AVAILABLE_MEM_SIZE, Long.toString(ErrorReporter.getAvailableInternalMemorySize()));
            }
            if (fieldsList.contains((Object)ReportField.FILE_PATH)) {
                mCrashProperties.put(ReportField.FILE_PATH, context.getFilesDir().getAbsolutePath());
            }
            if (fieldsList.contains((Object)ReportField.DISPLAY)) {
                Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
                mCrashProperties.put(ReportField.DISPLAY, ErrorReporter.toString(display));
            }
            if (fieldsList.contains((Object)ReportField.USER_CRASH_DATE)) {
                Time curDate = new Time();
                curDate.setToNow();
                mCrashProperties.put(ReportField.USER_CRASH_DATE, curDate.format3339(false));
            }
            if (fieldsList.contains((Object)ReportField.CUSTOM_DATA)) {
                mCrashProperties.put(ReportField.CUSTOM_DATA, this.createCustomInfoString());
            }
            if (fieldsList.contains((Object)ReportField.USER_EMAIL)) {
                mCrashProperties.put(ReportField.USER_EMAIL, prefs.getString("acra.user.email", "N/A"));
            }
            if (fieldsList.contains((Object)ReportField.DEVICE_FEATURES)) {
                mCrashProperties.put(ReportField.DEVICE_FEATURES, DeviceFeaturesCollector.getFeatures(context));
            }
            if (fieldsList.contains((Object)ReportField.ENVIRONMENT)) {
                mCrashProperties.put(ReportField.ENVIRONMENT, ReflectionCollector.collectStaticGettersResults(Environment.class));
            }
            if (fieldsList.contains((Object)ReportField.SETTINGS_SYSTEM)) {
                mCrashProperties.put(ReportField.SETTINGS_SYSTEM, SettingsCollector.collectSystemSettings(mContext));
            }
            if (fieldsList.contains((Object)ReportField.SETTINGS_SECURE)) {
                mCrashProperties.put(ReportField.SETTINGS_SECURE, SettingsCollector.collectSecureSettings(mContext));
            }
            if (fieldsList.contains((Object)ReportField.SHARED_PREFERENCES)) {
                mCrashProperties.put(ReportField.SHARED_PREFERENCES, SharedPreferencesCollector.collect(mContext));
            }
        }
        catch (Exception e) {
            Log.e((String)ACRA.LOG_TAG, (String)"Error while retrieving crash data", (Throwable)e);
        }
    }

    private static String toString(Display display) {
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        StringBuilder result = new StringBuilder();
        result.append("width=").append(display.getWidth()).append('\n').append("height=").append(display.getHeight()).append('\n').append("pixelFormat=").append(display.getPixelFormat()).append('\n').append("refreshRate=").append(display.getRefreshRate()).append("fps").append('\n').append("metrics.density=x").append(metrics.density).append('\n').append("metrics.scaledDensity=x").append(metrics.scaledDensity).append('\n').append("metrics.widthPixels=").append(metrics.widthPixels).append('\n').append("metrics.heightPixels=").append(metrics.heightPixels).append('\n').append("metrics.xdpi=").append(metrics.xdpi).append('\n').append("metrics.ydpi=").append(metrics.ydpi);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Log.e((String)ACRA.LOG_TAG, (String)("ACRA caught a " + e.getClass().getSimpleName() + " exception for " + mContext.getPackageName() + ". Building report."));
        mCrashProperties.remove((Object)ReportField.IS_SILENT);
        ReportsSenderWorker worker = this.handleException(e);
        if (this.mReportingInteractionMode == ReportingInteractionMode.TOAST) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e1) {
                Log.e((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e1);
            }
        }
        if (worker != null) {
            while (worker.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    Log.e((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e1);
                }
            }
        }
        if (this.mReportingInteractionMode == ReportingInteractionMode.SILENT || this.mReportingInteractionMode == ReportingInteractionMode.TOAST && ACRA.getConfig().forceCloseDialogAfterToast()) {
            this.mDfltExceptionHandler.uncaughtException(t, e);
        } else {
            CharSequence appName = "Application";
            try {
                PackageManager pm = mContext.getPackageManager();
                appName = pm.getApplicationInfo(mContext.getPackageName(), 0).loadLabel(mContext.getPackageManager());
                Log.e((String)ACRA.LOG_TAG, (String)(appName + " fatal error : " + e.getMessage()), (Throwable)e);
            }
            catch (PackageManager.NameNotFoundException e2) {
                Log.e((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e2);
            }
            finally {
                Process.killProcess((int)Process.myPid());
                System.exit(10);
            }
        }
    }

    ReportsSenderWorker handleException(Throwable e, ReportingInteractionMode reportingInteractionMode) {
        boolean sendOnlySilentReports = false;
        if (reportingInteractionMode == null) {
            reportingInteractionMode = this.mReportingInteractionMode;
        } else if (reportingInteractionMode == ReportingInteractionMode.SILENT && this.mReportingInteractionMode != ReportingInteractionMode.SILENT) {
            sendOnlySilentReports = true;
        }
        if (e == null) {
            e = new Exception("Report requested by developer");
        }
        if (reportingInteractionMode == ReportingInteractionMode.TOAST || reportingInteractionMode == ReportingInteractionMode.NOTIFICATION && ACRA.getConfig().resToastText() != 0) {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    Toast.makeText((Context)mContext, (int)ACRA.getConfig().resToastText(), (int)1).show();
                    Looper.loop();
                }
            }.start();
        }
        this.retrieveCrashData(mContext);
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        Log.getStackTraceString((Throwable)e);
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        mCrashProperties.put(ReportField.STACK_TRACE, ((Object)result).toString());
        printWriter.close();
        String reportFileName = ErrorReporter.saveCrashReportFile(null, null);
        mCrashProperties.remove((Object)ReportField.IS_SILENT);
        mCrashProperties.remove((Object)ReportField.USER_COMMENT);
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || ACRA.getACRASharedPreferences().getBoolean("acra.alwaysaccept", false)) {
            this.approvePendingReports();
            ReportsSenderWorker wk = new ReportsSenderWorker(sendOnlySilentReports);
            Log.v((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #handleException");
            wk.start();
            return wk;
        }
        if (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
            this.notifySendReport(reportFileName);
        }
        return null;
    }

    public ReportsSenderWorker handleException(Throwable e) {
        return this.handleException(e, this.mReportingInteractionMode);
    }

    public Thread handleSilentException(Throwable e) {
        if (enabled) {
            mCrashProperties.put(ReportField.IS_SILENT, "true");
            ReportsSenderWorker result = this.handleException(e, ReportingInteractionMode.SILENT);
            return result;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"ACRA is disabled. Silent report not sent.");
        return null;
    }

    void notifySendReport(String reportFileName) {
        NotificationManager notificationManager = (NotificationManager)mContext.getSystemService("notification");
        ReportsCrashes conf = ACRA.getConfig();
        int icon = conf.resNotifIcon();
        CharSequence tickerText = mContext.getText(conf.resNotifTickerText());
        long when = System.currentTimeMillis();
        Notification notification = new Notification(icon, tickerText, when);
        CharSequence contentTitle = mContext.getText(conf.resNotifTitle());
        CharSequence contentText = mContext.getText(conf.resNotifText());
        Intent notificationIntent = new Intent(mContext, CrashReportDialog.class);
        Log.d((String)ACRA.LOG_TAG, (String)("Creating Notification for " + reportFileName));
        notificationIntent.putExtra(EXTRA_REPORT_FILE_NAME, reportFileName);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)mContext, (int)0, (Intent)notificationIntent, (int)0x8000000);
        notification.setLatestEventInfo(mContext, contentTitle, contentText, contentIntent);
        notificationManager.cancelAll();
        notificationManager.notify(666, notification);
    }

    private static void sendCrashReport(Context context, CrashReportData errorContent) throws ReportSenderException {
        boolean sentAtLeastOnce = false;
        for (ReportSender sender : mReportSenders) {
            try {
                sender.send(errorContent);
                sentAtLeastOnce = true;
            }
            catch (ReportSenderException e) {
                if (!sentAtLeastOnce) {
                    throw e;
                }
                Log.w((String)ACRA.LOG_TAG, (String)("ReportSender of class " + sender.getClass().getName() + " failed but other senders completed their task. ACRA will not send this report again."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String saveCrashReportFile(String fileName, CrashReportData crashData) {
        try {
            Log.d((String)ACRA.LOG_TAG, (String)"Writing crash report file.");
            if (crashData == null) {
                crashData = mCrashProperties;
            }
            if (fileName == null) {
                Time now = new Time();
                now.setToNow();
                long timestamp = now.toMillis(false);
                String isSilent = crashData.getProperty(ReportField.IS_SILENT);
                fileName = "" + timestamp + (isSilent != null ? SILENT_SUFFIX : "") + REPORTFILE_EXTENSION;
            }
            FileOutputStream reportFile = mContext.openFileOutput(fileName, 0);
            try {
                crashData.store(reportFile, "");
            }
            finally {
                reportFile.close();
            }
            return fileName;
        }
        catch (Exception e) {
            Log.e((String)ACRA.LOG_TAG, (String)"An error occured while writing the report file...", (Throwable)e);
            return null;
        }
    }

    String[] getCrashReportFilesList() {
        if (mContext == null) {
            Log.e((String)ACRA.LOG_TAG, (String)"Trying to get ACRA reports but ACRA is not initialized.");
            return new String[0];
        }
        File dir = mContext.getFilesDir();
        if (dir != null) {
            Log.d((String)ACRA.LOG_TAG, (String)("Looking for error files in " + dir.getAbsolutePath()));
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(ErrorReporter.REPORTFILE_EXTENSION);
                }
            };
            String[] result = dir.list(filter);
            return result == null ? new String[]{} : result;
        }
        Log.w((String)ACRA.LOG_TAG, (String)"Application files directory does not exist! The application may not be installed correctly. Please try reinstalling.");
        return new String[0];
    }

    synchronized void checkAndSendReports(Context context, boolean sendOnlySilentReports) {
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - start");
        Object[] reportFiles = this.getCrashReportFilesList();
        Arrays.sort(reportFiles);
        int reportsSentCount = 0;
        for (Object curFileName : reportFiles) {
            if (sendOnlySilentReports && !this.isSilent((String)curFileName)) continue;
            if (reportsSentCount >= 5) break;
            Log.i((String)ACRA.LOG_TAG, (String)("Sending file " + (String)curFileName));
            try {
                CrashReportData previousCrashReport = this.loadCrashReport(context, (String)curFileName);
                ErrorReporter.sendCrashReport(context, previousCrashReport);
                this.deleteFile(context, (String)curFileName);
            }
            catch (RuntimeException e) {
                Log.e((String)ACRA.LOG_TAG, (String)"Failed to send crash reports", (Throwable)e);
                this.deleteFile(context, (String)curFileName);
                break;
            }
            catch (IOException e) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to load crash report for " + (String)curFileName), (Throwable)e);
                this.deleteFile(context, (String)curFileName);
                break;
            }
            catch (ReportSenderException e) {
                Log.e((String)ACRA.LOG_TAG, (String)("Failed to send crash report for " + (String)curFileName), (Throwable)e);
                break;
            }
            ++reportsSentCount;
        }
        Log.d((String)ACRA.LOG_TAG, (String)"#checkAndSendReports - finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CrashReportData loadCrashReport(Context context, String fileName) throws IOException {
        CrashReportData crashReport = new CrashReportData();
        FileInputStream input = context.openFileInput(fileName);
        try {
            crashReport.load(input);
        }
        finally {
            input.close();
        }
        return crashReport;
    }

    private void deleteFile(Context context, String fileName) {
        boolean deleted = context.deleteFile(fileName);
        if (!deleted) {
            Log.w((String)ACRA.LOG_TAG, (String)("Could not deleted error report : " + fileName));
        }
    }

    void setReportingInteractionMode(ReportingInteractionMode reportingInteractionMode) {
        this.mReportingInteractionMode = reportingInteractionMode;
    }

    public void checkReportsOnApplicationStart() {
        String[] filesList = this.getCrashReportFilesList();
        if (filesList != null && filesList.length > 0) {
            boolean onlySilentOrApprovedReports = this.containsOnlySilentOrApprovedReports(filesList);
            if (this.mReportingInteractionMode == ReportingInteractionMode.SILENT || this.mReportingInteractionMode == ReportingInteractionMode.TOAST || this.mReportingInteractionMode == ReportingInteractionMode.NOTIFICATION && onlySilentOrApprovedReports) {
                if (this.mReportingInteractionMode == ReportingInteractionMode.TOAST && !onlySilentOrApprovedReports) {
                    Toast.makeText((Context)mContext, (int)ACRA.getConfig().resToastText(), (int)1).show();
                }
                Log.v((String)ACRA.LOG_TAG, (String)"About to start ReportSenderWorker from #checkReportOnApplicationStart");
                new ReportsSenderWorker().start();
            } else if (ACRA.getConfig().deleteUnapprovedReportsOnApplicationStart()) {
                ErrorReporter.getInstance().deletePendingNonApprovedReports();
            } else {
                ErrorReporter.getInstance().notifySendReport(this.getLatestNonSilentReport(filesList));
            }
        }
    }

    private String getLatestNonSilentReport(String[] filesList) {
        if (filesList != null && filesList.length > 0) {
            for (int i = filesList.length - 1; i >= 0; --i) {
                if (this.isSilent(filesList[i])) continue;
                return filesList[i];
            }
            return filesList[filesList.length - 1];
        }
        return null;
    }

    public void deletePendingReports() {
        this.deletePendingReports(true, true, 0);
    }

    public void deletePendingSilentReports() {
        this.deletePendingReports(true, false, 0);
    }

    public void deletePendingNonApprovedReports() {
        int nbReportsToKeep = this.mReportingInteractionMode == ReportingInteractionMode.NOTIFICATION ? 1 : 0;
        this.deletePendingReports(false, true, nbReportsToKeep);
    }

    private void deletePendingReports(boolean deleteApprovedReports, boolean deleteNonApprovedReports, int nbOfLatestToKeep) {
        Object[] filesList = this.getCrashReportFilesList();
        Arrays.sort(filesList);
        if (filesList != null) {
            boolean isReportApproved = false;
            for (int iFile = 0; iFile < filesList.length - nbOfLatestToKeep; ++iFile) {
                Object fileName = filesList[iFile];
                isReportApproved = this.isApproved((String)fileName);
                if ((!isReportApproved || !deleteApprovedReports) && (isReportApproved || !deleteNonApprovedReports)) continue;
                new File(mContext.getFilesDir(), (String)fileName).delete();
            }
        }
    }

    public void disable() {
        if (mContext != null) {
            Log.d((String)ACRA.LOG_TAG, (String)("ACRA is disabled for " + mContext.getPackageName()));
        } else {
            Log.d((String)ACRA.LOG_TAG, (String)"ACRA is disabled.");
        }
        if (this.mDfltExceptionHandler != null) {
            Thread.setDefaultUncaughtExceptionHandler(this.mDfltExceptionHandler);
            enabled = false;
        }
    }

    private boolean containsOnlySilentOrApprovedReports(String[] reportFileNames) {
        for (String reportFileName : reportFileNames) {
            if (this.isApproved(reportFileName)) continue;
            return false;
        }
        return true;
    }

    private boolean isSilent(String reportFileName) {
        return reportFileName.contains(SILENT_SUFFIX);
    }

    private boolean isApproved(String reportFileName) {
        return this.isSilent(reportFileName) || reportFileName.contains(APPROVED_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addUserDataToReport(Context context, String commentedReportFileName, String userComment, String userEmail) {
        Log.d((String)ACRA.LOG_TAG, (String)("Add user comment to " + commentedReportFileName));
        if (commentedReportFileName != null && userComment != null) {
            try {
                FileInputStream input = context.openFileInput(commentedReportFileName);
                CrashReportData commentedCrashReport = new CrashReportData();
                try {
                    Log.d((String)ACRA.LOG_TAG, (String)"Loading Properties report to insert user comment.");
                    commentedCrashReport.load(input);
                }
                finally {
                    input.close();
                }
                commentedCrashReport.put(ReportField.USER_COMMENT, userComment);
                commentedCrashReport.put(ReportField.USER_EMAIL, userEmail == null ? "" : userEmail);
                ErrorReporter.saveCrashReportFile(commentedReportFileName, commentedCrashReport);
            }
            catch (FileNotFoundException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"User comment not added: ", (Throwable)e);
            }
            catch (InvalidPropertiesFormatException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"User comment not added: ", (Throwable)e);
            }
            catch (IOException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"User comment not added: ", (Throwable)e);
            }
        }
    }

    public void addReportSender(ReportSender sender) {
        mReportSenders.add(sender);
    }

    public void removeReportSender(ReportSender sender) {
        mReportSenders.remove(sender);
    }

    public void removeReportSenders(Class<?> senderClass) {
        if (ReportSender.class.isAssignableFrom(senderClass)) {
            for (ReportSender sender : mReportSenders) {
                if (!senderClass.isInstance(sender)) continue;
                mReportSenders.remove(sender);
            }
        }
    }

    public void removeAllReportSenders() {
        mReportSenders.clear();
    }

    public void setReportSender(ReportSender sender) {
        this.removeAllReportSenders();
        this.addReportSender(sender);
    }

    public void setAppStartDate(Time appStartDate) {
        mCrashProperties.put(ReportField.USER_APP_START_DATE, appStartDate.format3339(false));
    }

    final class ReportsSenderWorker
    extends Thread {
        private String mCommentedReportFileName = null;
        private String mUserComment = null;
        private String mUserEmail = null;
        private boolean mSendOnlySilentReports = false;
        private boolean mApprovePendingReports = false;

        public ReportsSenderWorker(boolean sendOnlySilentReports) {
            this.mSendOnlySilentReports = sendOnlySilentReports;
        }

        public ReportsSenderWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PowerManager.WakeLock wakeLock = this.acquireWakeLock();
            try {
                if (this.mApprovePendingReports) {
                    ErrorReporter.this.approvePendingReports();
                    this.mCommentedReportFileName = this.mCommentedReportFileName.replace(ErrorReporter.REPORTFILE_EXTENSION, "-approved.stacktrace");
                }
                ErrorReporter.addUserDataToReport(mContext, this.mCommentedReportFileName, this.mUserComment, this.mUserEmail);
                ErrorReporter.this.checkAndSendReports(mContext, this.mSendOnlySilentReports);
            }
            finally {
                if (wakeLock != null) {
                    wakeLock.release();
                }
            }
        }

        private PowerManager.WakeLock acquireWakeLock() {
            boolean hasPermission;
            PackageManager pm = mContext.getPackageManager();
            boolean bl = pm != null ? pm.checkPermission("android.permission.WAKE_LOCK", mContext.getPackageName()) == 0 : (hasPermission = false);
            if (!hasPermission) {
                return null;
            }
            PowerManager powerManager = (PowerManager)mContext.getSystemService("power");
            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "ACRA wakelock");
            wakeLock.acquire();
            return wakeLock;
        }

        void setUserComment(String reportFileName, String userComment) {
            this.mCommentedReportFileName = reportFileName;
            this.mUserComment = userComment;
        }

        void setUserEmail(String reportFileName, String userEmail) {
            this.mCommentedReportFileName = reportFileName;
            this.mUserEmail = userEmail;
        }

        public void setApprovePendingReports() {
            this.mApprovePendingReports = true;
        }
    }
}

