/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Log;
import java.lang.reflect.Field;
import org.acra.ACRA;

public class SettingsCollector {
    public static String collectSystemSettings(Context ctx) {
        Field[] keys;
        StringBuilder result = new StringBuilder();
        for (Field key : keys = Settings.System.class.getFields()) {
            if (key.isAnnotationPresent(Deprecated.class) || key.getType() != String.class) continue;
            try {
                String value = Settings.System.getString((ContentResolver)ctx.getContentResolver(), (String)((String)key.get(null)));
                if (value == null) continue;
                result.append(key.getName()).append("=").append((Object)value).append("\n");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
        }
        return result.toString();
    }

    public static String collectSecureSettings(Context ctx) {
        Field[] keys;
        StringBuilder result = new StringBuilder();
        for (Field key : keys = Settings.Secure.class.getFields()) {
            if (key.isAnnotationPresent(Deprecated.class) || key.getType() != String.class || !SettingsCollector.isAuthorized(key)) continue;
            try {
                String value = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)((String)key.get(null)));
                if (value == null) continue;
                result.append(key.getName()).append("=").append((Object)value).append("\n");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)ACRA.LOG_TAG, (String)"Error : ", (Throwable)e);
            }
        }
        return result.toString();
    }

    private static boolean isAuthorized(Field key) {
        return key != null && !key.getName().startsWith("WIFI_AP");
    }
}

