/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.content.Intent;
import org.acra.ACRA;
import org.acra.CrashReportData;
import org.acra.ReportField;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;

public class EmailIntentSender
implements ReportSender {
    Context mContext = null;

    public EmailIntentSender(Context ctx) {
        this.mContext = ctx;
    }

    @Override
    public void send(CrashReportData errorContent) throws ReportSenderException {
        Intent emailIntent = new Intent("android.intent.action.SEND");
        emailIntent.addFlags(0x10000000);
        emailIntent.setType("text/plain");
        String subject = (String)errorContent.get((Object)ReportField.PACKAGE_NAME) + " Crash Report";
        String body = this.buildBody(errorContent);
        emailIntent.putExtra("android.intent.extra.SUBJECT", subject);
        emailIntent.putExtra("android.intent.extra.TEXT", body);
        emailIntent.putExtra("android.intent.extra.EMAIL", new String[]{ACRA.getConfig().mailTo()});
        this.mContext.startActivity(emailIntent);
    }

    private String buildBody(CrashReportData errorContent) {
        StringBuilder builder = new StringBuilder();
        ReportField[] fields = ACRA.getConfig().customReportContent();
        if (fields.length == 0) {
            fields = ACRA.DEFAULT_MAIL_REPORT_FIELDS;
        }
        for (ReportField field : fields) {
            builder.append(field.toString()).append("=");
            builder.append((String)errorContent.get((Object)field));
            builder.append('\n');
        }
        return builder.toString();
    }
}

