/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools;

import android.content.Context;
import android.util.Log;
import com.stericson.RootTools.InternalMethods;
import com.stericson.RootTools.RootTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class Installer {
    private static final String LOG_TAG = "RootTools::Installer";
    private static final String BOGUS_FILE_NAME = "bogus";
    private Context context;
    private String filesPath;

    public Installer(Context context) throws IOException {
        this.context = context;
        this.filesPath = context.getFilesDir().getCanonicalPath();
    }

    protected boolean installBinary(int sourceId, String destName, String mode) {
        File mf = new File(String.valueOf(this.filesPath) + File.separator + destName);
        if (!mf.exists()) {
            try {
                FileInputStream fis = this.context.openFileInput(BOGUS_FILE_NAME);
                fis.close();
            }
            catch (FileNotFoundException e) {
                FileOutputStream fos = null;
                try {
                    try {
                        fos = this.context.openFileOutput(BOGUS_FILE_NAME, 0);
                        fos.write("justcreatedfilesdirectory".getBytes());
                    }
                    catch (Exception ex) {
                        if (RootTools.debugMode) {
                            Log.e((String)LOG_TAG, (String)ex.toString());
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                                this.context.deleteFile(BOGUS_FILE_NAME);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return false;
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                            this.context.deleteFile(BOGUS_FILE_NAME);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException ex) {
                if (RootTools.debugMode) {
                    Log.e((String)LOG_TAG, (String)ex.toString());
                }
                return false;
            }
            InputStream iss = this.context.getResources().openRawResource(sourceId);
            FileOutputStream oss = null;
            try {
                oss = new FileOutputStream(mf);
                byte[] buffer = new byte[4096];
                try {
                    int len;
                    while (-1 != (len = iss.read(buffer))) {
                        oss.write(buffer, 0, len);
                    }
                }
                catch (IOException ex) {
                    if (RootTools.debugMode) {
                        Log.e((String)LOG_TAG, (String)ex.toString());
                    }
                    if (oss != null) {
                        try {
                            oss.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return false;
                }
            }
            catch (FileNotFoundException ex) {
                if (RootTools.debugMode) {
                    Log.e((String)LOG_TAG, (String)ex.toString());
                }
                return false;
            }
            finally {
                if (oss != null) {
                    try {
                        oss.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                iss.close();
            }
            catch (IOException ex) {
                if (RootTools.debugMode) {
                    Log.e((String)LOG_TAG, (String)ex.toString());
                }
                return false;
            }
            InternalMethods.instance().doExec(new String[]{"chmod " + mode + " " + this.filesPath + File.separator + destName});
        }
        return true;
    }
}

