/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools;

import android.util.Log;
import com.stericson.RootTools.InternalMethods;
import com.stericson.RootTools.InternalVariables;
import com.stericson.RootTools.Mount;
import com.stericson.RootTools.RootTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

class Remounter {
    Remounter() {
    }

    protected boolean remount(String file, String mountType) {
        if (file.endsWith("/")) {
            file = file.substring(0, file.lastIndexOf("/"));
        }
        boolean foundMount = false;
        while (!foundMount) {
            try {
                for (Mount mount : RootTools.getMounts()) {
                    RootTools.log(mount.mountPoint.toString());
                    if (!file.equals(mount.mountPoint.toString())) continue;
                    foundMount = true;
                    break;
                }
            }
            catch (Exception e) {
                if (RootTools.debugMode) {
                    e.printStackTrace();
                }
                return false;
            }
            if (foundMount) continue;
            try {
                file = new File(file).getParent().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        Mount mountPoint = this.findMountPointRecursive(file);
        Log.i((String)InternalVariables.TAG, (String)("Remounting " + mountPoint.mountPoint.getAbsolutePath() + " as " + mountType.toLowerCase()));
        boolean isMountMode = mountPoint.flags.contains(mountType.toLowerCase());
        if (!isMountMode) {
            InternalMethods.instance().doExec(new String[]{String.format("mount -o remount,%s %s %s", mountType.toLowerCase(), mountPoint.device.getAbsolutePath(), mountPoint.mountPoint.getAbsolutePath())});
            RootTools.log(String.format("mount -o remount,%s %s %s", mountType.toLowerCase(), mountPoint.device.getAbsolutePath(), mountPoint.mountPoint.getAbsolutePath()));
            mountPoint = this.findMountPointRecursive(file);
        }
        Log.i((String)InternalVariables.TAG, (String)(mountPoint.flags + " AND " + mountType.toLowerCase()));
        if (mountPoint.flags.contains(mountType.toLowerCase())) {
            RootTools.log(mountPoint.flags.toString());
            return true;
        }
        RootTools.log(mountPoint.flags.toString());
        return false;
    }

    private Mount findMountPointRecursive(String file) {
        try {
            ArrayList<Mount> mounts = RootTools.getMounts();
            File path = new File(file);
            while (path != null) {
                for (Mount mount : mounts) {
                    if (!mount.mountPoint.equals(path)) continue;
                    return mount;
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            if (RootTools.debugMode) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

