/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootTools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.stericson.RootTools.Executer;
import com.stericson.RootTools.IResult;
import com.stericson.RootTools.Installer;
import com.stericson.RootTools.InternalMethods;
import com.stericson.RootTools.InternalVariables;
import com.stericson.RootTools.Mount;
import com.stericson.RootTools.Remounter;
import com.stericson.RootTools.RootToolsException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RootTools {
    public static boolean debugMode = false;

    public static Set<String> getPath() throws Exception {
        if (InternalVariables.path != null) {
            return InternalVariables.path;
        }
        if (InternalMethods.instance().returnPath()) {
            return InternalVariables.path;
        }
        throw new Exception();
    }

    public static ArrayList<Mount> getMounts() throws Exception {
        InternalVariables.mounts = InternalMethods.instance().getMounts();
        if (InternalVariables.mounts != null) {
            return InternalVariables.mounts;
        }
        throw new Exception();
    }

    public static void offerBusyBox(Activity activity) {
        Log.i((String)InternalVariables.TAG, (String)"Launching Market for BusyBox");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=stericson.busybox"));
        activity.startActivity(i);
    }

    public static Intent offerBusyBox(Activity activity, int requestCode) {
        Log.i((String)InternalVariables.TAG, (String)"Launching Market for BusyBox");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=stericson.busybox"));
        activity.startActivityForResult(i, requestCode);
        return i;
    }

    public static void offerSuperUser(Activity activity) {
        Log.i((String)InternalVariables.TAG, (String)"Launching Market for SuperUser");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=com.noshufou.android.su"));
        activity.startActivity(i);
    }

    public static Intent offerSuperUser(Activity activity, int requestCode) {
        Log.i((String)InternalVariables.TAG, (String)"Launching Market for SuperUser");
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)"market://details?id=com.noshufou.android.su"));
        activity.startActivityForResult(i, requestCode);
        return i;
    }

    @Deprecated
    public static boolean rootAvailable() {
        return RootTools.isRootAvailable();
    }

    public static boolean isRootAvailable() {
        String[] places;
        Log.i((String)InternalVariables.TAG, (String)"Checking for Root binary");
        String[] stringArray = places = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/"};
        int n = places.length;
        int n2 = 0;
        while (n2 < n) {
            String where = stringArray[n2];
            File file = new File(String.valueOf(where) + "su");
            if (file.exists()) {
                RootTools.log("Root was found here: " + where);
                return true;
            }
            RootTools.log("Root was NOT found here: " + where);
            ++n2;
        }
        return false;
    }

    @Deprecated
    public static boolean busyboxAvailable() {
        return RootTools.isBusyboxAvailable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBusyboxAvailable() {
        Log.i((String)InternalVariables.TAG, (String)"Checking for BusyBox");
        try {
            Iterator<String> iterator = RootTools.getPath().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                String paths = iterator.next();
                File file = new File(String.valueOf(paths) + "/busybox");
                if (file.exists()) {
                    RootTools.log("Found BusyBox here: " + paths);
                    return true;
                }
                RootTools.log("BusyBox was NOT found here: " + paths);
            }
        }
        catch (Exception e) {
            Log.i((String)InternalVariables.TAG, (String)"BusyBox was not found, more information MAY be available with Debugging on.");
            if (!debugMode) return false;
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static boolean accessGiven() {
        return RootTools.isAccessGiven();
    }

    public static boolean isAccessGiven() {
        Log.i((String)InternalVariables.TAG, (String)"Checking for Root access");
        InternalVariables.accessGiven = false;
        InternalMethods.instance().doExec(new String[]{"id"});
        return InternalVariables.accessGiven;
    }

    @Deprecated
    public static boolean EnoughSpaceOnSdCard(long updateSize) {
        return RootTools.hasEnoughSpaceOnSdCard(updateSize);
    }

    public static boolean hasEnoughSpaceOnSdCard(long updateSize) {
        Log.i((String)InternalVariables.TAG, (String)"Checking SDcard size and that it is mounted as RW");
        String status = Environment.getExternalStorageState();
        if (!status.equals("mounted")) {
            return false;
        }
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return updateSize < availableBlocks * blockSize;
    }

    public static boolean remount(String file, String mountType) {
        Remounter remounter = new Remounter();
        return remounter.remount(file, mountType);
    }

    public static boolean installBinary(Context context, int sourceId, String destName, String mode) {
        Installer installer;
        try {
            installer = new Installer(context);
        }
        catch (IOException ex) {
            if (debugMode) {
                ex.printStackTrace();
            }
            return false;
        }
        return installer.installBinary(sourceId, destName, mode);
    }

    public static boolean installBinary(Context context, int sourceId, String destName) {
        return RootTools.installBinary(context, sourceId, destName, "700");
    }

    public static List<String> sendShell(String[] commands, int sleepTime, Result result) throws IOException, InterruptedException, RootToolsException {
        if (debugMode) {
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                RootTools.log("Shell command: " + c);
                ++n2;
            }
        }
        return new Executer().sendShell(commands, sleepTime, result);
    }

    public static List<String> sendShell(String[] commands, int sleepTime) throws IOException, InterruptedException, RootToolsException {
        return RootTools.sendShell(commands, sleepTime, null);
    }

    public static List<String> sendShell(String command, Result result) throws IOException, InterruptedException, RootToolsException {
        return RootTools.sendShell(new String[]{command}, 0, result);
    }

    public static List<String> sendShell(String command) throws IOException, InterruptedException, RootToolsException {
        return RootTools.sendShell(command, null);
    }

    public static int getSpace(String path) {
        InternalVariables.getSpaceFor = path;
        boolean found = false;
        String[] commands = new String[]{"df"};
        InternalMethods.instance().doExec(commands);
        String[] stringArray = InternalVariables.space;
        int n = InternalVariables.space.length;
        int n2 = 0;
        while (n2 < n) {
            String spaceSearch = stringArray[n2];
            if (found) {
                String space = spaceSearch.substring(0, spaceSearch.length() - 1);
                return Integer.parseInt(space.trim());
            }
            if (spaceSearch.equals("used,")) {
                found = true;
            }
            ++n2;
        }
        return -1;
    }

    public static void log(String msg) {
        RootTools.log(null, msg);
    }

    public static void log(String TAG, String msg) {
        if (debugMode) {
            if (TAG != null) {
                Log.d((String)TAG, (String)msg);
            } else {
                Log.d((String)InternalVariables.TAG, (String)msg);
            }
        }
    }

    public static abstract class Result
    implements IResult {
        private Process process = null;
        private Serializable data = null;
        private int error = 0;

        @Override
        public abstract void process(String var1) throws Exception;

        @Override
        public abstract void onFailure(Exception var1);

        @Override
        public abstract void onComplete(int var1);

        @Override
        public Result setProcess(Process process) {
            this.process = process;
            return this;
        }

        @Override
        public Process getProcess() {
            return this.process;
        }

        @Override
        public Result setData(Serializable data) {
            this.data = data;
            return this;
        }

        @Override
        public Serializable getData() {
            return this.data;
        }

        @Override
        public Result setError(int error) {
            this.error = error;
            return this;
        }

        @Override
        public int getError() {
            return this.error;
        }
    }
}

