package be.md.swiss;

import java.util.HashSet;
import java.util.Set;

import be.md.swiss.exceptions.NotEnoughPlayersException;
import be.md.swiss.pairing.PairingEngine;
import be.md.swiss.pairing.Round;
import be.md.swiss.pairing.SwissEngine;

public class Tournament {

	private int numberOfRounds;
    private String name;
	private Set<Player> players = new HashSet<>();
	private PairingEngine pairingEngine = new SwissEngine();
	private SwissEngine engine = new SwissEngine();

    private int activeRound;

    public static Tournament createTournament(int numberOfRounds) {
        Tournament tournament = new Tournament();
        tournament.setRounds(numberOfRounds);
        return tournament;
    }
    

    public Tournament() {
    	
	}
    
    public SwissEngine getEngine() {
        return engine;
    }

    public void setEngine(SwissEngine Engine) {
        this.engine = Engine;
    }


    public int getActiveRound() {
        return activeRound;
    }

    public void setActiveRound(int activeRound) {
        this.activeRound = activeRound;
    }

    public Set<Player> getPlayers() {
        return players;
    }

    public void setPlayers(Set<Player> players) {
        this.players = players;
    }

    public int getNumberOfRounds() {
        return numberOfRounds;
    }

    public void setNumberOfRounds(int numberOfRounds) {
        this.numberOfRounds = numberOfRounds;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

	private void setRounds(int numberOfRounds) {
		this.numberOfRounds = numberOfRounds;
	}

	public int getRounds() {
		return numberOfRounds;
	}

	public void addPlayer(Player player) {
		players.add(player);
	}

	public int getNumberOfPlayers() {
		return players.size();
	}

	public Round pairNextRound() {
		validateIfThereAreEnoughPlayers();
		return engine.pairNextRound(players);

	}

    public Round pairNextRoundNotFirst() {
       // validateIfThereAreEnoughPlayers();
        return engine.pairGroupOfPlayers(activeRound, players);

    }

	private void validateIfThereAreEnoughPlayers() {
		int maxRoundsPossible = getMaxNumberOfRoundsPossible();

		if (maxRoundsPossible < numberOfRounds) {
			throw new NotEnoughPlayersException(players.size(), numberOfRounds);
		}

	}

	private int getMaxNumberOfRoundsPossible() {
		return (players.size() - 1);
	}

}
