/* * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/* Note that this class was based on the MorseConverter class that was
   borrowed in a unidirectional fashion from the Android developer doc examples
   and hacked on quite a bit.  Hooray for Apache-licensed examples! 
   
   Much of the background for the FH aspect of this project was found on 
   Frank Dörenberg (N4SPP)'s encyclopedic site about all things related to 
   that mode: http://www.nonstopsystems.com/radio/frank_radio_hell.htm
   
   In particular, the layout for the original 14x7 element font was adapted
   from a text file on that site: 
   http://www.nonstopsystems.com/radio/hell-keyboard-encoding.txt
*/

package com.templaro.opsiz.aka;

import java.util.HashMap;
import android.util.Log;

/** Class that implements the text to Feld Hellscreiber conversion */
class HellConverter {
	
	private static String TAG = "HellConverter";
	private static final HashMap<Character, HellBit[]> hell_map = new HashMap<Character, HellBit[]>();
	
	
	//Constructor -- no parameters
		public HellConverter() {
			buildMap1();
			buildMap2();
			/* the map is split up like this because the method will not compile with
			 * more than 64k characters. Zoiks.
			 */
		}
	
	private void buildMap1() {
		
		hell_map.put('A', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('B', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('C', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('D', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('E', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('F', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('G', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('H', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('I', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('J', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('K', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('L', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('M', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('N', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('O', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('P', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Q', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('R', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('S', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('T', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('U', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('V', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('W', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('X', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Y', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Z', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('0', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('1', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('2', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('3', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('4', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('5', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('6', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('7', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('8', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('9', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('/', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('?', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('-', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('+', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        	
        //extensions not in original Hellscreiber font
        //space -- note that space actually has some signal to keep a vox happy
        hell_map.put(' ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });	
        hell_map.put('.', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put(',', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('(', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put(')', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });         
	
	}
        
	private void buildMap2() {
        
        //extended Latin character set
        //Some are commented out because eclipse complains about the constructor code length > 64k
        hell_map.put('Ä', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Æ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ą', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('À', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Å', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ç', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ĉ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ć', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Š', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ð', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ś', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('È', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ł', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('É', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ę', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ĝ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ĥ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ĵ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ź', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ń', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ñ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ö', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ø', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ó', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ŝ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Þ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ü', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ŭ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ż', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        
        //Russian character set
        hell_map.put('А', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Б', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE});   	
        hell_map.put('В', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });      	
        hell_map.put('Г', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Д', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE }); 
        hell_map.put('Е', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ж', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('З', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('И', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Й', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('К', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Л', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('М', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Н', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('О', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('П', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Р', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('С', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Т', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('У', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ф', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Х', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ц', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ч', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ш', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Щ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ъ', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ы', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ь', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Э', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Ю', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        hell_map.put('Я', new HellBit [] { HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MARK,HellBit.MODMARK,HellBit.MODSPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE,HellBit.SPACE });
        	
	}
  

    /** Return the pattern data for a given character */
    protected HellBit[] pattern(char c) {
    	if (Character.isLetter(c))
            c = Character.toUpperCase(c);
    	if (hell_map.containsKey(c))
        	return hell_map.get(c);
    	else
        	return hell_map.get(' ');
    }

    protected HellBit[] pattern(String str) {
    	// Generate the pattern array. 

        // First three characters sent are <space> to open vox 
        // possibly to allow some synch.
        // Since all FH characters start with a row of null bits
        // the audio stream begins with silence rather than tone

    	str = " " + " " + " " + str;
        int strlen = str.length();
        HellBit[] result = new HellBit[strlen*98];
        int pos = 0;
        for (int i=0; i<strlen; i++) {
        	char c = str.charAt(i);
        	HellBit[] letter = pattern(c);
        	System.arraycopy(letter, 0, result, pos, 98);
        	pos += 98;
        }
        Log.i(TAG, String.format("Returning result array length %d",result.length));
        /*
        for (HellBit bit : result) {
        	switch(bit) {
        	case SPACE: Log.i(TAG,"0"); break;
        	case MODSPACE: Log.i(TAG,"o"); break;
        	case MARK: Log.i(TAG,"1"); break;
        	case MODMARK: Log.i(TAG,"i"); break;
        	default: Log.i(TAG,"other"); break;
        	}
        }
        */
        return result;
    }
}