// Evergreen Wishlist


var app = angular.module('evergreen_wishlist', ['ionic', 'ngCordova', 'angularMoment']);

// http://www.amazon.com/gp/registry?layout=standard-print&page=1&type=wishlist&id=14Z2Q12A0BTKB&disableNav=1
// https://www.amazon.com/gp/registry/wishlist/14Z2Q12A0BTKB/
// https://appalachian.nccardinal.org/eg/opac/home

app.config(function($stateProvider, $urlRouterProvider) {
  $stateProvider.state('books', {
    url: '/books',
    templateUrl: 'templates/books.html'
  });

  $stateProvider.state('book', {
    url: '/book/:slug',
    templateUrl: 'templates/book.html'
  });

  $stateProvider.state('help', {
    url: '/help',
    templateUrl: 'templates/help.html',
    controller: function($scope) {
      $scope.popover.hide();
    }
  });


  $urlRouterProvider.otherwise('/books');
});

app.controller('WishListCtrl', function($scope, $http, $state, $ionicModal, $ionicPopover, $ionicLoading, Settings, Books) {
  $scope.settings = Settings.all();
  $scope.books = Books.all();
  $scope.ref = '';
  $scope.wishlist_params = { page: 1 };

  // Create and load the Modal
  $ionicModal.fromTemplateUrl('templates/settings.html', function(modal) {
    $scope.settingsModal = modal;
  }, {
    scope: $scope,
    animation: 'slide-in-up'
  });

  // Called when the form is submitted
  $scope.updateSettings = function(settings) {
    $scope.settings['wishlist_url'] =  settings.wishlist_url;
    //$scope.settings['wishlist_id'] = settings.wishlist_url.split('/')[settings.wishlist_url.length - 1];

    if (settings.evergreen_url.length > 0) {
      $scope.settings['evergreen_base_url'] = 'https://' + settings.evergreen_url.split('/')[2];

      if (settings.evergreen_base_url.length > 0) {
        $scope.settings['evergreen_url'] =  settings.evergreen_base_url + '/eg/opac/results';
      }
    }

    Settings.save($scope.settings);
    $scope.settingsModal.hide();
    $scope.popover.hide();
  };

  // Open our new task modal
  $scope.openSettings = function() {
    $scope.settingsModal.show();
    $scope.popover.hide();
  };

  // Close the new task modal
  $scope.closeSettings= function() {
    $scope.settingsModal.hide();
  };

  function get_wishlist(callback) {
    var amazon_url = $scope.settings.wishlist_url;

    $http.get(amazon_url + $scope.ref, { params: $scope.wishlist_params })
    .success(function(response, status, headers, config) {
      //console.log('wish_list response:', response);

      // Clear the current books.
      //localStorage.removeItem('books');

      var books = parse_wishlist(response);
      callback(books);
    })
    .error(function(data, status, headers, config) {
      console.log('error status:', status);
      console.log('error data:', data);
      $scope.amazon_error_status = status;

    })
    .finally(function() {
      // Search item in Library's catalog.
      $scope.library_search(true, undefined);

      // Stop the ion-refresher and the inifite-scroller.
      $scope.$broadcast('scroll.refreshComplete');
      $scope.$broadcast('scroll.infiniteScrollComplete');
    });
  };

  $scope.get_books = function() {
    get_wishlist(function(books) {
      //$scope.books = books.concat($scope.books);
      $scope.books = $scope.books.concat(books);

      $scope.$broadcast('scroll.refreshComplete');
      //window.localStorage['books'] = angular.toJson(books);

      Books.save_all($scope.books);
      $scope.books = books;
      return true;
    });
  };


  $scope.get_more_books = function() {
    console.log('calling get_more_books');
    if ($scope.books && $scope.books.length != 0) {
      var options = parse_next_page($scope.wishlist_params.page);
      $scope.ref = options[0];
      $scope.wishlist_params = options[1];

      get_wishlist(function (more_books) {
        console.log('older_books:', more_books);
        //$scope.books = $scope.books.concat(more_books);
        //$scope.books = more_books.concat($scope.books);
        $scope.books = $scope.books.concat(more_books);

        $scope.$broadcast('scroll.infiniteScrollComplete');
      });
    } else {
      $scope.$broadcast('scroll.infiniteScrollComplete');
    }
  };


  $scope.library_search = function(all, book) {
    var evergreen_url = $scope.settings.evergreen_url;

    var params = {
      qtype: 'keyword',
      search_format: 'book',
      locg: 1
    };

    $ionicLoading.show({
      template: 'Loading...'
    });

    if (all === true) {
      var books = [];
      angular.forEach($scope.books, function(book, idx) {
        // Can't use params objec here for some reason... think it's an async thing.  Will fix later on.
        var args = '?query=' + book.search_string.replace(/\s/g, '+') + '&qtype=keyword&fi%3Asearch_format=book&locg=1';

        $http.get(evergreen_url + args)
        .success(function(response, status, headers, config) {
          var library_book = parse_library(response, book, $scope.settings);
          library_book = Books.save(library_book);
          books.push(library_book);

          $ionicLoading.hide();
        })
        .error(function(data, status, headers, config) {
          console.log('error status:', status);
          console.log('error data:', data);
        })
        .finally(function() {
          $scope.books = books;
        });
      })
    } else {
      var args = '?query=' + book.search_string.replace(/\s/g, '+') + '&qtype=keyword&fi%3Asearch_format=book&locg=1';

      params['query'] = book.search_string.replace(/\s/g, '+');

      $http.get(evergreen_url, { params: params })
      .success(function(response, status, headers, config) {
        //console.log(response);
        var book = parse_library(response, book, $scope.settings);
        Books.save(books);
        $scope.books = books;

        $ionicLoading.hide();
      })
      .error(function(data, status, headers, config) {
        console.log('error status:', status);
        console.log('error data:', data);
      })
      .finally(function() {
        Books.save(books);
        $scope.books = books;
      });
    }
  };

  $ionicPopover.fromTemplateUrl('templates/popover.html', {
    scope: $scope
  }).then(function(popover) {
    $scope.popover = popover;
  });

  $scope.closePopover = function() {
    $scope.popover.hide();
  };

  $scope.openLink = function(url) {
    window.open(url, '_system');
  };
});

app.controller('BookCtrl', function($scope, $state, Books) {
  $scope.book = Books.get($state.params.slug);
});

app.controller('FeedbackCtrl', function($scope, $cordovaEmailComposer) {

  document.addEventListener('deviceready', function () {
    // cordova.plugins.email is now available
  }, false);

  $cordovaEmailComposer.isAvailable().then(function() {
    // is available
  }, function () {
    // not available
  });

  var email = {
    to: 'adam@thehoick.com',
    cc: '',
    bcc: [],
    attachments: [
    ],
    subject: 'Evergreen Wishlist Feedback',
    body: '',
    isHtml: true
  };

  $scope.sendEmail = function() {
    $cordovaEmailComposer.open(email).then(null, function () {
      // user cancelled email
    });
  };
});

app.run(function($ionicPlatform) {
  $ionicPlatform.ready(function() {
    if(window.cordova && window.cordova.plugins.Keyboard) {
      window.cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
    }
    if (window.cordova && window.cordova.InAppBrowser) {
      window.open = window.cordova.InAppBrowser.open;
    }
    if(window.StatusBar) {
      StatusBar.styleDefault();
    }
  });
});
