

parse_print_wishlist = function(data) {
  var books = [];

  var rows = $('.a-normal.g-print-items tr', $(data));
  rows.splice(0,1);
  //console.log(rows);

  $.each(rows, function(idx, tr) {
    var amazon_book = {};

    var image_string = $(".g-image", $(tr)).children().attr('src');
    var image_array = image_string.split('/');
    var image_url = image_array.pop();
    var base_url = image_array.join('/');
    var orig_image = image_url.split('.')[0];
    amazon_book['image_url'] = base_url + '/' + orig_image + '.jpg';

    var $title_elements = $($(".g-title", $(tr)).children());

    amazon_book['title'] = $($($title_elements)[0]).html();
    amazon_book['search_string'] = $(amazon_book.title.split(":"))[0];

    var author_regx = /by (.*?) \(/;
    var author_match = author_regx.exec($($($title_elements)[1]).text());
    if (author_match != null) {
      amazon_book['author'] = author_match[1];
    }

    amazon_book['slug'] = amazon_book.search_string.toLowerCase()
    .replace(/\./g, '')
    .replace(/\s/g, '_')
    .replace(/,/g, '');
    if (amazon_book.author) {
      if (!books.hasOwnProperty(amazon_book.slug)) {
        books.push(amazon_book);
      }
    }
  });

  window.localStorage['books'] = angular.toJson(books);
};
