function parse_wishlist(data) {
  var books = [];
  var items = $('span.awl-item-title-ellipsis', $(data));

  $.each(items, function(idx, span) {
    var amazon_book = {};

    $span = $(span);
    amazon_book['title'] = $span.text().trim();
    amazon_book['search_string'] = $(amazon_book.title.split(":"))[0];
    console.log('search_string:', amazon_book['search_string']);

    $item_info = $span.parents('.itemInfo');

    amazon_book['amazon_id'] = $item_info.parent().attr('class').split('_')[1].split(' ')[0];

    amazon_book['added_at'] = $item_info.children('.awl-item-added-date').text().trim();

    amazon_book['book_url'] = 'https://www.amazon.com' + $item_info.children('.a-touch-link').attr('href');

    var image_string = $($('#image_' + amazon_book.amazon_id, $item_info).children()[0]).attr('src');
    var image_array = image_string.split('/');
    var image_url = image_array.pop();
    var base_url = image_array.join('/');
    var orig_image = image_url.split('.')[0];
    amazon_book['image_url'] = base_url + '/' + orig_image + '.jpg';

    amazon_book['slug'] = amazon_book.search_string.toLowerCase()
    .replace(/\./g, '')
    .replace(/\s/g, '_')
    .replace(/,/g, '');

    books.push(amazon_book);
  });
  return books;
  //window.localStorage['books'] = angular.toJson(books);
  //$scope.books = books;
  //return true;
}


function parse_library(data, book, settings) {
  var $data = $(data);
  var search_string = new RegExp(book.search_string.toLowerCase());
  book.libraries = [];
  statuses = [];

  if ($('#zero_search_hits', $data).length > 0) {
    book.library_name = 'Not Found';
    book.library_status = 'Not Available';
    book.checked_at = Date.now() / 1000;
    statuses.push('Not Available')
  } else {
    $.each($('.result_metadata', $data), function(idx, results) {
      var $results = $(results);

      var $title = $($('.record_title', $results));
      var regx_result = search_string.exec($title.text().toLowerCase());

      if (regx_result == null) {
        statuses.push('Not Available')
      } else {
        statuses.push('Found');
        book.evergreen_link = settings.evergreen_base_url + $title.attr("href");

        var $libraries = $("a[typeof='Library']", $results);

        if ($libraries.length == 0) {
          var $counts = $(".result_count", $results);
          $.each($counts, function(ids, count) {
            book.library_name = $(count).text().split(" at ")[1];
            book.library_status = 'Unknown';
            book.checked_at = Date.now() / 1000;
          })
        } else {

          $.each($libraries, function(idx, library) {
            var book_library = {};
            var $library = $(library);

            book_library.url = settings.evergreen_base_url + $library.attr('href');
            book_library.name =  $($library.children()[0]).text();
            book_library.status = $library.parent().next().next().next().text();
            if (book_library.status == 'Available') {
              book_library.color = 'balanced';
            } else {
              book_library.color = 'dark';
            }

            book.libraries.push(book_library);
          });
          book.library_status = 'In the System';
          book.checked_at = Date.now() / 1000;
        }
      }
    })
  }

  if (statuses.indexOf('Found') == -1) {
    book.library_name = 'Not Found';
    book.library_status = 'Not Available';
    book.checked_at = Date.now() / 1000;
  }

  if (book.library_status == 'In the System' || book.library_status == 'Available' || book.library_status == 'Unknown') {
    book.library_color = 'balanced';
    book.library_icon = 'ion-happy';
  } else {
    book.library_color = 'assertive';
    book.library_icon = 'ion-sad';
  }

  return book;
}

function parse_next_page(page) {
  //ref=cm_wl_sortbar_o_page_2?ie=UTF8&page=2

  if (page == 1) {
    ref = '/ref=cm_wl_sortbar_o_page_';
  }

  params = {
    ie: 'UTF8',
    page: page + 1
  };

  //http://www.amazon.com/registry/wishlist/14Z2Q12A0BTKB/ref=/ref=/ref=_41?ie=UTF8&page=4".

  var new_ref = ref.split('_');
  new_ref.pop();
  ref = new_ref.join('_') + '_' + (page + 1);

  return [ref, params]
}
