package com.tiwa.pl;

import androidx.annotation.NonNull;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import static com.tiwa.pl.Constants.DATE_INPUT_PATTERN;
import static com.tiwa.pl.Constants.DATE_OUTPUT_PATTERM;

class LogEntry implements Comparable<LogEntry> {

    private final String name;

    private String text;

    LogEntry(String name, String text) {
        this.name = name;
        this.text = text;
    }

    LogEntry(String name) {
        this.name = name;
        this.text = "";
    }

    String getName() {
        return name;
    }

    String getText() {
        return text;
    }

    void setText(String text) {
        this.text = text;
    }

    @Override
    @NonNull
    public String toString() {
        if (isNotDateName()) {
            return name;
        }
        SimpleDateFormat simpleDateFormatInput = new SimpleDateFormat(DATE_INPUT_PATTERN, Locale.getDefault());
        SimpleDateFormat simpleDateFormatOutput = new SimpleDateFormat(DATE_OUTPUT_PATTERM, Locale.getDefault());
        try {
            Date date = simpleDateFormatInput.parse(name.substring(0, 12));
            if (date == null) {
                return name;
            }
            return simpleDateFormatOutput.format(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return name;
    }

    @Override
    public int compareTo(LogEntry o) {
        return getName().compareToIgnoreCase(o.getName());
    }

    boolean isNotDateName() {
        if (name.length() < 12) {
            return true;
        }
        return !(name.substring(0, 12).matches("-?\\d+"));
    }
}
