package com.tiwa.pl;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.method.ScrollingMovementMethod;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.preference.PreferenceManager;

import com.google.android.material.floatingactionbutton.FloatingActionButton;

import java.util.List;

public class MainActivity extends AppCompatActivity {

    private LogRepository logRepository;

    private TextView entryContent;

    private MenuItem prevButton;

    private MenuItem nextButton;

    private MenuItem editButton;

    private MenuItem deleteButton;

    private MenuItem shareButton;

    private List<LogEntry> logEntryList;

    private Integer logIndex;
    DialogInterface.OnClickListener deleteDialogClickListener = new DialogInterface.OnClickListener() {
        @Override
        public void onClick(DialogInterface dialog, int which) {
            switch (which) {
                case DialogInterface.BUTTON_POSITIVE:
                    deleteEntry();
                    break;

                case DialogInterface.BUTTON_NEGATIVE:
                    break;
            }
        }
    };
    private Resources res;

    private void initApp() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(getBaseContext());
        boolean firstRun = prefs.getBoolean(Constants.FIRST_RUNT, true);
        if (firstRun) {
            goToSettings();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        initApp();
        res = getResources();

        Toolbar toolbar = findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        FloatingActionButton fab = findViewById(R.id.fab);
        entryContent = findViewById(R.id.contentText);
        entryContent.setMovementMethod(new ScrollingMovementMethod());
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent myIntent = new Intent(MainActivity.this, EditActivity.class);
                MainActivity.this.startActivity(myIntent);
            }
        });
    }


    @Override
    protected void onStart() {
        super.onStart();
        initLogRepository();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_main, menu);
        prevButton = menu.getItem(0);
        nextButton = menu.getItem(1);
        deleteButton = menu.getItem(2);
        editButton = menu.getItem(3);
        shareButton = menu.getItem(4);
        render();
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();

        switch (id) {
            case R.id.prevEntry:
                lastEntry();
                break;
            case R.id.nextEntry:
                nextEntry();
                break;
            case R.id.delete:
                showDeleteCurrentEntry();
                break;
            case R.id.edit:
                editEntry(logEntryList.get(logIndex).getName());
                break;
            case R.id.share:
                share();
                break;
            case R.id.settings:
                goToSettings();
                break;

        }
        return super.onOptionsItemSelected(item);
    }

    private void share() {
        Intent sharingIntent = new Intent(android.content.Intent.ACTION_SEND);
        sharingIntent.setType("text/plain");
        sharingIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, logEntryList.get(logIndex).toString());
        sharingIntent.putExtra(android.content.Intent.EXTRA_TEXT, logEntryList.get(logIndex).getText());
        startActivity(Intent.createChooser(sharingIntent, String.format(
                res.getString(R.string.main_dialog_share), logEntryList.get(logIndex).toString())));
    }


    private void goToSettings() {
        Intent myIntent = new Intent(MainActivity.this, SettingsActivity.class);
        MainActivity.this.startActivity(myIntent);
    }

    private void editEntry(String entryName) {
        Intent myIntent = new Intent(MainActivity.this, EditActivity.class);
        myIntent.putExtra(Constants.ENTRY, entryName);
        MainActivity.this.startActivity(myIntent);
    }

    private void deleteEntry() {
        logRepository.deleteEntrys(logEntryList.get(logIndex));
        logIndex--;
        loadEntrys();
        render();
    }

    private void showDeleteCurrentEntry() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setMessage(String.format(res.getString(R.string.main_dialog_delete_text),
                logEntryList.get(logIndex)))
                .setPositiveButton(R.string.main_dialog_delete_yes, deleteDialogClickListener)
                .setNegativeButton(R.string.main_dialog_delete_no, deleteDialogClickListener)
                .show();
    }

    private void nextEntry() {
        loadEntrys();
        if (logIndex < logEntryList.size() - 1) {
            logIndex++;
            render();
        }
    }

    private void lastEntry() {
        loadEntrys();
        if (logIndex > 0) {
            logIndex--;
            render();
        }
    }

    private void initLogRepository() {
        logRepository = LogRepositoryFactory.createLogRepository(getApplication());
        loadEntrys();
        setIndexLast();
        render();
    }

    private void setIndexLast() {
        logIndex = logEntryList.size() - 1;
    }

    private void loadEntrys() {
        logEntryList = logRepository.listEntrys();
    }


    private void render() {
        toggleShowMenuButton();
        if (!logEntryList.isEmpty()) {
            getSupportActionBar().setTitle(logEntryList.get(logIndex).toString());
            entryContent.setText(logEntryList.get(logIndex).getText());
            TextViewStyler textViewStyler = new TextViewStyler();
            textViewStyler.styleTextView(entryContent);
        }
    }

    private void toggleShowMenuButton() {
        if (nextButton != null && prevButton != null) {
            nextButton.setEnabled(true);
            prevButton.setEnabled(true);
            nextButton.setIcon(R.drawable.ic_next);
            prevButton.setIcon(R.drawable.ic_prev);
            if (logIndex == logEntryList.size() - 1) {
                nextButton.setEnabled(false);
                nextButton.setIcon(R.drawable.ic_empty);
            }
            if (logIndex <= 0) {
                prevButton.setEnabled(false);
                prevButton.setIcon(R.drawable.ic_empty);
            }
        }
        if (editButton != null && deleteButton != null && shareButton != null) {
            editButton.setVisible(true);
            deleteButton.setVisible(true);
            shareButton.setVisible(true);
            if (logIndex < 0) {
                editButton.setVisible(false);
                deleteButton.setVisible(false);
                shareButton.setVisible(false);
            }
        }
    }
}
