/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FT_EEPROM;
import com.ftdi.j2xx.FT_EEPROM_2232D;
import com.ftdi.j2xx.FT_EE_Ctrl;

class FT_EE_2232_Ctrl
extends FT_EE_Ctrl {
    private static final byte EEPROM_SIZE_LOCATION = 10;
    private static final short CHECKSUM_LOCATION = 63;
    private static final String DEFAULT_PID = "6010";

    FT_EE_2232_Ctrl(FT_Device usbC) throws D2xxManager.D2xxException {
        super(usbC);
        this.getEepromSize((byte)10);
    }

    short programEeprom(FT_EEPROM ee) {
        int[] data = new int[this.mEepromSize];
        if (ee.getClass() != FT_EEPROM_2232D.class) {
            return 1;
        }
        FT_EEPROM_2232D eeprom = (FT_EEPROM_2232D)ee;
        try {
            data[0] = 0;
            data[0] = eeprom.A_FIFO ? data[0] | 1 : (eeprom.A_FIFOTarget ? data[0] | 2 : data[0] | 4);
            if (eeprom.A_HighIO) {
                data[0] = data[0] | 0x10;
            }
            data[0] = eeprom.A_LoadVCP ? data[0] | 8 : (eeprom.B_FIFO ? data[0] | 0x100 : (eeprom.B_FIFOTarget ? data[0] | 0x200 : data[0] | 0x400));
            if (eeprom.B_HighIO) {
                data[0] = data[0] | 0x1000;
            }
            if (eeprom.B_LoadVCP) {
                data[0] = data[0] | 0x800;
            }
            data[1] = eeprom.VendorId;
            data[2] = eeprom.ProductId;
            data[3] = 1280;
            data[4] = this.setUSBConfig(ee);
            data[4] = this.setDeviceControl(ee);
            boolean eeprom46 = false;
            int offset = 75;
            if (this.mEepromType == 70) {
                offset = 11;
                eeprom46 = true;
            }
            offset = this.setStringDescriptor(eeprom.Manufacturer, data, offset, 7, eeprom46);
            offset = this.setStringDescriptor(eeprom.Product, data, offset, 8, eeprom46);
            if (eeprom.SerNumEnable) {
                offset = this.setStringDescriptor(eeprom.SerialNumber, data, offset, 9, eeprom46);
            }
            data[10] = this.mEepromType;
            if (data[1] != 0 && data[2] != 0) {
                boolean returnCode = false;
                returnCode = this.programEeprom(data, this.mEepromSize);
                if (returnCode) {
                    return 0;
                }
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    FT_EEPROM readEeprom() {
        FT_EEPROM_2232D eeprom = new FT_EEPROM_2232D();
        int[] dataRead = new int[this.mEepromSize];
        try {
            int i = 0;
            while (i < this.mEepromSize) {
                dataRead[i] = this.readWord((short)i);
                ++i;
            }
            short data02x00 = (short)(dataRead[0] & 7);
            switch (data02x00) {
                case 0: {
                    eeprom.A_UART = true;
                    break;
                }
                case 1: {
                    eeprom.A_FIFO = true;
                    break;
                }
                case 2: {
                    eeprom.A_FIFOTarget = true;
                    break;
                }
                case 4: {
                    eeprom.A_FastSerial = true;
                    break;
                }
            }
            short data3x00 = (short)((dataRead[0] & 8) >> 3);
            if (data3x00 == 1) {
                eeprom.A_LoadVCP = true;
            } else {
                eeprom.A_HighIO = true;
            }
            short data4x00 = (short)((dataRead[0] & 0x10) >> 4);
            if (data4x00 == 1) {
                eeprom.A_HighIO = true;
            }
            short data810x00 = (short)((dataRead[0] & 0x700) >> 8);
            switch (data810x00) {
                case 0: {
                    eeprom.B_UART = true;
                    break;
                }
                case 1: {
                    eeprom.B_FIFO = true;
                    break;
                }
                case 2: {
                    eeprom.B_FIFOTarget = true;
                    break;
                }
                case 4: {
                    eeprom.B_FastSerial = true;
                    break;
                }
            }
            short data11x00 = (short)((dataRead[0] & 0x800) >> 11);
            if (data11x00 == 1) {
                eeprom.B_LoadVCP = true;
            } else {
                eeprom.B_LoadD2XX = true;
            }
            short data12x00 = (short)((dataRead[0] & 0x1000) >> 12);
            if (data12x00 == 1) {
                eeprom.B_HighIO = true;
            }
            eeprom.VendorId = (short)dataRead[1];
            eeprom.ProductId = (short)dataRead[2];
            this.getUSBConfig(eeprom, dataRead[4]);
            int addr = dataRead[7] & 0xFF;
            if (this.mEepromType == 70) {
                addr -= 128;
                eeprom.Manufacturer = this.getStringDescriptor(addr /= 2, dataRead);
                addr = dataRead[8] & 0xFF;
                addr -= 128;
                eeprom.Product = this.getStringDescriptor(addr /= 2, dataRead);
                addr = dataRead[9] & 0xFF;
                addr -= 128;
                eeprom.SerialNumber = this.getStringDescriptor(addr /= 2, dataRead);
            } else {
                eeprom.Manufacturer = this.getStringDescriptor(addr /= 2, dataRead);
                addr = dataRead[8] & 0xFF;
                eeprom.Product = this.getStringDescriptor(addr /= 2, dataRead);
                addr = dataRead[9] & 0xFF;
                eeprom.SerialNumber = this.getStringDescriptor(addr /= 2, dataRead);
            }
            return eeprom;
        }
        catch (Exception e) {
            return null;
        }
    }

    int getUserSize() {
        int data = this.readWord((short)9);
        int ptr = data & 0xFF;
        int length = (data & 0xFF00) >> 8;
        return (this.mEepromSize - 1 - (ptr += length / 2)) * 2;
    }

    int writeUserData(byte[] data) {
        int dataWrite = 0;
        if (data.length > this.getUserSize()) {
            return 0;
        }
        short offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1);
        int i = 0;
        while (i < data.length) {
            dataWrite = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            dataWrite <<= 8;
            short s = offset;
            offset = (short)(s + 1);
            this.writeWord(s, (short)(dataWrite |= data[i] & 0xFF));
            i += 2;
        }
        return data.length;
    }

    byte[] readUserData(int length) {
        byte Hi = 0;
        byte Lo = 0;
        int dataRead = 0;
        byte[] data = new byte[length];
        if (length == 0 || length > this.getUserSize()) {
            return null;
        }
        short offset = (short)(this.mEepromSize - this.getUserSize() / 2 - 1);
        int i = 0;
        while (i < length) {
            short s = offset;
            offset = (short)(s + 1);
            dataRead = this.readWord(s);
            if (i + 1 < data.length) {
                data[i + 1] = Hi = (byte)(dataRead & 0xFF);
            } else {
                Lo = 0;
            }
            data[i] = Lo = (byte)((dataRead & 0xFF00) >> 8);
            i += 2;
        }
        return data;
    }
}

