/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.fpga;

import android.util.Log;
import com.physicaloid.lib.fpga.PhysicaloidFpgaPacketFilter;
import com.physicaloid.lib.framework.SerialCommunicator;
import java.io.IOException;
import java.io.InputStream;

public class PhysicaloidFpgaConfigurator {
    private static final boolean DEBUG_SHOW = true;
    private static final String TAG = PhysicaloidFpgaConfigurator.class.getSimpleName();
    private SerialCommunicator mSerial;
    private boolean mCanceled;
    private static final int READ_DELAY_MS = 10;
    private static final int CONF_CHECK_RETRY = 10;
    private static final int CONF_WRITE_PACKET_SIZE = 128;

    public PhysicaloidFpgaConfigurator(SerialCommunicator comm) {
        this.mSerial = comm;
        this.mCanceled = false;
    }

    public boolean configuration(InputStream is) {
        if (is == null) {
            return false;
        }
        byte[] rbuf = new byte[1];
        int retlen = 0;
        boolean readStatus = true;
        Log.d((String)TAG, (String)"Configuration Step.1 : Switch user mode.");
        int i = 0;
        while (i < 10) {
            readStatus = true;
            this.commandSwitchUserMode();
            this.readDelay();
            retlen = this.mSerial.read(rbuf, rbuf.length);
            if (retlen == 0) {
                Log.d((String)TAG, (String)"Configuration Fail : No response on switching user mode.");
                readStatus = false;
            } else {
                Log.d((String)TAG, (String)("return value : 0x" + Integer.toHexString(rbuf[0])));
                if (this.checkAsMode(rbuf[0])) {
                    Log.d((String)TAG, (String)"Configuration Fail : It's not PS Mode.Please set the switch AS Mode to PS Mode");
                    readStatus = false;
                } else if (readStatus) break;
            }
            ++i;
        }
        if (!readStatus) {
            return false;
        }
        Log.d((String)TAG, (String)"Configuration Step.2 : Switch config mode.");
        i = 0;
        while (i < 10) {
            this.commandSwitchConfigMode();
            this.readDelay();
            retlen = this.mSerial.read(rbuf, rbuf.length);
            if (retlen == 0) {
                Log.d((String)TAG, (String)"Configuration Fail : No response on switching config mode.");
            } else {
                Log.d((String)TAG, (String)("return value : 0x" + Integer.toHexString(rbuf[0])));
                if (!this.checkNstatus(rbuf[0]) && !this.checkConfDone(rbuf[0])) break;
                if (i == 9) {
                    Log.d((String)TAG, (String)"Configuration Fail : Check nSTATUS and CONF_DONE.Please retry.");
                    this.returnUserMode();
                    return false;
                }
            }
            ++i;
        }
        Log.d((String)TAG, (String)"Configuration Step.3 : Start config.");
        i = 0;
        while (i < 10) {
            this.commandStartConfig();
            this.readDelay();
            retlen = this.mSerial.read(rbuf, rbuf.length);
            if (retlen == 0) {
                Log.d((String)TAG, (String)"Configuration Fail : No response on starting config.");
            } else {
                Log.d((String)TAG, (String)("return value : 0x" + Integer.toHexString(rbuf[0])));
                if (this.checkNstatus(rbuf[0])) break;
                if (i == 9) {
                    Log.d((String)TAG, (String)"Configuration Fail : Check nSTATUS. Please retry.");
                    this.returnUserMode();
                    return false;
                }
            }
            ++i;
        }
        Log.d((String)TAG, (String)"Configuration Step.4 : Send RBF file.");
        int totalBytes = 0;
        try {
            totalBytes = is.available();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Cannot get .rbf file's byte length.");
            this.returnUserMode();
            return false;
        }
        byte[] confBuf = new byte[128];
        int offset = 0;
        int writeSize = 0;
        int writtenSize = 0;
        while (offset < totalBytes) {
            if (this.mCanceled) {
                return false;
            }
            Log.d((String)TAG, (String)("totalBytes : " + totalBytes + ", writeSize : " + writeSize + ", writtenSize : " + writtenSize + ", offset : " + offset));
            writeSize = totalBytes - offset;
            if (writeSize > 128) {
                writeSize = 128;
            }
            try {
                is.read(confBuf);
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)"Cannot get .rbf data.");
                this.returnUserMode();
                return false;
            }
            writtenSize = new PhysicaloidFpgaPacketFilter().writeWithEscape(this.mSerial, confBuf, writeSize);
            offset += writtenSize;
        }
        Log.d((String)TAG, (String)("totalBytes : " + totalBytes + ", writeSize : " + writeSize + ", writtenSize : " + writtenSize + ", offset : " + offset));
        this.drainReadBuf();
        Log.d((String)TAG, (String)"Configuration Step.5 : Check completion sending RBF file.");
        int i2 = 0;
        while (i2 < 10) {
            this.commandStopConfig();
            this.readDelay();
            retlen = this.mSerial.read(rbuf, rbuf.length);
            if (retlen != 0) {
                if (this.checkNstatus(rbuf[0]) && this.checkConfDone(rbuf[0])) break;
                Log.d((String)TAG, (String)("Configuration Fail : Illegal response : 0x" + Integer.toHexString(rbuf[0])));
                this.returnUserMode();
                return false;
            }
            Log.d((String)TAG, (String)"Configuration Fail : No response on configuration done.");
            ++i2;
        }
        Log.d((String)TAG, (String)"Configuration Step.6 : Change User mode.");
        this.returnUserMode();
        return true;
    }

    private void commandSwitchUserMode() {
        byte[] cbuf = new byte[]{58, 48};
        cbuf[1] = (byte)(cbuf[1] | 1);
        cbuf[1] = (byte)(cbuf[1] | 8);
        this.mSerial.write(cbuf, 2);
    }

    private void commandSwitchConfigMode() {
        byte[] cbuf = new byte[]{58, 48};
        this.mSerial.write(cbuf, 2);
    }

    private void commandStartConfig() {
        byte[] cbuf = new byte[]{58, 48};
        cbuf[1] = (byte)(cbuf[1] | 1);
        this.mSerial.write(cbuf, 2);
    }

    private void commandStopConfig() {
        byte[] cbuf = new byte[]{58, 48};
        cbuf[1] = (byte)(cbuf[1] | 1);
        this.mSerial.write(cbuf, 2);
    }

    private void returnUserMode() {
        byte[] rbuf = new byte[1];
        this.commandSwitchUserMode();
        this.readDelay();
        this.mSerial.read(rbuf, rbuf.length);
    }

    private boolean checkAsMode(byte ret) {
        return (ret & 1) == 1;
    }

    private boolean checkNstatus(byte ret) {
        return (ret & 2) == 2;
    }

    private boolean checkConfDone(byte ret) {
        return (ret & 4) == 4;
    }

    private boolean checkTimeout(byte ret) {
        return (ret & 8) == 8;
    }

    private void drainReadBuf() {
        byte[] tmpbuf = new byte[128];
        while (true) {
            this.readDelay();
            int retlen = this.mSerial.read(tmpbuf, tmpbuf.length);
            if (retlen == 0) break;
            Log.d((String)TAG, (String)("return value : " + this.toHexStr(tmpbuf, retlen)));
        }
    }

    private void readDelay() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String toHexStr(byte[] b, int length) {
        String str = "";
        int i = 0;
        while (i < length) {
            str = String.valueOf(str) + String.format("%02x ", b[i]);
            ++i;
        }
        return str;
    }
}

