/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.framework;

import com.physicaloid.lib.Boards;
import com.physicaloid.lib.Physicaloid;
import com.physicaloid.lib.fpga.PhysicaloidFpgaConfigurator;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.programmer.avr.AvrUploader;
import com.physicaloid.lib.programmer.avr.UploadErrors;
import com.physicaloid.lib.usb.driver.uart.UartConfig;
import java.io.InputStream;

public class Uploader {
    public boolean upload(InputStream fileStream, Boards board, SerialCommunicator comm, Physicaloid.UploadCallBack callback) {
        boolean ret = false;
        if (callback != null) {
            callback.onPreUpload();
        }
        if (board == null) {
            if (callback != null) {
                callback.onError(UploadErrors.AVR_CHIPTYPE);
            }
            return false;
        }
        if (board.uploadProtocol == 1 || board.uploadProtocol == 2) {
            AvrUploader avrUploader = new AvrUploader(comm);
            comm.setUartConfig(new UartConfig(board.uploadBaudrate, 8, 0, 0, false, false));
            ret = avrUploader.run(fileStream, board, callback);
        } else if (board.uploadProtocol == 61) {
            ret = new PhysicaloidFpgaConfigurator(comm).configuration(fileStream);
        }
        if (callback != null) {
            callback.onPostUpload(ret);
        }
        return ret;
    }
}

