/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.programmer.avr;

import com.physicaloid.lib.Boards;
import com.physicaloid.lib.programmer.avr.AVRConfMemEEPROM;
import com.physicaloid.lib.programmer.avr.AVRConfMemFlash;
import com.physicaloid.lib.programmer.avr.AVRConfMemFuse;

public class AvrConf {
    private static final String TAG = AvrConf.class.getSimpleName();
    public String desc;
    public byte stk500_devcode;
    public byte pagel;
    public byte bs2;
    public byte[] signature;
    public boolean has_jtag;
    public byte timeout;
    public byte stabdelay;
    public byte cmdexedelay;
    public byte synchloops;
    public byte bytedelay;
    public byte pollindex;
    public byte pollvalue;
    public byte predelay;
    public byte postdelay;
    public byte pollmethod;
    public AVRConfMemFuse fuse;
    public AVRConfMemFuse lfuse;
    public AVRConfMemFuse hfuse;
    public AVRConfMemFuse efuse;
    public AVRConfMemFuse lock;
    public AVRConfMemFlash flash;
    public AVRConfMemEEPROM eeprom;

    public AvrConf(Boards board) throws InterruptedException {
        if (board.chipType == 2) {
            this.setATmega168();
        } else if (board.chipType == 3) {
            this.setATmega328P();
        } else if (board.chipType == 7) {
            this.setATmega1284P();
        } else if (board.chipType == 5) {
            this.setATmega2560();
        } else {
            throw new IllegalArgumentException("not support AVR type.");
        }
    }

    private byte[] createSignature(int sig1, int sig2, int sig3) {
        return new byte[]{(byte)sig1, (byte)sig2, (byte)sig3};
    }

    private void setATmega2560() {
        this.desc = "ATMEGA2560";
        this.signature = this.createSignature(30, 152, 1);
        this.has_jtag = true;
        this.pagel = (byte)-41;
        this.bs2 = (byte)-96;
        this.timeout = (byte)-56;
        this.stabdelay = (byte)100;
        this.cmdexedelay = (byte)25;
        this.synchloops = (byte)32;
        this.bytedelay = 0;
        this.pollindex = (byte)3;
        this.pollvalue = (byte)83;
        this.predelay = 1;
        this.postdelay = 1;
        this.pollmethod = 1;
        this.flash = new AVRConfMemFlash(true, 262144, 256, 1024, 4500, 4500, 0, 0, new String[]{"   0   0   1   0     0   0   0   0", " a15 a14 a13 a12   a11 a10  a9  a8", "  a7  a6  a5  a4    a3  a2  a1  a0", "   o   o   o   o     o   o   o   o"}, new String[]{"   0   0   1   0     1   0   0   0", " a15 a14 a13 a12   a11 a10  a9  a8", "  a7  a6  a5  a4    a3  a2  a1  a0", "   o   o   o   o     o   o   o   o"}, new String[]{"   0   1   0   0     0   0   0   0", "   x   x   x   x     x   x   x   x", "   x  a6  a5  a4    a3  a2  a1  a0", "   i   i   i   i     i   i   i   i"}, new String[]{"   0   1   0   0     1   0   0   0", "   x   x   x   x     x   x   x   x", "   x  a6  a5  a4    a3  a2  a1  a0", "   i   i   i   i     i   i   i   i"}, new String[]{"   0   1   0   0     1   1   0   0", " a15 a14 a13 a12   a11 a10  a9  a8", "  a7   x   x   x     x   x   x   x", "   x   x   x   x     x   x   x   x"}, new String[]{"   0   1   0   0     1   1   0   1", "   0   0   0   0     0   0   0   0", "   0   0   0   0     0   0   0 a16", "   0   0   0   0     0   0   0   0"}, 65, 10, 256, 256);
    }

    private void setATmega1284P() {
        this.desc = "ATMEGA1284P";
        this.has_jtag = true;
        this.stk500_devcode = (byte)-126;
        this.signature = this.createSignature(30, 151, 5);
        this.pagel = (byte)-41;
        this.bs2 = (byte)-96;
        this.timeout = (byte)-56;
        this.stabdelay = (byte)100;
        this.cmdexedelay = (byte)25;
        this.synchloops = (byte)32;
        this.bytedelay = 0;
        this.pollindex = (byte)3;
        this.pollvalue = (byte)83;
        this.predelay = 1;
        this.postdelay = 1;
        this.pollmethod = 1;
        this.eeprom = new AVRConfMemEEPROM(false, 8, 4096, 9000, 9000, 255, 255, new String[]{" 1 0 1 0 0 0 0 0", " 0 0 x x a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 1 1 0 0 0 0 0 0", " 0 0 x x a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 1 1 0 0 0 0 0 1", " 0 0 0 0 0 0 0 0", " 0 0 0 0 0 a2 a1 a0", " i i i i i i i i"}, new String[]{" 1 1 0 0 0 0 1 0", " 0 0 x x a11 a10 a9 a8", " a7 a6 a5 a4 a3 0 0 0", " x x x x x x x x"}, 65, 10, 128, 256);
        this.flash = new AVRConfMemFlash(true, 131072, 256, 512, 4500, 4500, 255, 255, new String[]{" 0 0 1 0 0 0 0 0", " a15 a14 a13 a12 a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 0 0 1 0 1 0 0 0", " a15 a14 a13 a12 a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 0 1 0 0 0 0 0 0", " 0 0 x x x x x x", " x a6 a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 0 1 0 0 1 0 0 0", " 0 0 x x x x x x", " x a6 a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 0 1 0 0 1 1 0 0", " a15 a14 a13 a12 a11 a10 a9 a8", " a7 x x x x x x x", " x x x x x x x x"}, null, 65, 10, 256, 256);
        this.fuse = new AVRConfMemFuse("", 0, 0, 0, new String[]{"", ""}, new String[]{"", ""});
        this.lfuse = new AVRConfMemFuse("lfuse", 1, 9000, 9000, new String[]{"0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0", "x x x x x x x x o o o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0", "x x x x x x x x i i i i i i i i"});
        this.hfuse = new AVRConfMemFuse("hfuse", 1, 9000, 9000, new String[]{"0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0", "x x x x x x x x o o o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0", "x x x x x x x x i i i i i i i i"});
        this.efuse = new AVRConfMemFuse("efuse", 1, 9000, 9000, new String[]{"0 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0", "x x x x x x x x o o o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0", "x x x x x x x x 1 1 1 1 1 i i i"});
        this.lock = new AVRConfMemFuse("lock", 1, 9000, 9000, new String[]{"0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0", "x x x x x x x x x x o o  o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 1 1 x x x x x", "x x x x x x x x 1 1 i i i i i i"});
    }

    private void setATmega328P() {
        this.desc = "ATMEGA328P";
        this.stk500_devcode = (byte)-122;
        this.pagel = (byte)-41;
        this.bs2 = (byte)-62;
        this.signature = this.createSignature(30, 149, 15);
        this.eeprom = new AVRConfMemEEPROM(false, 4, 1024, 3600, 3600, 255, 255, new String[]{" 1 0 1 0 0 0 0 0", " 0 0 0 x x x a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 1 1 0 0 0 0 0 0", " 0 0 0 x x x a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 1 1 0 0 0 0 0 1", " 0 0 0 0 0 0 0 0", " 0 0 0 0 0 0 a1 a0", " i i i i i i i i"}, new String[]{" 1 1 0 0 0 0 1 0", " 0 0 x x x x a9 a8", " a7 a6 a5 a4 a3 a2 0 0", " x x x x x x x x"}, 65, 20, 4, 256);
        this.flash = new AVRConfMemFlash(true, 32768, 128, 256, 4500, 4500, 255, 255, new String[]{" 0 0 1 0 0 0 0 0", " 0 0 a13 a12 a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 0 0 1 0 1 0 0 0", " 0 0 a13 a12 a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 0 1 0 0 0 0 0 0", " 0 0 0 x x x x x", " x x a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 0 1 0 0 1 0 0 0", " 0 0 0 x x x x x", " x x a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 0 1 0 0 1 1 0 0", " 0 0 a13 a12 a11 a10 a9 a8", " a7 a6 x x x x x x", " x x x x x x x x"}, null, 65, 6, 128, 256);
        this.fuse = new AVRConfMemFuse("", 0, 0, 0, new String[]{"", ""}, new String[]{"", ""});
        this.lfuse = new AVRConfMemFuse("lfuse", 1, 4500, 4500, new String[]{"0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0", "x x x x x x x x o o o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0", "x x x x x x x x i i i i i i i i"});
        this.hfuse = new AVRConfMemFuse("hfuse", 1, 4500, 4500, new String[]{"0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0", "x x x x x x x x o o o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0", "x x x x x x x x i i i i i i i i"});
        this.efuse = new AVRConfMemFuse("efuse", 1, 4500, 4500, new String[]{"0 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0", "x x x x x x x x x x x x x o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0", "x x x x x x x x x x x x x i i i"});
        this.lock = new AVRConfMemFuse("lock", 1, 4500, 4500, new String[]{"0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0", "x x x x x x x x x x o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 1 1 x x x x x", "x x x x x x x x 1 1 i i i i i i"});
    }

    private void setATmega168() {
        this.desc = "ATMEGA168";
        this.stk500_devcode = (byte)-122;
        this.pagel = (byte)-41;
        this.bs2 = (byte)-62;
        this.signature = this.createSignature(30, 148, 6);
        this.eeprom = new AVRConfMemEEPROM(false, 4, 512, 3600, 3600, 255, 255, new String[]{" 1 0 1 0 0 0 0 0", " 0 0 0 x x x x a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 1 1 0 0 0 0 0 0", " 0 0 0 x x x x a8", " a7 a6 a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 1 1 0 0 0 0 0 1", " 0 0 0 0 0 0 0 0", " 0 0 0 0 0 0 a1 a0", " i i i i i i i i"}, new String[]{" 1 1 0 0 0 0 1 0", " 0 0 x x x x x a8", " a7 a6 a5 a4 a3 a2 0 0", " x x x x x x x x"}, 65, 20, 4, 256);
        this.flash = new AVRConfMemFlash(true, 16384, 128, 256, 4500, 4500, 255, 255, new String[]{" 0  0  1  0  0  0  0  0", "  0  0  0 a12 a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", "  o  o  o  o  o  o  o  o"}, new String[]{" 0 0 1 0 1 0 0 0", " 0 0 0 a12 a11 a10 a9 a8", " a7 a6 a5 a4 a3 a2 a1 a0", " o o o o o o o o"}, new String[]{" 0 1 0 0 0 0 0 0", " 0 0 0 x x x x x", " x x a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 0 1 0 0 1 0 0 0", " 0 0 0 x x x x x", " x x a5 a4 a3 a2 a1 a0", " i i i i i i i i"}, new String[]{" 0 1 0 0 1 1 0 0", " 0 0 0 a12 a11 a10 a9 a8", " a7 a6 x x x x x x", " x x x x x x x x"}, null, 65, 6, 128, 256);
        this.fuse = new AVRConfMemFuse("", 0, 0, 0, new String[]{"", ""}, new String[]{"", ""});
        this.lfuse = new AVRConfMemFuse("lfuse", 1, 4500, 4500, new String[]{"0 1 0 1 0 0 0 0 0 0 0 0 0 0 0 0", "x x x x x x x x o o o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 0 0 0 0", "x x x x x x x x i i i i i i i i"});
        this.hfuse = new AVRConfMemFuse("hfuse", 1, 4500, 4500, new String[]{"0 1 0 1 1 0 0 0 0 0 0 0 1 0 0 0", "x x x x x x x x o o o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 1 0 0 0", "x x x x x x x x i i i i i i i i"});
        this.efuse = new AVRConfMemFuse("efuse", 1, 4500, 4500, new String[]{"0 1 0 1 0 0 0 0 0 0 0 0 1 0 0 0", "x x x x x x x x x x x x x o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 0 1 0 0 1 0 0", "x x x x x x x x x x x x x i i i"});
        this.lock = new AVRConfMemFuse("lock", 1, 4500, 4500, new String[]{"0 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0", "x x x x x x x x x x o o o o o o"}, new String[]{"1 0 1 0 1 1 0 0 1 1 1 x x x x x", "x x x x x x x x 1 1 i i i i i i"});
    }
}

