/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.programmer.avr;

import android.util.Log;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.programmer.avr.AVRMem;
import com.physicaloid.lib.programmer.avr.AvrConf;
import com.physicaloid.lib.programmer.avr.UploadProtocol;
import java.util.Arrays;

public class Stk500V2
extends UploadProtocol {
    private static final String TAG = Stk500V2.class.getSimpleName();
    private static final boolean DEBUG_NOT_SHOW = true;
    private static final boolean DEBUG_SHOW_READ = false;
    private static final boolean DEBUG_SHOW_WRITE = false;
    private static final boolean DEBUG_SHOW_COMMAND = false;
    private static final boolean DEBUG_SHOW_COMMAND_STATUS = false;
    private static final boolean DEBUG_SHOW_RECV = false;
    private static final boolean DEBUG_SHOW_GETSYNC = false;
    private static final int RETRIES = 5;
    private static final int CMD_XPROG = 80;
    private static final int CMD_XPROG_SETMODE = 81;
    private static final int XPRG_ERR_OK = 0;
    private static final int XPRG_ERR_FAILED = 1;
    private static final int XPRG_ERR_COLLISION = 2;
    private static final int XPRG_ERR_TIMEOUT = 3;
    private static final int STATUS_CMD_OK = 0;
    private static final int STATUS_CMD_TOUT = 128;
    private static final int STATUS_RDY_BSY_TOUT = 129;
    private static final int STATUS_SET_PARAM_MISSING = 130;
    private static final int STATUS_CMD_FAILED = 192;
    private static final int STATUS_CKSUM_ERROR = 193;
    private static final int STATUS_CMD_UNKNOWN = 201;
    private static final int STATUS_CMD_ILLEGAL_PARAMETER = 202;
    private static final int STATUS_ISP_READY = 0;
    private static final int STATUS_CONN_FAIL_MOSI = 1;
    private static final int STATUS_CONN_FAIL_RST = 2;
    private static final int STATUS_CONN_FAIL_SCK = 4;
    private static final int STATUS_TGT_NOT_DETECTED = 16;
    private static final int STATUS_TGT_REVERSE_INSERTED = 32;
    private static final int STATUS_AREF_ERROR = 0;
    private static final int STATUS_VTG_ERROR = 4;
    private static final int STATUS_RC_CARD_ERROR = 5;
    private static final int STATUS_PROGMODE = 6;
    private static final int STATUS_POWER_SURGE = 7;
    private static final byte MESSAGE_START = 27;
    private static final byte TOKEN = 14;
    private static final byte CMD_SIGN_ON = 1;
    private static final byte CMD_SET_PARAMETER = 2;
    private static final byte CMD_GET_PARAMETER = 3;
    private static final byte CMD_SET_DEVICE_PARAMETERS = 4;
    private static final byte CMD_OSCCAL = 5;
    private static final byte CMD_LOAD_ADDRESS = 6;
    private static final byte CMD_FIRMWARE_UPGRADE = 7;
    private static final byte CMD_CHECK_TARGET_CONNECTION = 13;
    private static final byte CMD_LOAD_RC_ID_TABLE = 14;
    private static final byte CMD_LOAD_EC_ID_TABLE = 15;
    private static final byte CMD_ENTER_PROGMODE_ISP = 16;
    private static final byte CMD_LEAVE_PROGMODE_ISP = 17;
    private static final byte CMD_CHIP_ERASE_ISP = 18;
    private static final byte CMD_PROGRAM_FLASH_ISP = 19;
    private static final byte CMD_READ_FLASH_ISP = 20;
    private static final byte CMD_PROGRAM_EEPROM_ISP = 21;
    private static final byte CMD_READ_EEPROM_ISP = 22;
    private static final byte CMD_PROGRAM_FUSE_ISP = 23;
    private static final byte CMD_READ_FUSE_ISP = 24;
    private static final byte CMD_PROGRAM_LOCK_ISP = 25;
    private static final byte CMD_READ_LOCK_ISP = 26;
    private static final byte CMD_READ_SIGNATURE_ISP = 27;
    private static final byte CMD_READ_OSCCAL_ISP = 28;
    private static final byte CMD_SPI_MULTI = 29;
    private static final int ANSWER_CKSUM_ERROR = 176;
    private static final int PGMTYPE_UNKNOWN = 0;
    private static final int PGMTYPE_STK500 = 1;
    private static final int PGMTYPE_AVRISP = 2;
    private static final int PGMTYPE_AVRISP_MKII = 3;
    private static final int PGMTYPE_JTAGICE_MKII = 4;
    private static final int PGMTYPE_STK600 = 5;
    private int mCommandSeqNum = 1;
    private int mProgrammerType = 0;
    private SerialCommunicator mComm;
    private AvrConf mAVRConf;
    private AVRMem mAVRMem;
    private static final boolean DEBUG_SHOW_DRAIN = true;
    private static final String[] PROGRAMMER_NAME = new String[]{"unknown", "STK500", "AVRISP", "AVRISP mkII", "JTAG ICE mkII", "STK600"};
    private static final int sINIT = 0;
    private static final int sSTART = 1;
    private static final int sSEQNUM = 2;
    private static final int sSIZE1 = 3;
    private static final int sSIZE2 = 4;
    private static final int sTOKEN = 5;
    private static final int sDATA = 6;
    private static final int sCSUM = 7;
    private static final int sDONE = 8;
    private static final int SERIAL_TIMEOUT = 2;
    private static final int UINT_MAX = 65535;

    @Override
    public void setSerial(SerialCommunicator comm) {
        this.mComm = comm;
    }

    @Override
    public void setConfig(AvrConf avrConf, AVRMem avrMem) {
        this.mAVRConf = avrConf;
        this.mAVRMem = avrMem;
    }

    private void init() {
        this.mCommandSeqNum = 1;
    }

    private int drain() {
        long endTime;
        byte[] buf = new byte[1];
        int retval = 0;
        long startTime = System.currentTimeMillis();
        do {
            if ((retval = this.mComm.read(buf, 1)) <= 0) continue;
            startTime = System.currentTimeMillis();
            Log.d((String)TAG, (String)("drain(" + retval + ") : " + this.toHexStr(buf[0])));
        } while ((endTime = System.currentTimeMillis()) - startTime <= 250L);
        return retval;
    }

    private int send(byte[] data, int len) {
        byte[] buf = new byte[281];
        buf[0] = 27;
        buf[1] = (byte)this.mCommandSeqNum;
        buf[2] = (byte)(len / 256);
        buf[3] = (byte)(len % 256);
        buf[4] = 14;
        System.arraycopy(data, 0, buf, 5, len);
        buf[5 + len] = 0;
        int i = 0;
        while (i < 5 + len) {
            int n = 5 + len;
            buf[n] = (byte)(buf[n] ^ buf[i]);
            ++i;
        }
        return this.write(buf, len + 6);
    }

    private int command(byte[] buf, int len, int maxlen) {
        int tries = 0;
        boolean bRetry = true;
        while (bRetry) {
            bRetry = false;
            ++tries;
            this.send(buf, len);
            int status = this.recv(buf, maxlen);
            if (status > 0) {
                if (status < 2) {
                    Log.e((String)TAG, (String)"STK500V2.command(): short reply\n");
                    return -1;
                }
                if (buf[0] == 81 || buf[0] == 80) {
                    int i;
                    int n = i = buf[0] == 81 ? 1 : 2;
                    if (buf[i] != 0) {
                        String msg;
                        switch (buf[i]) {
                            case 1: {
                                msg = "Failed";
                                break;
                            }
                            case 2: {
                                msg = "Collision";
                                break;
                            }
                            case 3: {
                                msg = "Timeout";
                                break;
                            }
                            default: {
                                msg = "Unknown";
                            }
                        }
                        Log.e((String)TAG, (String)("STK500V2.command(): error in " + (buf[0] == 81 ? "CMD_XPROG_SETMODE" : "CMD_XPROG") + ": " + msg));
                        return -1;
                    }
                    return 0;
                }
                if (buf[1] >= 128 && buf[1] < 160) {
                    switch (buf[1]) {
                        case -128: {
                            String msg = "Command timed out";
                            break;
                        }
                        case -127: {
                            String msg = "Sampling of the RDY/nBSY pin timed out";
                            break;
                        }
                        case -126: {
                            String string = "The `Set Device Parameters' have not been executed in advance of this command";
                        }
                        default: {
                            String string = "unknown, code " + Integer.toHexString(buf[1]);
                            break;
                        }
                    }
                } else {
                    if (buf[1] == 0) {
                        return status;
                    }
                    if (buf[1] == -64) {
                        Log.e((String)TAG, (String)"STK500V2.command(): command failed");
                    } else {
                        Log.e((String)TAG, (String)("STK500V2.command(): unknown status " + Integer.toHexString(buf[1])));
                    }
                }
                return -1;
            }
            status = this.getsync();
            if (status == 0) continue;
            if (tries > 5) {
                Log.e((String)TAG, (String)("STK500V2.command(): failed miserably to execute command " + Integer.toHexString(buf[0])));
                return -1;
            }
            bRetry = true;
        }
        return 0;
    }

    private boolean compareByteArrayWithString(byte[] buf, int bufPos, String str) {
        byte[] tmpbuf = new byte[str.length()];
        System.arraycopy(buf, bufPos, tmpbuf, 0, str.length());
        return Arrays.equals(tmpbuf, str.getBytes());
    }

    int recv(byte[] buf, int length) {
        int state = 1;
        int msglen = 0;
        int curlen = 0;
        byte[] c = new byte[]{0};
        int checksum = 0;
        long timeoutval = 2L;
        long tstart = System.currentTimeMillis();
        block9: while (state != 8) {
            if (this.read(c, 1) <= 0) {
                long tnow = System.currentTimeMillis();
                if ((tnow - tstart) / 1000L <= timeoutval) continue;
                Log.e((String)TAG, (String)"STK500V2.recv(): timeout");
                return -1;
            }
            checksum = (byte)(checksum ^ c[0]);
            switch (state) {
                case 1: {
                    if (c[0] != 27) continue block9;
                    checksum = 27;
                    state = 2;
                    break;
                }
                case 2: {
                    if (c[0] == this.mCommandSeqNum) {
                        state = 3;
                        ++this.mCommandSeqNum;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 3: {
                    msglen = c[0] * 256;
                    state = 4;
                    break;
                }
                case 4: {
                    msglen += c[0];
                    state = 5;
                    break;
                }
                case 5: {
                    if (c[0] == 14) {
                        state = 6;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 6: {
                    if (curlen >= length) {
                        Log.e((String)TAG, (String)("STK500V2.recv(): buffer too small, received " + curlen + " byte into " + length + " byte buffer"));
                        return -2;
                    }
                    buf[curlen] = c[0];
                    if (curlen == 0 && buf[0] == 176) {
                        Log.e((String)TAG, (String)"STK500V2.recv(): previous packet sent with wrong checksum");
                        return -3;
                    }
                    if (++curlen != msglen) continue block9;
                    state = 7;
                    break;
                }
                case 7: {
                    if (checksum == 0) {
                        state = 8;
                        break;
                    }
                    state = 1;
                    Log.e((String)TAG, (String)"STK500V2.recv(): checksum error");
                    return -4;
                }
                default: {
                    Log.e((String)TAG, (String)"STK500V2.recv(): unknown state");
                    return -5;
                }
            }
        }
        return msglen + 6;
    }

    int getsync() {
        int tries = 0;
        byte[] buf = new byte[1];
        byte[] resp = new byte[32];
        boolean bRetry = true;
        while (bRetry) {
            bRetry = false;
            ++tries;
            buf[0] = 1;
            this.send(buf, 1);
            int status = this.recv(resp, resp.length);
            if (status <= 0) continue;
            if (resp[0] == 1 && resp[1] == 0 && status > 3) {
                byte siglen = resp[2];
                if (siglen >= "STK500_2".length() && this.compareByteArrayWithString(resp, 3, "STK500_2")) {
                    this.mProgrammerType = 1;
                } else if (siglen >= "AVRISP_2".length() && this.compareByteArrayWithString(resp, 3, "AVRISP_2")) {
                    this.mProgrammerType = 2;
                } else if (siglen >= "AVRISP_MK2".length() && this.compareByteArrayWithString(resp, 3, "AVRISP_MK2")) {
                    this.mProgrammerType = 3;
                } else if (siglen >= "STK600".length() && this.compareByteArrayWithString(resp, 3, "STK600")) {
                    this.mProgrammerType = 5;
                } else {
                    resp[siglen + 3] = 0;
                    byte[] tmpbuf = new byte[siglen];
                    System.arraycopy(buf, 3, tmpbuf, 0, siglen);
                    this.mProgrammerType = 1;
                }
                if (tries > 5) {
                    Log.e((String)TAG, (String)("STK500V2.getsync(): can't communicate with device: resp=" + Integer.toHexString(resp[0])));
                    return -6;
                }
                bRetry = true;
                continue;
            }
            if (status == -1) {
                if (tries > 5) {
                    Log.e((String)TAG, (String)"STK500V2.getsync(): timeout communicating with programmer");
                    return -1;
                }
                bRetry = true;
                continue;
            }
            if (tries > 5) {
                Log.e((String)TAG, (String)("STK500V2.getsync(): error communicating with programmer: (" + status + ")"));
                continue;
            }
            bRetry = true;
        }
        return 0;
    }

    @Override
    public int open() {
        this.setDtrRts(false);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setDtrRts(true);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.drain();
        if (this.getsync() < 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public void enable() {
    }

    @Override
    public int initialize() {
        return this.program_enable();
    }

    public int program_enable() {
        byte[] buf = new byte[16];
        buf[0] = 16;
        buf[1] = this.mAVRConf.timeout;
        buf[2] = this.mAVRConf.stabdelay;
        buf[3] = this.mAVRConf.cmdexedelay;
        buf[4] = this.mAVRConf.synchloops;
        buf[5] = this.mAVRConf.bytedelay;
        buf[6] = this.mAVRConf.pollvalue;
        buf[7] = this.mAVRConf.pollindex;
        buf[8] = -84;
        buf[9] = 83;
        buf[10] = 0;
        buf[11] = 0;
        int rv = this.command(buf, 12, buf.length);
        return rv;
    }

    int avr_set_bits(AVRMem.OPCODE op, byte[] cmd) {
        int i = 0;
        while (i < 32) {
            if (op.bit[i].type == 1) {
                int j = 3 - i / 8;
                int bit = i % 8;
                byte mask = (byte)(1 << bit);
                cmd[j] = op.bit[i].value != 0 ? (byte)(cmd[j] | mask) : (byte)(cmd[j] & ~mask);
            }
            ++i;
        }
        return 0;
    }

    @Override
    public int paged_write() {
        AVRMem.OPCODE rop;
        AVRMem.OPCODE wop;
        byte[] commandbuf = new byte[10];
        byte[] buf = new byte[266];
        byte[] cmds = new byte[4];
        int page_size = this.mAVRMem.page_size;
        int n_bytes = this.mAVRMem.buf.length;
        if (page_size == 0) {
            page_size = 256;
        }
        int addrshift = 0;
        int use_ext_addr = 0;
        if (this.mAVRMem.desc.compareTo("flash") == 0) {
            addrshift = 1;
            commandbuf[0] = 19;
            if (this.mAVRMem.op[8] != null) {
                use_ext_addr = Integer.MIN_VALUE;
            }
        } else if (this.mAVRMem.desc.compareTo("eeprom") == 0) {
            commandbuf[0] = 21;
        }
        commandbuf[4] = (byte)this.mAVRMem.delay;
        if (addrshift == 0) {
            wop = this.mAVRMem.op[1];
            rop = this.mAVRMem.op[0];
        } else {
            wop = this.mAVRMem.op[4];
            rop = this.mAVRMem.op[2];
        }
        if ((this.mAVRMem.mode & 1) == 1) {
            commandbuf[3] = (byte)(this.mAVRMem.mode | 0x80);
            if (this.mAVRMem.op[6] == null) {
                Log.e((String)TAG, (String)("STK500V2.paged_write: loadpage instruction not defined for part \"" + this.mAVRMem.desc + "\""));
                return -1;
            }
            this.avr_set_bits(this.mAVRMem.op[6], cmds);
            commandbuf[5] = cmds[0];
            if (this.mAVRMem.op[9] == null) {
                Log.e((String)TAG, (String)("STK500V2.paged_write: write page instruction not defined for part \"" + this.mAVRMem.desc + "\""));
                return -1;
            }
            this.avr_set_bits(this.mAVRMem.op[9], cmds);
            commandbuf[6] = cmds[0];
        } else {
            commandbuf[3] = (byte)(this.mAVRMem.mode | 0x80);
            if (wop == null) {
                Log.e((String)TAG, (String)("STK500V2.paged_write: write instruction not defined for part \"" + this.mAVRMem.desc + "\""));
                return -1;
            }
            this.avr_set_bits(wop, cmds);
            commandbuf[5] = cmds[0];
            commandbuf[6] = 0;
        }
        if (rop == null) {
            Log.e((String)TAG, (String)("STK500V2.paged_write: read instruction not defined for part \"" + this.mAVRMem.desc + "\""));
            return -1;
        }
        this.avr_set_bits(rop, cmds);
        commandbuf[7] = cmds[0];
        commandbuf[8] = this.mAVRMem.readback[0];
        commandbuf[9] = this.mAVRMem.readback[1];
        int last_addr = 65535;
        int addr = 0;
        while (addr < n_bytes) {
            if (Thread.interrupted()) {
                this.report_cancel();
                return 0;
            }
            this.report_progress(addr * 100 / n_bytes);
            int block_size = n_bytes - addr < page_size ? n_bytes - addr : page_size;
            if (commandbuf[0] != 19 || !this.is_page_empty(addr, block_size, this.mAVRMem.buf)) {
                System.arraycopy(commandbuf, 0, buf, 0, commandbuf.length);
                buf[1] = (byte)(block_size >> 8);
                buf[2] = (byte)(block_size & 0xFF);
                if ((last_addr == 65535 || last_addr + block_size != addr) && this.loadaddr(use_ext_addr | addr >> addrshift) < 0) {
                    return -1;
                }
                last_addr = addr;
                System.arraycopy(this.mAVRMem.buf, addr, buf, 10, block_size);
                int result = this.command(buf, block_size + 10, buf.length);
                if (result < 0) {
                    Log.e((String)TAG, (String)"STK500V2.paged_write: write command failed");
                    return -1;
                }
            }
            addr += page_size;
        }
        this.report_progress(addr * 100 / n_bytes);
        return n_bytes;
    }

    boolean is_page_empty(int address, int page_size, byte[] buf) {
        int i = 0;
        while (i < page_size) {
            if (buf[address + i] != 255) {
                return false;
            }
            ++i;
        }
        return true;
    }

    int loadaddr(int addr) {
        byte[] buf = new byte[16];
        buf[0] = 6;
        buf[1] = (byte)(addr >> 24 & 0xFF);
        buf[2] = (byte)(addr >> 16 & 0xFF);
        buf[3] = (byte)(addr >> 8 & 0xFF);
        buf[4] = (byte)(addr & 0xFF);
        int result = this.command(buf, 5, buf.length);
        if (result < 0) {
            Log.e((String)TAG, (String)"STK500V2.loadaddr(): failed to set load address");
            return -1;
        }
        return 0;
    }

    private int read(byte[] buf, int length) {
        int retval = this.mComm.read(buf, length);
        return retval;
    }

    private int write(byte[] buf, int length) {
        int retval = this.mComm.write(buf, length);
        return retval;
    }

    private void setDtrRts(boolean on) {
        if (on) {
            this.mComm.setDtrRts(true, true);
        } else {
            this.mComm.setDtrRts(false, false);
        }
    }

    private String toHexStr(byte b) {
        return String.format("0x%02x", b);
    }

    private String toHexStr(byte[] b, int length) {
        String str = "";
        int i = 0;
        while (i < length) {
            str = String.valueOf(str) + String.format("0x%02x ", b[i]);
            ++i;
        }
        return str;
    }

    @Override
    public int check_sig_bytes() {
        return 0;
    }

    @Override
    public void disable() {
        byte[] buf = new byte[16];
        buf[0] = 17;
        buf[1] = 1;
        buf[2] = 1;
        int result = this.command(buf, 3, buf.length);
        if (result < 0) {
            Log.e((String)TAG, (String)"STK500V2.disable(): failed to leave programming mode");
        }
    }
}

