/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.usb.driver.uart;

import android.content.Context;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.physicaloid.lib.UsbVidList;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.usb.UsbCdcConnection;
import com.physicaloid.lib.usb.UsbVidPid;
import com.physicaloid.lib.usb.driver.uart.ReadLisener;
import com.physicaloid.lib.usb.driver.uart.UartConfig;
import com.physicaloid.misc.RingBuffer;
import java.util.ArrayList;
import java.util.List;

public class UartCp210x
extends SerialCommunicator {
    private static final String TAG = UartCp210x.class.getSimpleName();
    private static final boolean DEBUG_SHOW = false;
    private static final int DEFAULT_BAUDRATE = 9600;
    private UsbCdcConnection mUsbConnetionManager;
    private UartConfig mUartConfig;
    private static final int RING_BUFFER_SIZE = 1024;
    private static final int USB_READ_BUFFER_SIZE = 256;
    private static final int USB_WRITE_BUFFER_SIZE = 256;
    private RingBuffer mBuffer;
    private boolean mReadThreadStop = true;
    private UsbDeviceConnection mConnection;
    private UsbEndpoint mEndpointIn;
    private UsbEndpoint mEndpointOut;
    private boolean isOpened;
    private static final byte REQTYPE_HOST_TO_INTERFACE = 65;
    private static final byte REQTYPE_INTERFACE_TO_HOST = -63;
    private static final byte REQTYPE_HOST_TO_DEVICE = 64;
    private static final byte REQTYPE_DEVICE_TO_HOST = -64;
    private static final byte CP210X_IFC_ENABLE = 0;
    private static final byte CP210X_SET_BAUDDIV = 1;
    private static final byte CP210X_GET_BAUDDIV = 2;
    private static final byte CP210X_SET_LINE_CTL = 3;
    private static final byte CP210X_GET_LINE_CTL = 4;
    private static final byte CP210X_SET_BREAK = 5;
    private static final byte CP210X_IMM_CHAR = 6;
    private static final byte CP210X_SET_MHS = 7;
    private static final byte CP210X_GET_MDMSTS = 8;
    private static final byte CP210X_SET_XON = 9;
    private static final byte CP210X_SET_XOFF = 10;
    private static final byte CP210X_SET_EVENTMASK = 11;
    private static final byte CP210X_GET_EVENTMASK = 12;
    private static final byte CP210X_SET_CHAR = 13;
    private static final byte CP210X_GET_CHARS = 14;
    private static final byte CP210X_GET_PROPS = 15;
    private static final byte CP210X_GET_COMM_STATUS = 16;
    private static final byte CP210X_RESET = 17;
    private static final byte CP210X_PURGE = 18;
    private static final byte CP210X_SET_FLOW = 19;
    private static final byte CP210X_GET_FLOW = 20;
    private static final byte CP210X_EMBED_EVENTS = 21;
    private static final byte CP210X_GET_EVENTSTATE = 22;
    private static final byte CP210X_SET_CHARS = 25;
    private static final byte CP210X_GET_BAUDRATE = 29;
    private static final byte CP210X_SET_BAUDRATE = 30;
    private static final int UART_ENABLE = 1;
    private static final int UART_DISABLE = 0;
    private static final int BAUD_RATE_GEN_FREQ = 3686400;
    private static final int BITS_DATA_MASK = 3840;
    private static final int BITS_DATA_5 = 1280;
    private static final int BITS_DATA_6 = 1536;
    private static final int BITS_DATA_7 = 1792;
    private static final int BITS_DATA_8 = 2048;
    private static final int BITS_DATA_9 = 2304;
    private static final int BITS_PARITY_MASK = 240;
    private static final int BITS_PARITY_NONE = 0;
    private static final int BITS_PARITY_ODD = 16;
    private static final int BITS_PARITY_EVEN = 32;
    private static final int BITS_PARITY_MARK = 48;
    private static final int BITS_PARITY_SPACE = 64;
    private static final int BITS_STOP_MASK = 15;
    private static final int BITS_STOP_1 = 0;
    private static final int BITS_STOP_1_5 = 1;
    private static final int BITS_STOP_2 = 2;
    private static final int BREAK_ON = 1;
    private static final int BREAK_OFF = 0;
    private static final int CONTROL_DTR = 1;
    private static final int CONTROL_RTS = 2;
    private static final int CONTROL_CTS = 16;
    private static final int CONTROL_DSR = 32;
    private static final int CONTROL_RING = 64;
    private static final int CONTROL_DCD = 128;
    private static final int CONTROL_WRITE_DTR = 256;
    private static final int CONTROL_WRITE_RTS = 512;
    private Runnable mLoop = new Runnable(){

        @Override
        public void run() {
            int len = 0;
            byte[] rbuf = new byte[256];
            while (true) {
                try {
                    len = UartCp210x.this.mConnection.bulkTransfer(UartCp210x.this.mEndpointIn, rbuf, rbuf.length, 50);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.toString());
                }
                if (len > 0) {
                    UartCp210x.this.mBuffer.add(rbuf, len);
                    UartCp210x.this.onRead(len);
                }
                if (UartCp210x.this.mReadThreadStop) {
                    return;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    };
    private List<ReadLisener> uartReadListenerList = new ArrayList<ReadLisener>();
    private boolean mStopReadListener = false;

    public UartCp210x(Context context) {
        super(context);
        this.mUsbConnetionManager = new UsbCdcConnection(context);
        this.mUartConfig = new UartConfig();
        this.mBuffer = new RingBuffer(1024);
        this.isOpened = false;
    }

    @Override
    public boolean open() {
        UsbVidList[] usbVidListArray = UsbVidList.values();
        int n = usbVidListArray.length;
        int n2 = 0;
        while (n2 < n) {
            UsbVidList id = usbVidListArray[n2];
            if (this.open(new UsbVidPid(id.getVid(), 0))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean open(UsbVidPid ids) {
        if (this.mUsbConnetionManager.open(ids)) {
            this.mConnection = this.mUsbConnetionManager.getConnection();
            this.mEndpointIn = this.mUsbConnetionManager.getEndpointIn();
            this.mEndpointOut = this.mUsbConnetionManager.getEndpointOut();
            if (!this.init()) {
                return false;
            }
            if (!this.setBaudrate(9600)) {
                return false;
            }
            this.mBuffer.clear();
            this.startRead();
            this.isOpened = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        this.stopRead();
        this.isOpened = false;
        this.cp210xUsbDisable();
        return this.mUsbConnetionManager.close();
    }

    @Override
    public int read(byte[] buf, int size) {
        return this.mBuffer.get(buf, size);
    }

    @Override
    public int write(byte[] buf, int size) {
        if (buf == null) {
            return 0;
        }
        int offset = 0;
        byte[] wbuf = new byte[256];
        while (offset < size) {
            int write_size = 256;
            if (offset + write_size > size) {
                write_size = size - offset;
            }
            System.arraycopy(buf, offset, wbuf, 0, write_size);
            int written_size = this.mConnection.bulkTransfer(this.mEndpointOut, wbuf, write_size, 100);
            if (written_size < 0) {
                return -1;
            }
            offset += written_size;
        }
        return offset;
    }

    private void stopRead() {
        this.mReadThreadStop = true;
    }

    private void startRead() {
        if (this.mReadThreadStop) {
            this.mReadThreadStop = false;
            new Thread(this.mLoop).start();
        }
    }

    @Override
    public boolean setUartConfig(UartConfig config) {
        boolean res = true;
        boolean ret = true;
        if (this.mUartConfig.baudrate != config.baudrate) {
            res = this.setBaudrate(config.baudrate);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.dataBits != config.dataBits) {
            res = this.setDataBits(config.dataBits);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.parity != config.parity) {
            res = this.setParity(config.parity);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.stopBits != config.stopBits) {
            res = this.setStopBits(config.stopBits);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.dtrOn != config.dtrOn || this.mUartConfig.rtsOn != config.rtsOn) {
            res = this.setDtrRts(config.dtrOn, config.rtsOn);
            ret = ret && res;
        }
        return ret;
    }

    private boolean init() {
        int ret = this.cp210xUsbEnable();
        return ret >= 0;
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    private int cp210xUsbEnable() {
        if (this.mConnection == null) {
            return -1;
        }
        return this.mConnection.controlTransfer(65, 0, 1, 0, null, 0, 100);
    }

    private int cp210xUsbDisable() {
        if (this.mConnection == null) {
            return -1;
        }
        return this.mConnection.controlTransfer(65, 0, 0, 0, null, 0, 100);
    }

    private int cp210xGetConfig(int request, byte[] buf, int size) {
        if (this.mConnection == null) {
            return -1;
        }
        int ret = this.mConnection.controlTransfer(-63, request, 0, 0, buf, size, 100);
        return ret;
    }

    private int cp210xSetConfig(int request, byte[] buf, int size) {
        if (this.mConnection == null) {
            return -1;
        }
        int ret = this.mConnection.controlTransfer(65, request, 0, 0, buf, size, 100);
        return ret;
    }

    @Override
    public boolean setBaudrate(int baudrate) {
        if (baudrate <= 300) {
            baudrate = 300;
        } else if (baudrate <= 600) {
            baudrate = 600;
        } else if (baudrate <= 1200) {
            baudrate = 1200;
        } else if (baudrate <= 1800) {
            baudrate = 1800;
        } else if (baudrate <= 2400) {
            baudrate = 2400;
        } else if (baudrate <= 4000) {
            baudrate = 4000;
        } else if (baudrate <= 4803) {
            baudrate = 4800;
        } else if (baudrate <= 7207) {
            baudrate = 7200;
        } else if (baudrate <= 9612) {
            baudrate = 9600;
        } else if (baudrate <= 14428) {
            baudrate = 14400;
        } else if (baudrate <= 16062) {
            baudrate = 16000;
        } else if (baudrate <= 19250) {
            baudrate = 19200;
        } else if (baudrate <= 28912) {
            baudrate = 28800;
        } else if (baudrate <= 38601) {
            baudrate = 38400;
        } else if (baudrate <= 51558) {
            baudrate = 51200;
        } else if (baudrate <= 56280) {
            baudrate = 56000;
        } else if (baudrate <= 58053) {
            baudrate = 57600;
        } else if (baudrate <= 64111) {
            baudrate = 64000;
        } else if (baudrate <= 77608) {
            baudrate = 76800;
        } else if (baudrate <= 117028) {
            baudrate = 115200;
        } else if (baudrate <= 129347) {
            baudrate = 128000;
        } else if (baudrate <= 156868) {
            baudrate = 153600;
        } else if (baudrate <= 237832) {
            baudrate = 230400;
        } else if (baudrate <= 254234) {
            baudrate = 250000;
        } else if (baudrate <= 273066) {
            baudrate = 256000;
        } else if (baudrate <= 491520) {
            baudrate = 460800;
        } else if (baudrate <= 567138) {
            baudrate = 500000;
        } else if (baudrate <= 670254) {
            baudrate = 576000;
        } else if (baudrate < 1000000) {
            baudrate = 921600;
        } else if (baudrate > 2000000) {
            baudrate = 2000000;
        }
        byte[] baudBytes = new byte[4];
        this.intToLittleEndianBytes(baudrate, baudBytes);
        int ret = this.cp210xSetConfig(30, baudBytes, 4);
        if (ret < 0) {
            return false;
        }
        this.mUartConfig.baudrate = baudrate;
        return true;
    }

    @Override
    public boolean setDataBits(int dataBits) {
        byte[] buf = new byte[2];
        this.cp210xGetConfig(4, buf, buf.length);
        int bits = this.littleEndianBytesToInt(buf);
        bits &= 0xFFFFF0FF;
        switch (dataBits) {
            case 7: {
                bits |= 0x700;
                break;
            }
            case 8: {
                bits |= 0x800;
                break;
            }
            default: {
                bits |= 0x800;
            }
        }
        this.intToLittleEndianBytes(bits, buf);
        int ret = this.cp210xSetConfig(4, buf, buf.length);
        if (ret < 0) {
            return false;
        }
        this.mUartConfig.dataBits = dataBits;
        return true;
    }

    @Override
    public boolean setParity(int parity) {
        byte[] buf = new byte[2];
        this.cp210xGetConfig(4, buf, buf.length);
        int bits = this.littleEndianBytesToInt(buf);
        bits &= 0xFFFFFF0F;
        switch (parity) {
            case 0: {
                bits |= 0;
                break;
            }
            case 1: {
                bits |= 0x10;
                break;
            }
            case 2: {
                bits |= 0x20;
                break;
            }
            case 3: {
                bits |= 0x30;
                break;
            }
            case 4: {
                bits |= 0x40;
                break;
            }
            default: {
                bits |= 0;
            }
        }
        this.intToLittleEndianBytes(bits, buf);
        int ret = this.cp210xSetConfig(4, buf, buf.length);
        if (ret < 0) {
            return false;
        }
        this.mUartConfig.parity = parity;
        return true;
    }

    @Override
    public boolean setStopBits(int stopBits) {
        byte[] buf = new byte[2];
        this.cp210xGetConfig(4, buf, buf.length);
        int bits = this.littleEndianBytesToInt(buf);
        bits &= 0xFFFFFFF0;
        switch (stopBits) {
            case 0: {
                bits |= 0;
                break;
            }
            case 1: {
                bits |= 1;
                break;
            }
            case 2: {
                bits |= 2;
                break;
            }
            default: {
                bits |= 0;
            }
        }
        this.intToLittleEndianBytes(bits, buf);
        int ret = this.cp210xSetConfig(4, buf, buf.length);
        if (ret < 0) {
            return false;
        }
        this.mUartConfig.stopBits = stopBits;
        return true;
    }

    @Override
    public boolean setDtrRts(boolean dtrOn, boolean rtsOn) {
        int ctrlValue = 0;
        byte[] buf = new byte[4];
        if (dtrOn) {
            ctrlValue |= 1;
            ctrlValue |= 0x100;
        } else {
            ctrlValue &= 0xFFFFFFFE;
            ctrlValue |= 0x100;
        }
        if (rtsOn) {
            ctrlValue |= 2;
            ctrlValue |= 0x200;
        } else {
            ctrlValue &= 0xFFFFFFFD;
            ctrlValue |= 0x200;
        }
        this.intToLittleEndianBytes(ctrlValue, buf);
        int ret = this.cp210xSetConfig(7, buf, buf.length);
        if (ret < 0) {
            return false;
        }
        this.mUartConfig.dtrOn = dtrOn;
        this.mUartConfig.rtsOn = rtsOn;
        return true;
    }

    @Override
    public UartConfig getUartConfig() {
        return this.mUartConfig;
    }

    @Override
    public int getBaudrate() {
        return this.mUartConfig.baudrate;
    }

    @Override
    public int getDataBits() {
        return this.mUartConfig.dataBits;
    }

    @Override
    public int getParity() {
        return this.mUartConfig.parity;
    }

    @Override
    public int getStopBits() {
        return this.mUartConfig.stopBits;
    }

    @Override
    public boolean getDtr() {
        return this.mUartConfig.dtrOn;
    }

    @Override
    public boolean getRts() {
        return this.mUartConfig.rtsOn;
    }

    @Override
    public void clearBuffer() {
        this.mBuffer.clear();
    }

    @Override
    public void addReadListener(ReadLisener listener) {
        this.uartReadListenerList.add(listener);
    }

    @Override
    public void clearReadListener() {
        this.uartReadListenerList.clear();
    }

    @Override
    public void startReadListener() {
        this.mStopReadListener = false;
    }

    @Override
    public void stopReadListener() {
        this.mStopReadListener = true;
    }

    private void onRead(int size) {
        if (this.mStopReadListener) {
            return;
        }
        for (ReadLisener listener : this.uartReadListenerList) {
            listener.onRead(size);
        }
    }

    private void intToLittleEndianBytes(int in, byte[] out) {
        if (out == null) {
            return;
        }
        if (out.length > 4) {
            return;
        }
        int i = 0;
        while (i < out.length) {
            out[i] = (byte)(in >> i * 8 & 0xFF);
            ++i;
        }
    }

    private int littleEndianBytesToInt(byte[] in) {
        if (in == null) {
            return 0;
        }
        if (in.length > 4) {
            return 0;
        }
        int ret = 0;
        int i = 0;
        while (i < in.length) {
            ret |= (in[i] & 0xFF) << i * 8;
            ++i;
        }
        return ret;
    }
}

