/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.usb.driver.uart;

import android.content.Context;
import android.util.Log;
import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.usb.driver.uart.ReadLisener;
import com.physicaloid.lib.usb.driver.uart.UartConfig;
import com.physicaloid.misc.RingBuffer;
import java.util.ArrayList;
import java.util.List;

public class UartFtdi
extends SerialCommunicator {
    private static final boolean DEBUG_SHOW = true;
    private static final String TAG = UartFtdi.class.getSimpleName();
    private Context mContext;
    private D2xxManager ftD2xx = null;
    private FT_Device ftDev = null;
    private UartConfig mUartConfig;
    private static final int RING_BUFFER_SIZE = 1024;
    private static final int USB_READ_BUFFER_SIZE = 256;
    private static final int USB_WRITE_BUFFER_SIZE = 256;
    private RingBuffer mBuffer;
    private static final int USB_OPEN_INDEX = 0;
    private static final int MAX_READBUF_SIZE = 256;
    private static final int READ_WAIT_MS = 10;
    private boolean mReadThreadStop;
    private Runnable mLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int len = 0;
            byte[] rbuf = new byte[256];
            while (true) {
                FT_Device fT_Device = UartFtdi.this.ftDev;
                synchronized (fT_Device) {
                    len = UartFtdi.this.ftDev.getQueueStatus();
                }
                if (len > 0) {
                    if (len > 256) {
                        len = 256;
                    }
                    fT_Device = UartFtdi.this.ftDev;
                    synchronized (fT_Device) {
                        len = UartFtdi.this.ftDev.read(rbuf, len, 10L);
                    }
                    Log.e((String)TAG, (String)("read(" + len + "): " + UartFtdi.this.toHexStr(rbuf, len)));
                    UartFtdi.this.mBuffer.add(rbuf, len);
                    UartFtdi.this.onRead(len);
                }
                if (UartFtdi.this.mReadThreadStop) {
                    return;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    };
    private List<ReadLisener> uartReadListenerList = new ArrayList<ReadLisener>();
    private boolean mStopReadListener = false;

    public UartFtdi(Context context) {
        super(context);
        this.mContext = context;
        this.mReadThreadStop = true;
        this.mUartConfig = new UartConfig();
        this.mBuffer = new RingBuffer(1024);
        try {
            this.ftD2xx = D2xxManager.getInstance((Context)this.mContext);
        }
        catch (D2xxManager.D2xxException ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() {
        if (this.ftD2xx == null) {
            try {
                this.ftD2xx = D2xxManager.getInstance((Context)this.mContext);
            }
            catch (D2xxManager.D2xxException ex) {
                Log.e((String)TAG, (String)ex.toString());
                return false;
            }
        }
        if (this.ftDev == null) {
            int devCount = 0;
            devCount = this.ftD2xx.createDeviceInfoList(this.mContext);
            Log.d((String)TAG, (String)("Device number : " + Integer.toString(devCount)));
            D2xxManager.FtDeviceInfoListNode[] deviceList = new D2xxManager.FtDeviceInfoListNode[devCount];
            this.ftD2xx.getDeviceInfoList(devCount, deviceList);
            if (devCount <= 0) {
                return false;
            }
            this.ftDev = this.ftD2xx.openByIndex(this.mContext, 0);
        } else if (this.ftD2xx.createDeviceInfoList(this.mContext) > 0) {
            FT_Device fT_Device = this.ftDev;
            synchronized (fT_Device) {
                this.ftDev = this.ftD2xx.openByIndex(this.mContext, 0);
            }
        }
        if (this.ftDev.isOpen()) {
            FT_Device fT_Device = this.ftDev;
            synchronized (fT_Device) {
                this.ftDev.resetDevice();
            }
            this.setBaudrate(this.mUartConfig.baudrate);
            Log.d((String)TAG, (String)"An FTDI device is opened.");
            this.startRead();
            return true;
        }
        Log.e((String)TAG, (String)"Cannot open an FTDI device.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (this.ftDev != null) {
            this.stopRead();
            FT_Device fT_Device = this.ftDev;
            synchronized (fT_Device) {
                this.ftDev.close();
            }
            Log.d((String)TAG, (String)"An FTDI device is closed.");
        }
        return true;
    }

    @Override
    public int read(byte[] buf, int size) {
        return this.mBuffer.get(buf, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] buf, int size) {
        if (buf == null) {
            return 0;
        }
        int offset = 0;
        byte[] wbuf = new byte[256];
        while (offset < size) {
            int written_size;
            int write_size = 256;
            if (offset + write_size > size) {
                write_size = size - offset;
            }
            System.arraycopy(buf, offset, wbuf, 0, write_size);
            FT_Device fT_Device = this.ftDev;
            synchronized (fT_Device) {
                written_size = this.ftDev.write(wbuf, write_size);
            }
            if (written_size < 0) {
                return -1;
            }
            offset += written_size;
        }
        return offset;
    }

    private void stopRead() {
        this.mReadThreadStop = true;
    }

    private void startRead() {
        if (this.mReadThreadStop) {
            this.mReadThreadStop = false;
            new Thread(this.mLoop).start();
        }
    }

    @Override
    public boolean setUartConfig(UartConfig config) {
        boolean res = true;
        boolean ret = true;
        if (this.mUartConfig.baudrate != config.baudrate) {
            res = this.setBaudrate(config.baudrate);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.dataBits != config.dataBits) {
            res = this.setDataBits(config.dataBits);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.parity != config.parity) {
            res = this.setParity(config.parity);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.stopBits != config.stopBits) {
            res = this.setStopBits(config.stopBits);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.dtrOn != config.dtrOn || this.mUartConfig.rtsOn != config.rtsOn) {
            res = this.setDtrRts(config.dtrOn, config.rtsOn);
            ret = ret && res;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpened() {
        if (this.ftDev == null) {
            return false;
        }
        FT_Device fT_Device = this.ftDev;
        synchronized (fT_Device) {
            return this.ftDev.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBaudrate(int baudrate) {
        if (this.ftDev == null) {
            return false;
        }
        boolean ret = false;
        FT_Device fT_Device = this.ftDev;
        synchronized (fT_Device) {
            ret = this.ftDev.setBaudRate(baudrate);
        }
        if (ret) {
            this.mUartConfig.baudrate = baudrate;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDataBits(int dataBits) {
        if (this.ftDev == null) {
            return false;
        }
        boolean ret = false;
        byte ftdiDataBits = this.convertFtdiDataBits(dataBits);
        byte ftdiStopBits = this.convertFtdiStopBits(this.mUartConfig.stopBits);
        byte ftdiParity = this.convertFtdiParity(this.mUartConfig.parity);
        FT_Device fT_Device = this.ftDev;
        synchronized (fT_Device) {
            ret = this.ftDev.setDataCharacteristics(ftdiDataBits, ftdiStopBits, ftdiParity);
        }
        if (ret) {
            this.mUartConfig.dataBits = dataBits;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setParity(int parity) {
        if (this.ftDev == null) {
            return false;
        }
        boolean ret = false;
        byte ftdiDataBits = this.convertFtdiDataBits(this.mUartConfig.dataBits);
        byte ftdiStopBits = this.convertFtdiStopBits(this.mUartConfig.stopBits);
        byte ftdiParity = this.convertFtdiParity(parity);
        FT_Device fT_Device = this.ftDev;
        synchronized (fT_Device) {
            ret = this.ftDev.setDataCharacteristics(ftdiDataBits, ftdiStopBits, ftdiParity);
        }
        if (ret) {
            this.mUartConfig.parity = parity;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setStopBits(int stopBits) {
        if (this.ftDev == null) {
            return false;
        }
        boolean ret = false;
        byte ftdiDataBits = this.convertFtdiDataBits(this.mUartConfig.dataBits);
        byte ftdiStopBits = this.convertFtdiStopBits(stopBits);
        byte ftdiParity = this.convertFtdiParity(this.mUartConfig.parity);
        FT_Device fT_Device = this.ftDev;
        synchronized (fT_Device) {
            ret = this.ftDev.setDataCharacteristics(ftdiDataBits, ftdiStopBits, ftdiParity);
        }
        if (ret) {
            this.mUartConfig.stopBits = stopBits;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDtrRts(boolean dtrOn, boolean rtsOn) {
        FT_Device fT_Device;
        if (this.ftDev == null) {
            return false;
        }
        boolean retDtr = false;
        boolean retRts = false;
        if (dtrOn) {
            fT_Device = this.ftDev;
            synchronized (fT_Device) {
                retDtr = this.ftDev.setDtr();
            }
        }
        fT_Device = this.ftDev;
        synchronized (fT_Device) {
            retDtr = this.ftDev.clrDtr();
        }
        if (retDtr) {
            this.mUartConfig.dtrOn = dtrOn;
        }
        if (rtsOn) {
            fT_Device = this.ftDev;
            synchronized (fT_Device) {
                retRts = this.ftDev.setRts();
            }
        }
        fT_Device = this.ftDev;
        synchronized (fT_Device) {
            retRts = this.ftDev.clrRts();
        }
        if (retRts) {
            this.mUartConfig.rtsOn = rtsOn;
        }
        return retDtr && retRts;
    }

    @Override
    public UartConfig getUartConfig() {
        return this.mUartConfig;
    }

    @Override
    public int getBaudrate() {
        return this.mUartConfig.baudrate;
    }

    @Override
    public int getDataBits() {
        return this.mUartConfig.dataBits;
    }

    @Override
    public int getParity() {
        return this.mUartConfig.parity;
    }

    @Override
    public int getStopBits() {
        return this.mUartConfig.stopBits;
    }

    @Override
    public boolean getDtr() {
        return this.mUartConfig.dtrOn;
    }

    @Override
    public boolean getRts() {
        return this.mUartConfig.rtsOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBuffer() {
        FT_Device fT_Device = this.ftDev;
        synchronized (fT_Device) {
            this.ftDev.purge((byte)3);
        }
        this.mBuffer.clear();
    }

    @Override
    public void addReadListener(ReadLisener listener) {
        this.uartReadListenerList.add(listener);
    }

    @Override
    public void clearReadListener() {
        this.uartReadListenerList.clear();
    }

    @Override
    public void startReadListener() {
        this.mStopReadListener = false;
    }

    @Override
    public void stopReadListener() {
        this.mStopReadListener = true;
    }

    private void onRead(int size) {
        if (this.mStopReadListener) {
            return;
        }
        for (ReadLisener listener : this.uartReadListenerList) {
            listener.onRead(size);
        }
    }

    private byte convertFtdiDataBits(int dataBits) {
        switch (dataBits) {
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return 8;
    }

    private byte convertFtdiStopBits(int stopBits) {
        switch (stopBits) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private byte convertFtdiParity(int parity) {
        switch (parity) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    private String toHexStr(byte[] b, int length) {
        String str = "";
        int i = 0;
        while (i < length) {
            str = String.valueOf(str) + String.format("%02x ", b[i]);
            ++i;
        }
        return str;
    }
}

