/*
 * Decompiled with CFR 0.152.
 */
package cz.jaybee.intelhex;

import cz.jaybee.intelhex.IntelHexDataListener;
import cz.jaybee.intelhex.IntelHexRecordType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class IntelHexParser {
    private BufferedReader reader = null;
    private IntelHexDataListener dataListener = null;
    private static final int HEX = 16;
    private boolean eof = false;
    private int recordIdx = 0;
    private long upperAddress = 0L;

    public IntelHexParser(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public IntelHexParser(InputStream stream) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    public void setDataListener(IntelHexDataListener listener) {
        this.dataListener = listener;
    }

    private Record parseRecord(String record) throws Exception {
        Record result = new Record();
        if (this.eof) {
            throw new Exception("Data after eof (" + this.recordIdx + ")");
        }
        if (!record.startsWith(":")) {
            throw new Exception("Invalid Intel HEX record (" + this.recordIdx + ")");
        }
        int lineLength = record.length();
        byte[] hexRecord = new byte[lineLength / 2];
        int sum = 0;
        int i = 0;
        while (i < hexRecord.length) {
            String num = record.substring(2 * i + 1, 2 * i + 3);
            hexRecord[i] = (byte)Integer.parseInt(num, 16);
            sum += hexRecord[i] & 0xFF;
            ++i;
        }
        if ((sum &= 0xFF) != 0) {
            throw new Exception("Invalid checksum (" + this.recordIdx + ")");
        }
        result.length = hexRecord[0];
        if (result.length + 5 != hexRecord.length) {
            throw new Exception("Invalid record length (" + this.recordIdx + ")");
        }
        result.data = new byte[result.length];
        System.arraycopy(hexRecord, 4, result.data, 0, result.length);
        result.address = ((hexRecord[1] & 0xFF) << 8) + (hexRecord[2] & 0xFF);
        result.type = IntelHexRecordType.fromInt(hexRecord[3] & 0xFF);
        if (result.type == IntelHexRecordType.UNKNOWN) {
            throw new Exception("Unsupported record type " + (hexRecord[3] & 0xFF) + " (" + this.recordIdx + ")");
        }
        return result;
    }

    private void processRecord(Record record) throws Exception {
        long addr = (long)record.address | this.upperAddress;
        switch (record.type) {
            case DATA: {
                if (this.dataListener == null) break;
                this.dataListener.data(addr, record.data);
                break;
            }
            case EOF: {
                if (this.dataListener != null) {
                    this.dataListener.eof();
                }
                this.eof = true;
                break;
            }
            case EXT_LIN: {
                if (record.length == 2) {
                    this.upperAddress = ((record.data[0] & 0xFF) << 8) + (record.data[1] & 0xFF);
                    this.upperAddress <<= 16;
                    break;
                }
                throw new Exception("Invalid EXT_LIN record (" + this.recordIdx + ")");
            }
            case EXT_SEG: {
                if (record.length == 2) {
                    this.upperAddress = ((record.data[0] & 0xFF) << 8) + (record.data[1] & 0xFF);
                    this.upperAddress <<= 4;
                    break;
                }
                throw new Exception("Invalid EXT_SEG record (" + this.recordIdx + ")");
            }
            case START_SEG: 
            case START_LIN: {
                throw new Exception((Object)((Object)record.type) + " record not implemented (" + this.recordIdx + ")");
            }
        }
    }

    public void parse() throws IOException, Exception {
        String recordStr;
        this.recordIdx = 1;
        this.upperAddress = 0L;
        while ((recordStr = this.reader.readLine()) != null) {
            Record record = this.parseRecord(recordStr);
            this.processRecord(record);
            ++this.recordIdx;
        }
        if (!this.eof) {
            throw new Exception("No eof at the end of file");
        }
    }

    private class Record {
        int length;
        int address;
        IntelHexRecordType type;
        byte[] data;

        private Record() {
        }
    }
}

