/*
 * Decompiled with CFR 0.152.
 */
package cz.jaybee.intelhex;

import cz.jaybee.intelhex.IntelHexDataListener;
import java.util.Arrays;

public class IntelHexParserRun
implements IntelHexDataListener {
    private long addressStart;
    private long addressStop;
    private long length;
    private long totalLength;
    private byte[] buffer;
    private boolean eofDone = false;

    public IntelHexParserRun(long addressStart, long addressStop) {
        this.addressStart = addressStart;
        this.addressStop = addressStop;
        this.length = addressStop - addressStart + 1L;
        this.totalLength = 0L;
        this.buffer = new byte[(int)this.length];
        Arrays.fill(this.buffer, (byte)-1);
        this.eofDone = false;
    }

    public void getBufData(byte[] buf) {
        int copyLen = (int)this.length;
        if (copyLen > buf.length) {
            copyLen = buf.length;
        }
        System.arraycopy(this.buffer, 0, buf, 0, copyLen);
    }

    public long getTotalBufLength() {
        return this.totalLength;
    }

    public boolean isEOF() {
        return this.eofDone;
    }

    @Override
    public void data(long address, byte[] data) {
        if (address >= this.addressStart && address <= this.addressStop) {
            int length = data.length;
            if (address + (long)length > this.addressStop) {
                length = (int)(this.addressStop - address + 1L);
            }
            System.arraycopy(data, 0, this.buffer, (int)(address - this.addressStart), length);
            this.totalLength += (long)length;
        }
    }

    @Override
    public void eof() {
        this.eofDone = true;
    }
}

