/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib;

import android.content.Context;
import android.util.Log;
import com.physicaloid.lib.Boards;
import com.physicaloid.lib.framework.AutoCommunicator;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.framework.Uploader;
import com.physicaloid.lib.programmer.avr.UploadErrors;
import com.physicaloid.lib.usb.driver.uart.ReadLisener;
import com.physicaloid.lib.usb.driver.uart.UartConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class Physicaloid {
    private static final boolean DEBUG_SHOW = true;
    private static final String TAG = Physicaloid.class.getSimpleName();
    private Context mContext;
    private Boards mBoard;
    protected SerialCommunicator mSerial;
    private Uploader mUploader;
    private Thread mUploadThread;
    private UploadCallBack mCallBack;
    private InputStream mFileStream;
    private static final Object LOCK = new Object();
    protected static final Object LOCK_WRITE = new Object();
    protected static final Object LOCK_READ = new Object();
    boolean serialIsNull = false;

    public Physicaloid(Context context) {
        this.mContext = context;
    }

    public boolean open() throws RuntimeException {
        return this.open(new UartConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(UartConfig uart) throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.mSerial != null) break block5;
                    this.mSerial = new AutoCommunicator().getSerialCommunicator(this.mContext);
                    if (this.mSerial != null) break block5;
                    return false;
                }
                if (!this.mSerial.open()) break block6;
                this.mSerial.setUartConfig(uart);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.mSerial != null) break block5;
                    return true;
                }
                if (!this.mSerial.close()) break block6;
                this.mSerial = null;
                return true;
            }
            return false;
        }
    }

    public int read(byte[] buf) throws RuntimeException {
        if (this.mSerial == null) {
            return 0;
        }
        return this.read(buf, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int size) throws RuntimeException {
        Object object = LOCK_READ;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return 0;
            }
            return this.mSerial.read(buf, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReadListener(ReadLisener listener) throws RuntimeException {
        Object object = LOCK_READ;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.mSerial != null) break block5;
                    return false;
                }
                if (listener != null) break block6;
                return false;
            }
            this.mSerial.addReadListener(listener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReadListener() throws RuntimeException {
        Object object = LOCK_READ;
        synchronized (object) {
            if (this.mSerial == null) {
                return;
            }
            this.mSerial.clearReadListener();
        }
    }

    public int write(byte[] buf) throws RuntimeException {
        if (this.mSerial == null) {
            return 0;
        }
        return this.write(buf, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] buf, int size) throws RuntimeException {
        Object object = LOCK_WRITE;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return 0;
            }
            return this.mSerial.write(buf, size);
        }
    }

    public void upload(Boards board, String filePath) throws RuntimeException {
        this.upload(board, filePath, null);
    }

    public void upload(Boards board, String filePath, UploadCallBack callback) throws RuntimeException {
        FileInputStream is;
        if (filePath == null) {
            if (callback != null) {
                callback.onError(UploadErrors.FILE_OPEN);
            }
            return;
        }
        File file = new File(filePath);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            if (callback != null) {
                callback.onError(UploadErrors.FILE_OPEN);
            }
            return;
        }
        try {
            is = new FileInputStream(filePath);
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(UploadErrors.FILE_OPEN);
            }
            return;
        }
        this.upload(board, is, callback);
    }

    public void upload(Boards board, InputStream fileStream) throws RuntimeException {
        this.upload(board, fileStream, null);
    }

    public void upload(Boards board, InputStream fileStream, UploadCallBack callback) throws RuntimeException {
        this.mUploader = new Uploader();
        this.mCallBack = callback;
        this.mFileStream = fileStream;
        this.mBoard = board;
        if (this.mSerial == null) {
            Log.d((String)TAG, (String)"upload : mSerial is null");
            this.mSerial = new AutoCommunicator().getSerialCommunicator(this.mContext);
            this.serialIsNull = true;
        }
        this.mUploadThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LOCK;
                synchronized (object) {
                    Object object2 = LOCK_WRITE;
                    synchronized (object2) {
                        Object object3 = LOCK_READ;
                        synchronized (object3) {
                            UartConfig tmpUartConfig = new UartConfig();
                            if (Physicaloid.this.mSerial == null) {
                                Log.d((String)TAG, (String)"upload : mSerial is null");
                                if (Physicaloid.this.mCallBack != null) {
                                    Physicaloid.this.mCallBack.onError(UploadErrors.OPEN_DEVICE);
                                }
                                Physicaloid.this.mBoard = null;
                                Physicaloid.this.mFileStream = null;
                                Physicaloid.this.mCallBack = null;
                                Physicaloid.this.mUploader = null;
                                Physicaloid.this.mSerial = null;
                                return;
                            }
                            if (!Physicaloid.this.mSerial.isOpened()) {
                                if (!Physicaloid.this.mSerial.open()) {
                                    Log.d((String)TAG, (String)"upload : cannot mSerial.open");
                                    if (Physicaloid.this.mCallBack != null) {
                                        Physicaloid.this.mCallBack.onError(UploadErrors.OPEN_DEVICE);
                                    }
                                    Physicaloid.this.mBoard = null;
                                    Physicaloid.this.mFileStream = null;
                                    Physicaloid.this.mCallBack = null;
                                    Physicaloid.this.mUploader = null;
                                    Physicaloid.this.mSerial = null;
                                    return;
                                }
                                Log.d((String)TAG, (String)"upload : open successful");
                            } else {
                                UartConfig origUartConfig = Physicaloid.this.mSerial.getUartConfig();
                                tmpUartConfig.baudrate = origUartConfig.baudrate;
                                tmpUartConfig.dataBits = origUartConfig.dataBits;
                                tmpUartConfig.stopBits = origUartConfig.stopBits;
                                tmpUartConfig.parity = origUartConfig.parity;
                                tmpUartConfig.dtrOn = origUartConfig.dtrOn;
                                tmpUartConfig.rtsOn = origUartConfig.rtsOn;
                                Log.d((String)TAG, (String)"upload : already open");
                            }
                            Physicaloid.this.mSerial.stopReadListener();
                            Physicaloid.this.mSerial.clearBuffer();
                            Physicaloid.this.mUploader.upload(Physicaloid.this.mFileStream, Physicaloid.this.mBoard, Physicaloid.this.mSerial, Physicaloid.this.mCallBack);
                            Physicaloid.this.mSerial.setUartConfig(tmpUartConfig);
                            Physicaloid.this.mSerial.clearBuffer();
                            Physicaloid.this.mSerial.startReadListener();
                            if (Physicaloid.this.serialIsNull) {
                                Physicaloid.this.mSerial.close();
                            }
                            Physicaloid.this.mBoard = null;
                            Physicaloid.this.mFileStream = null;
                            Physicaloid.this.mCallBack = null;
                            Physicaloid.this.mUploader = null;
                        }
                    }
                }
            }
        });
        this.mUploadThread.start();
    }

    public void cancelUpload() {
        if (this.mUploadThread == null) {
            return;
        }
        this.mUploadThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return false;
            }
            return this.mSerial.isOpened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(UartConfig settings) throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            if (this.mSerial == null) {
                return;
            }
            this.mSerial.setUartConfig(settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBaudrate(int baudrate) throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return false;
            }
            return this.mSerial.setBaudrate(baudrate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDataBits(int dataBits) throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return false;
            }
            return this.mSerial.setDataBits(dataBits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setParity(int parity) throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return false;
            }
            return this.mSerial.setParity(parity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStopBits(int stopBits) throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return false;
            }
            return this.mSerial.setStopBits(stopBits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDtrRts(boolean dtrOn, boolean rtsOn) throws RuntimeException {
        Object object = LOCK;
        synchronized (object) {
            block4: {
                if (this.mSerial != null) break block4;
                return false;
            }
            return this.mSerial.setDtrRts(dtrOn, rtsOn);
        }
    }

    public static interface UploadCallBack {
        public void onPreUpload();

        public void onUploading(int var1);

        public void onPostUpload(boolean var1);

        public void onCancel();

        public void onError(UploadErrors var1);
    }
}

