/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.fpga;

import com.physicaloid.lib.framework.SerialCommunicator;

public class PhysicaloidFpgaPacketFilter {
    private static final boolean DEBUG_SHOW = false;
    private static final String TAG = PhysicaloidFpgaPacketFilter.class.getSimpleName();

    public int writeWithEscape(SerialCommunicator comm, byte[] buf, int size) {
        return this.writeWithEscape(comm, buf, 0, size);
    }

    public int writeWithEscape(SerialCommunicator comm, byte[] buf, int offset, int size) {
        if (comm == null) {
            return 0;
        }
        if (buf == null) {
            return 0;
        }
        int totalWrittenSize = 0;
        byte[] packet = this.createEscapedPacket(buf, offset, size);
        totalWrittenSize = comm.write(packet, packet.length);
        while (totalWrittenSize < packet.length) {
            int remainingSize = packet.length - totalWrittenSize;
            byte[] tmpBuf = new byte[remainingSize];
            System.arraycopy(packet, totalWrittenSize, tmpBuf, 0, remainingSize);
            totalWrittenSize += comm.write(tmpBuf, tmpBuf.length);
        }
        return size;
    }

    public byte[] createEscapedPacket(byte[] buf, int offset, int size) {
        if (buf == null) {
            return null;
        }
        int bufPointer = 0;
        int escapedBufPointer = 0;
        byte[] escapedPacket = new byte[buf.length * 2];
        int i = 0;
        while (i < size) {
            bufPointer = i + offset;
            escapedPacket[escapedBufPointer] = buf[bufPointer];
            ++escapedBufPointer;
            if (buf[bufPointer] == 58 || buf[bufPointer] == 61) {
                escapedPacket[escapedBufPointer - 1] = 61;
                escapedPacket[escapedBufPointer] = (byte)(buf[bufPointer] ^ 0x20);
                ++escapedBufPointer;
            }
            ++i;
        }
        byte[] packet = new byte[escapedBufPointer];
        System.arraycopy(escapedPacket, 0, packet, 0, escapedBufPointer);
        return packet;
    }

    private String toHexStr(byte[] b, int length) {
        String str = "";
        int i = 0;
        while (i < length) {
            str = String.valueOf(str) + String.format("%02x ", b[i]);
            ++i;
        }
        return str;
    }
}

