/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.framework;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import com.physicaloid.lib.UsbVidList;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.usb.UsbAccessor;
import com.physicaloid.lib.usb.driver.uart.UartCdcAcm;
import com.physicaloid.lib.usb.driver.uart.UartCp210x;
import com.physicaloid.lib.usb.driver.uart.UartFtdi;

public class AutoCommunicator {
    private static final String TAG = AutoCommunicator.class.getSimpleName();

    public SerialCommunicator getSerialCommunicator(Context context) {
        UsbAccessor usbAccess = UsbAccessor.INSTANCE;
        usbAccess.init(context);
        for (UsbDevice device : usbAccess.manager().getDeviceList().values()) {
            int vid = device.getVendorId();
            UsbVidList[] usbVidListArray = UsbVidList.values();
            int n = usbVidListArray.length;
            int n2 = 0;
            while (n2 < n) {
                UsbVidList usbVid = usbVidListArray[n2];
                if (vid == usbVid.getVid()) {
                    if (vid == UsbVidList.FTDI.getVid()) {
                        return new UartFtdi(context);
                    }
                    if (vid == UsbVidList.CP210X.getVid()) {
                        return new UartCp210x(context);
                    }
                    return new UartCdcAcm(context);
                }
                ++n2;
            }
        }
        return null;
    }
}

