/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.programmer.avr;

import com.physicaloid.lib.programmer.avr.AvrConf;

class AVRMem {
    public static final int AVR_OP_READ = 0;
    public static final int AVR_OP_WRITE = 1;
    public static final int AVR_OP_READ_LO = 2;
    public static final int AVR_OP_READ_HI = 3;
    public static final int AVR_OP_WRITE_LO = 4;
    public static final int AVR_OP_WRITE_HI = 5;
    public static final int AVR_OP_LOADPAGE_LO = 6;
    public static final int AVR_OP_LOADPAGE_HI = 7;
    public static final int AVR_OP_LOAD_EXT_ADDR = 8;
    public static final int AVR_OP_WRITEPAGE = 9;
    public static final int AVR_OP_CHIP_ERASE = 10;
    public static final int AVR_OP_PGM_ENABLE = 11;
    public static final int AVR_OP_MAX = 12;
    public static final int AVR_CMDBIT_IGNORE = 0;
    public static final int AVR_CMDBIT_VALUE = 1;
    public static final int AVR_CMDBIT_ADDRESS = 2;
    public static final int AVR_CMDBIT_INPUT = 3;
    public static final int AVR_CMDBIT_OUTPUT = 4;
    String desc;
    boolean paged;
    int size;
    int page_size;
    int num_pages;
    long offset;
    int min_write_delay;
    int max_write_delay;
    int pwroff_after_write;
    byte[] readback;
    int mode;
    int delay;
    int blocksize;
    int readsize;
    int pollindex;
    byte[] buf;
    OPCODE[] op;

    AVRMem(AvrConf avrConf) {
        this.desc = avrConf.flash.desc;
        this.paged = avrConf.flash.paged;
        this.size = avrConf.flash.size;
        this.page_size = avrConf.flash.page_size;
        this.num_pages = avrConf.flash.num_pages;
        this.offset = 0L;
        this.min_write_delay = avrConf.flash.min_write_delay;
        this.max_write_delay = avrConf.flash.max_write_delay;
        this.pwroff_after_write = 0;
        this.readback = new byte[2];
        this.readback[0] = (byte)avrConf.flash.readback_p1;
        this.readback[1] = (byte)avrConf.flash.readback_p2;
        this.mode = avrConf.flash.mode;
        this.delay = avrConf.flash.delay;
        this.blocksize = avrConf.flash.blocksize;
        this.readsize = avrConf.flash.readsize;
        this.pollindex = 0;
        this.buf = null;
        this.op = new OPCODE[12];
        int i = 0;
        while (i < 12) {
            this.op[i] = new OPCODE();
            ++i;
        }
        this.parseOpcode(this.op[2], avrConf.flash.read_lo);
        this.parseOpcode(this.op[3], avrConf.flash.read_hi);
        this.parseOpcode(this.op[6], avrConf.flash.loadpage_lo);
        this.parseOpcode(this.op[7], avrConf.flash.loadpage_hi);
        this.parseOpcode(this.op[8], avrConf.flash.load_ext_addr);
        this.parseOpcode(this.op[9], avrConf.flash.writepage);
    }

    void setBuf(byte[] inBuf, int length) {
        this.buf = new byte[length];
        System.arraycopy(inBuf, 0, this.buf, 0, length);
    }

    void parseOpcode(OPCODE op, String[] mem) {
        String tmpstr = "";
        int no = 31;
        if (mem == null) {
            return;
        }
        int i = 0;
        while (i < mem.length) {
            tmpstr = String.valueOf(tmpstr) + mem[i] + " ";
            ++i;
        }
        while (tmpstr.charAt(0) == ' ') {
            tmpstr = tmpstr.substring(1);
        }
        String[] str = tmpstr.split("[\\s]+");
        i = 0;
        while (i < 32) {
            if (str[i].charAt(0) == '0') {
                op.bit[no].type = 1;
                op.bit[no].bitno = no % 8;
                op.bit[no].value = 0;
            } else if (str[i].charAt(0) == '1') {
                op.bit[no].type = 1;
                op.bit[no].bitno = no % 8;
                op.bit[no].value = 1;
            } else if (str[i].charAt(0) == 'i') {
                op.bit[no].type = 3;
                op.bit[no].bitno = no % 8;
                op.bit[no].value = 0;
            } else if (str[i].charAt(0) == 'o') {
                op.bit[no].type = 4;
                op.bit[no].bitno = no % 8;
                op.bit[no].value = 0;
            } else if (str[i].charAt(0) == 'a') {
                op.bit[no].type = 2;
                op.bit[no].bitno = Integer.valueOf(str[i].substring(1));
                op.bit[no].value = 0;
            } else if (str[i].charAt(0) == 'x') {
                op.bit[no].type = 0;
                op.bit[no].bitno = no % 8;
                op.bit[no].value = 0;
            }
            --no;
            ++i;
        }
    }

    class OPCODE {
        CMDBIT[] bit = new CMDBIT[32];

        OPCODE() {
            int i = 0;
            while (i < 32) {
                this.bit[i] = new CMDBIT();
                ++i;
            }
        }

        class CMDBIT {
            public int type;
            public int bitno;
            public int value;

            CMDBIT() {
            }
        }
    }
}

