/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.programmer.avr;

import android.util.Log;
import com.physicaloid.lib.Boards;
import com.physicaloid.lib.Physicaloid;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.programmer.avr.AVRMem;
import com.physicaloid.lib.programmer.avr.AvrConf;
import com.physicaloid.lib.programmer.avr.IntelHexFileToBuf;
import com.physicaloid.lib.programmer.avr.Stk500;
import com.physicaloid.lib.programmer.avr.Stk500V2;
import com.physicaloid.lib.programmer.avr.UploadErrors;
import com.physicaloid.lib.programmer.avr.UploadProtocol;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class AvrUploader {
    private static final String TAG = AvrUploader.class.getSimpleName();
    private static final boolean DEBUG_SHOW_HEXDUMP = false;
    private UploadProtocol mProg;
    private SerialCommunicator mComm;
    private IntelHexFileToBuf mIntelHex;
    private AvrConf mAVRConf;
    private AVRMem mAVRMem;

    public AvrUploader(SerialCommunicator serial) {
        this.mComm = serial;
    }

    public void setSerial(SerialCommunicator serial) {
        this.mComm = serial;
    }

    public boolean run(String filePath, Boards board, Physicaloid.UploadCallBack callback) {
        FileInputStream is;
        if (filePath == null) {
            if (callback != null) {
                callback.onError(UploadErrors.FILE_OPEN);
            }
            return false;
        }
        File file = new File(filePath);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            if (callback != null) {
                callback.onError(UploadErrors.FILE_OPEN);
            }
            return false;
        }
        try {
            is = new FileInputStream(filePath);
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(UploadErrors.FILE_OPEN);
            }
            return false;
        }
        return this.run(is, board, callback);
    }

    public boolean run(InputStream hexFile, Boards board, Physicaloid.UploadCallBack callback) {
        if (board == null) {
            if (callback != null) {
                callback.onError(UploadErrors.AVR_CHIPTYPE);
            }
            return false;
        }
        if (board.uploadProtocol == 1) {
            this.mProg = new Stk500();
        } else if (board.uploadProtocol == 2) {
            this.mProg = new Stk500V2();
        } else {
            if (callback != null) {
                callback.onError(UploadErrors.AVR_CHIPTYPE);
            }
            return false;
        }
        this.mProg.setSerial(this.mComm);
        this.mProg.setCallback(callback);
        try {
            this.setConfig(board);
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(UploadErrors.AVR_CHIPTYPE);
            }
            return false;
        }
        try {
            this.getFileToBuf(hexFile);
        }
        catch (Exception e) {
            this.mIntelHex = null;
            if (callback != null) {
                callback.onError(UploadErrors.HEX_FILE_OPEN);
            }
            return false;
        }
        this.mProg.setConfig(this.mAVRConf, this.mAVRMem);
        this.mProg.open();
        this.mProg.enable();
        int initOK = this.mProg.initialize();
        if (initOK < 0) {
            Log.e((String)TAG, (String)("initialization failed (" + initOK + ")"));
            if (callback != null) {
                callback.onError(UploadErrors.CHIP_INIT);
            }
            return false;
        }
        int sigOK = this.mProg.check_sig_bytes();
        if (sigOK != 0) {
            Log.e((String)TAG, (String)("check signature failed (" + sigOK + ")"));
            if (callback != null) {
                callback.onError(UploadErrors.SIGNATURE);
            }
            return false;
        }
        int writeOK = this.mProg.paged_write();
        if (writeOK == 0) {
            return false;
        }
        if (writeOK < 0) {
            Log.e((String)TAG, (String)("paged write failed (" + initOK + ")"));
            if (callback != null) {
                callback.onError(UploadErrors.PAGE_WRITE);
            }
            return false;
        }
        this.mProg.disable();
        return true;
    }

    private void setConfig(Boards board) throws InterruptedException {
        this.mAVRConf = new AvrConf(board);
        this.mAVRMem = new AVRMem(this.mAVRConf);
    }

    private void getFileToBuf(InputStream hexFile) throws FileNotFoundException, IOException, Exception {
        this.mIntelHex = new IntelHexFileToBuf();
        this.mIntelHex.parse(hexFile);
        long byteLength = this.mIntelHex.getByteLength();
        this.mAVRMem.buf = new byte[(int)byteLength];
        this.mIntelHex.getHexData(this.mAVRMem.buf);
        this.mIntelHex = null;
    }
}

