/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.programmer.avr;

import android.util.Log;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.programmer.avr.AVRMem;
import com.physicaloid.lib.programmer.avr.AvrConf;
import com.physicaloid.lib.programmer.avr.UploadProtocol;
import java.util.Arrays;

public class Stk500
extends UploadProtocol {
    private static final String TAG = Stk500.class.getSimpleName();
    private static final boolean DEBUG_NOT_SHOW = true;
    private static final boolean DEBUG_SHOW_SEND = false;
    private static final boolean DEBUG_SHOW_RECV = false;
    private static final boolean DEBUG_SHOW_DRAIN = false;
    private static final boolean DEBUG_SHOW_DUMP_LOGE = false;
    SerialCommunicator mComm;
    AvrConf mAVRConf;
    AVRMem mAVRMem;
    boolean mCanceled = false;

    @Override
    public void setSerial(SerialCommunicator comm) {
        this.mComm = comm;
    }

    @Override
    public void setConfig(AvrConf avrConf, AVRMem avrMem) {
        this.mAVRConf = avrConf;
        this.mAVRMem = avrMem;
    }

    private int send(byte[] buf, int length) {
        int retval = this.mComm.write(buf, length);
        return retval;
    }

    private int recv(byte[] buf, int length) {
        int retval;
        block2: {
            long endTime;
            retval = 0;
            int totalRetval = 0;
            long startTime = System.currentTimeMillis();
            byte[] tmpbuf = new byte[length];
            do {
                if ((retval = this.mComm.read(tmpbuf, length)) > 0) {
                    System.arraycopy(tmpbuf, 0, buf, totalRetval, retval);
                    totalRetval += retval;
                    startTime = System.currentTimeMillis();
                }
                if (totalRetval >= length) break block2;
            } while ((endTime = System.currentTimeMillis()) - startTime <= 250L);
            Log.e((String)TAG, (String)"recv timeout.");
        }
        return retval;
    }

    private int drain() {
        long endTime;
        byte[] buf = new byte[1];
        int retval = 0;
        long startTime = System.currentTimeMillis();
        do {
            if ((retval = this.mComm.read(buf, 1)) <= 0) continue;
        } while ((endTime = System.currentTimeMillis()) - startTime <= 1000L);
        return retval;
    }

    private int getsync() {
        byte[] buf = new byte[32];
        byte[] resp = new byte[32];
        buf[0] = 48;
        buf[1] = 32;
        this.send(buf, 2);
        this.drain();
        this.send(buf, 2);
        this.drain();
        this.send(buf, 2);
        if (this.recv(resp, 1) < 0) {
            return -1;
        }
        if (resp[0] != 20) {
            Log.e((String)TAG, (String)("STK500.getsync(): not in sync: resp=" + this.toHexStr(resp[0])));
            this.drain();
            return -1;
        }
        if (this.recv(resp, 1) < 0) {
            return -1;
        }
        if (resp[0] != 16) {
            Log.e((String)TAG, (String)("STK500.getsync(): can't communicate with device: resp=" + this.toHexStr(resp[0])));
            return -1;
        }
        return 0;
    }

    private void dumpLogE(byte[] buf) {
    }

    @Override
    public int check_sig_bytes() {
        byte[] buf = new byte[32];
        buf[0] = 117;
        buf[1] = 32;
        this.send(buf, 2);
        if (this.recv(buf, 5) < 0) {
            return -1;
        }
        if (buf[0] == 21) {
            Log.e((String)TAG, (String)"STK500.cmd(): programmer is out of sync");
            this.dumpLogE(buf);
            return -1;
        }
        if (buf[0] != 20) {
            Log.e((String)TAG, (String)("STK500.read_sig_bytes(): (a) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
            this.dumpLogE(buf);
            return -2;
        }
        if (buf[4] != 16) {
            Log.e((String)TAG, (String)("STK500.read_sig_bytes(): (a) protocol error, expect=" + this.toHexStr((byte)16) + ", resp=" + this.toHexStr(buf[4])));
            this.dumpLogE(buf);
            return -3;
        }
        if (this.mAVRConf.signature[0] == buf[1] && this.mAVRConf.signature[1] == buf[2] && this.mAVRConf.signature[2] == buf[3]) {
            return 0;
        }
        return -4;
    }

    @Override
    public int open() {
        this.setDtrRts(false);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setDtrRts(true);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.drain();
        if (this.getsync() < 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public void enable() {
    }

    @Override
    public int initialize() {
        byte[] buf = new byte[32];
        int[] majArr = new int[1];
        int[] minArr = new int[1];
        int maj = 0;
        int min = 0;
        this.getparm((byte)-127, majArr);
        this.getparm((byte)-126, minArr);
        maj = majArr[0];
        min = minArr[0];
        int n_extparms = maj > 1 || maj == 1 && min > 10 ? 4 : 3;
        int tries = 0;
        boolean bRetry = true;
        while (bRetry) {
            int rc;
            bRetry = false;
            ++tries;
            Arrays.fill(buf, (byte)0);
            buf[0] = 66;
            buf[1] = this.mAVRConf.stk500_devcode;
            buf[2] = 0;
            buf[3] = 0;
            buf[4] = 1;
            buf[5] = 1;
            buf[6] = 1;
            buf[7] = (byte)this.mAVRConf.lock.size;
            buf[8] = 0;
            buf[8] = (byte)(buf[8] + (byte)this.mAVRConf.fuse.size);
            buf[8] = (byte)(buf[8] + (byte)this.mAVRConf.lfuse.size);
            buf[8] = (byte)(buf[8] + (byte)this.mAVRConf.hfuse.size);
            buf[8] = (byte)(buf[8] + (byte)this.mAVRConf.efuse.size);
            buf[9] = (byte)this.mAVRConf.flash.readback_p1;
            buf[10] = (byte)this.mAVRConf.flash.readback_p2;
            if (this.mAVRConf.flash.paged) {
                buf[13] = (byte)(this.mAVRConf.flash.page_size >> 8 & 0xFF);
                buf[14] = (byte)(this.mAVRConf.flash.page_size & 0xFF);
            }
            buf[17] = (byte)(this.mAVRConf.flash.size >> 24 & 0xFF);
            buf[18] = (byte)(this.mAVRConf.flash.size >> 16 & 0xFF);
            buf[19] = (byte)(this.mAVRConf.flash.size >> 8 & 0xFF);
            buf[20] = (byte)(this.mAVRConf.flash.size & 0xFF);
            buf[11] = (byte)this.mAVRConf.eeprom.readback_p1;
            buf[12] = (byte)this.mAVRConf.eeprom.readback_p2;
            buf[15] = (byte)(this.mAVRConf.eeprom.size >> 8 & 0xFF);
            buf[16] = (byte)(this.mAVRConf.eeprom.size & 0xFF);
            buf[21] = 32;
            this.send(buf, 22);
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 21) {
                Log.e((String)TAG, (String)("STK500.initialize(): programmer not in sync, resp=" + this.toHexStr(buf[0])));
                if (tries > 33) {
                    return -1;
                }
                if (this.getsync() < 0) {
                    return -1;
                }
                bRetry = true;
                continue;
            }
            if (buf[0] != 20) {
                Log.e((String)TAG, (String)("STK500.initialize(): (a) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
                return -1;
            }
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] != 16) {
                Log.e((String)TAG, (String)("STK500.initialize(): (b) protocol error, expect=" + this.toHexStr((byte)16) + ", resp=" + this.toHexStr(buf[0])));
                return -1;
            }
            if (n_extparms == 0) continue;
            if (this.mAVRConf.pagel == 0 || this.mAVRConf.bs2 == 0) {
                Log.e((String)TAG, (String)("please define PAGEL and BS2 signals in the configuration file for part " + this.mAVRConf.desc));
                continue;
            }
            buf[0] = (byte)(n_extparms + 1);
            buf[1] = (byte)this.mAVRConf.eeprom.page_size;
            buf[2] = this.mAVRConf.pagel;
            buf[3] = this.mAVRConf.bs2;
            if (n_extparms == 4) {
                buf[4] = 0;
            }
            if ((rc = this.set_extended_parms(n_extparms + 1, buf)) == 0) continue;
            Log.e((String)TAG, (String)"STK500.initialize(): failed");
            return -1;
        }
        return this.program_enable();
    }

    private int program_enable() {
        byte[] buf = new byte[16];
        int tries = 0;
        boolean bRetry = true;
        while (bRetry) {
            bRetry = false;
            ++tries;
            buf[0] = 80;
            buf[1] = 32;
            this.send(buf, 2);
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 21) {
                if (tries > 33) {
                    Log.e((String)TAG, (String)"STK500.program_enable(): can't get into sync");
                    return -1;
                }
                if (this.getsync() < 0) {
                    return -1;
                }
                bRetry = true;
                continue;
            }
            if (buf[0] != 20) {
                Log.e((String)TAG, (String)("STK500.program_enable(): protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
                return -1;
            }
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 16) {
                return 0;
            }
            if (buf[0] == 19) {
                Log.e((String)TAG, (String)"STK500.program_enable(): no device");
                return -1;
            }
            if (buf[0] == 17) {
                Log.e((String)TAG, (String)"STK500.program_enable(): failed to enter programming mode");
                return -1;
            }
            Log.e((String)TAG, (String)("STK500.program_enable(): unknown response=" + this.toHexStr(buf[0])));
        }
        return -1;
    }

    private int getparm(byte parm, int[] value) {
        byte[] buf = new byte[16];
        int tries = 0;
        boolean bRetry = true;
        while (bRetry) {
            bRetry = false;
            ++tries;
            buf[0] = 65;
            buf[1] = parm;
            buf[2] = 32;
            this.send(buf, 3);
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 21) {
                if (tries > 33) {
                    Log.e((String)TAG, (String)"STK500.getparm(): can't get into sync\n");
                    return -1;
                }
                if (this.getsync() < 0) {
                    return -1;
                }
                bRetry = true;
                continue;
            }
            if (buf[0] != 20) {
                Log.e((String)TAG, (String)("STK500.getparm(): (a) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
                return -2;
            }
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            int v = buf[0];
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 17) {
                Log.e((String)TAG, (String)("STK500.getparm(): parameter " + this.toHexStr((byte)v) + " failed"));
                return -3;
            }
            if (buf[0] != 16) {
                Log.e((String)TAG, (String)("STK500.getparm(): (a) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
                return -3;
            }
            value[0] = v;
        }
        return 0;
    }

    private int set_extended_parms(int n, byte[] cmd) {
        byte[] buf = new byte[16];
        int tries = 0;
        boolean bRetry = true;
        while (bRetry) {
            bRetry = false;
            ++tries;
            buf[0] = 69;
            System.arraycopy(cmd, 0, buf, 1, n);
            int i = n + 1;
            buf[i] = 32;
            this.send(buf, i + 1);
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 21) {
                if (tries > 33) {
                    Log.e((String)TAG, (String)"STK500.set_extended_parms(): can't get into sync");
                    return -1;
                }
                if (this.getsync() < 0) {
                    return -1;
                }
                bRetry = true;
                continue;
            }
            if (buf[0] != 20) {
                Log.e((String)TAG, (String)("STK500.set_extended_parms(): protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
                return -1;
            }
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 16) {
                return 0;
            }
            if (buf[0] == 19) {
                Log.e((String)TAG, (String)"STK500_set_extended_parms(): no device");
                return -1;
            }
            if (buf[0] == 17) {
                Log.e((String)TAG, (String)"STK500.set_extended_parms(): failed to set extended device programming parameters");
                return -1;
            }
            Log.e((String)TAG, (String)("STK500.set_extended_parms(): unknown response=" + this.toHexStr(buf[0])));
        }
        return -1;
    }

    @Override
    public int paged_write() {
        long n;
        boolean flash;
        int memtype;
        int page_size = this.mAVRMem.page_size;
        int n_bytes = this.mAVRMem.buf.length;
        byte[] buf = new byte[page_size + 16];
        int block_size = 0;
        boolean bRetry = true;
        if (page_size == 0) {
            page_size = 128;
        }
        if (this.mAVRMem.desc.compareTo("flash") == 0) {
            memtype = 70;
            flash = true;
        } else if (this.mAVRMem.desc.compareTo("eeprom") == 0) {
            memtype = 69;
            flash = false;
        } else {
            return -2;
        }
        int a_div = 2;
        if (n_bytes > this.mAVRMem.size) {
            n_bytes = this.mAVRMem.size;
            n = this.mAVRMem.size;
        } else {
            n = n_bytes % page_size != 0 ? (long)(n_bytes + page_size - n_bytes % page_size) : (long)n_bytes;
        }
        int addr = 0;
        while ((long)addr < n) {
            if (Thread.interrupted()) {
                this.report_cancel();
                return 0;
            }
            this.report_progress((int)((long)(addr * 100) / n));
            block_size = page_size;
            if (!flash || !this.is_page_empty(addr, block_size, this.mAVRMem.buf)) {
                int tries = 0;
                bRetry = true;
                while (bRetry) {
                    bRetry = false;
                    ++tries;
                    this.loadaddr(addr / a_div);
                    int i = 0;
                    int send_size = block_size;
                    if (addr + send_size > n_bytes) {
                        send_size -= addr + send_size - n_bytes;
                    }
                    buf[i++] = 100;
                    buf[i++] = (byte)(send_size >> 8 & 0xFF);
                    buf[i++] = (byte)(send_size & 0xFF);
                    buf[i++] = (byte)memtype;
                    System.arraycopy(this.mAVRMem.buf, addr, buf, i, send_size);
                    i += send_size;
                    buf[i++] = 32;
                    this.send(buf, i);
                    if (this.recv(buf, 1) < 0) {
                        return -1;
                    }
                    if (buf[0] == 21) {
                        if (tries > 33) {
                            Log.e((String)TAG, (String)"STK500.paged_write(): can't get into sync");
                            return -3;
                        }
                        if (this.getsync() < 0) {
                            return -1;
                        }
                        bRetry = true;
                        continue;
                    }
                    if (buf[0] == 20) continue;
                    Log.e((String)TAG, (String)("STK500.paged_write(): (a) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
                    return -4;
                }
                if (this.recv(buf, 1) < 0) {
                    return -1;
                }
                if (buf[0] != 16) {
                    Log.e((String)TAG, (String)("STK500.paged_write(): (a) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
                    return -5;
                }
            }
            addr += page_size;
        }
        this.report_progress((int)((long)(addr * 100) / n));
        return n_bytes;
    }

    @Override
    public void disable() {
        byte[] buf = new byte[16];
        int tries = 0;
        boolean bRetry = true;
        while (bRetry) {
            bRetry = false;
            ++tries;
            buf[0] = 81;
            buf[1] = 32;
            this.send(buf, 2);
            if (this.recv(buf, 1) < 0) {
                return;
            }
            if (buf[0] == 21) {
                if (tries > 33) {
                    Log.e((String)TAG, (String)"STK500.disable(): can't get into sync");
                    return;
                }
                if (this.getsync() < 0) {
                    return;
                }
                bRetry = true;
                continue;
            }
            if (buf[0] == 20) continue;
            Log.e((String)TAG, (String)("STK500.disable(): protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
            return;
        }
        if (this.recv(buf, 1) < 0) {
            return;
        }
        if (buf[0] == 16) {
            Log.d((String)TAG, (String)"disable OK");
            return;
        }
        if (buf[0] == 19) {
            Log.e((String)TAG, (String)"STK500.disable(): no device");
            return;
        }
        Log.e((String)TAG, (String)("STK500.disable(): unknown response=" + this.toHexStr(buf[0])));
    }

    public void close() {
        this.mComm = null;
    }

    private boolean is_page_empty(int address, int page_size, byte[] buf) {
        int i = 0;
        while (i < page_size) {
            if (buf[address + i] != 255) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int loadaddr(int addr) {
        byte[] buf = new byte[16];
        boolean bRetry = true;
        int tries = 0;
        while (bRetry) {
            bRetry = false;
            ++tries;
            buf[0] = 85;
            buf[1] = (byte)(addr & 0xFF);
            buf[2] = (byte)(addr >> 8 & 0xFF);
            buf[3] = 32;
            this.send(buf, 4);
            if (this.recv(buf, 1) < 0) {
                return -1;
            }
            if (buf[0] == 21) {
                if (tries > 33) {
                    Log.e((String)TAG, (String)"STK500.loadaddr(): can't get into sync");
                    return -1;
                }
                if (this.getsync() < 0) {
                    return -1;
                }
                bRetry = true;
                continue;
            }
            if (buf[0] == 20) continue;
            Log.e((String)TAG, (String)("STK500.loadaddr(): (a) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
            return -1;
        }
        if (this.recv(buf, 1) < 0) {
            return -1;
        }
        if (buf[0] == 16) {
            return 0;
        }
        Log.e((String)TAG, (String)("STK500.loadaddr(): (b) protocol error, expect=" + this.toHexStr((byte)20) + ", resp=" + this.toHexStr(buf[0])));
        return -1;
    }

    private String toHexStr(byte b) {
        return String.format("0x%02x", b);
    }

    private String toHexStr(byte[] b, int length) {
        String str = "";
        int i = 0;
        while (i < length) {
            str = String.valueOf(str) + String.format("0x%02x ", b[i]);
            ++i;
        }
        return str;
    }

    private void setDtrRts(boolean on) {
        if (on) {
            this.mComm.setDtrRts(true, true);
        } else {
            this.mComm.setDtrRts(false, false);
        }
    }
}

