/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.usb;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.util.SparseArray;

public enum UsbAccessor {
    INSTANCE;

    private static final boolean DEBUG_SHOW = true;
    private static final String TAG;
    private UsbManager mManager = null;
    private PendingIntent mPermissionIntent = null;
    private SparseArray<UsbDeviceConnection> mConnection = new SparseArray();

    static {
        TAG = UsbAccessor.class.getSimpleName();
    }

    public void init(Context context) {
        if (this.mManager == null) {
            this.mManager = (UsbManager)context.getSystemService("usb");
        }
        if (this.mPermissionIntent == null) {
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent("USB_PERMISSION"), (int)0);
        }
    }

    public UsbManager manager() {
        return this.mManager;
    }

    public UsbDevice device(int devNum) {
        if (this.mManager == null || this.mPermissionIntent == null) {
            return null;
        }
        if (this.mManager.getDeviceList().size() <= devNum) {
            return null;
        }
        int count = 0;
        for (UsbDevice device : this.mManager.getDeviceList().values()) {
            Log.d((String)TAG, (String)("Device(" + count + ") : " + device.toString()));
            if (count == devNum) {
                this.getPermission(device);
                if (!this.mManager.hasPermission(device)) {
                    Log.d((String)TAG, (String)("Doesn't have permission device(" + count + ") : " + device.toString()));
                    return null;
                }
                return device;
            }
            ++count;
        }
        Log.d((String)TAG, (String)("Cannot find device(" + devNum + ")"));
        return null;
    }

    public UsbInterface intface(int devNum, int intfNum) {
        UsbDevice dev = this.device(devNum);
        if (dev == null) {
            return null;
        }
        int devCount = dev.getInterfaceCount();
        int i = 0;
        while (i < devCount) {
            if (i == intfNum) {
                Log.d((String)TAG, (String)("Interface(" + devNum + "," + intfNum + ") : " + dev.getInterface(i).toString()));
                return dev.getInterface(i);
            }
            ++i;
        }
        Log.d((String)TAG, (String)("Cannot find interface(" + devNum + "," + intfNum + ")"));
        return null;
    }

    public UsbEndpoint endpoint(int devNum, int intfNum, int epNum) {
        UsbInterface intf = this.intface(devNum, intfNum);
        if (intf == null) {
            return null;
        }
        int epCount = intf.getEndpointCount();
        int i = 0;
        while (i < epCount) {
            if (i == epNum) {
                Log.d((String)TAG, (String)("Endpoint(" + devNum + "," + intfNum + "," + epNum + ") : " + intf.getEndpoint(i).toString()));
                return intf.getEndpoint(i);
            }
            ++i;
        }
        Log.d((String)TAG, (String)("Cannot find endpoint(" + devNum + "," + intfNum + "," + epNum + ")"));
        return null;
    }

    public UsbDeviceConnection connection(int ch) {
        if (ch >= this.mConnection.size()) {
            return null;
        }
        return (UsbDeviceConnection)this.mConnection.get(ch);
    }

    public boolean deviceIsConnected(int devNum) {
        return this.connection(devNum) != null;
    }

    public boolean openDevice() {
        return this.openDevice(0, 0, 0);
    }

    public boolean openDevice(int devNum) {
        return this.openDevice(devNum, 0, 0);
    }

    public boolean openDevice(int devNum, int intfNum, int ch) {
        UsbDevice dev = this.device(devNum);
        if (dev == null) {
            return false;
        }
        UsbDeviceConnection con = this.mManager.openDevice(dev);
        if (con == null) {
            return false;
        }
        if (con.claimInterface(this.intface(devNum, intfNum), true)) {
            this.mConnection.put(ch, (Object)con);
            return true;
        }
        Log.d((String)TAG, (String)("Cannot get claim interface(" + devNum + "," + intfNum + ")"));
        this.mConnection.remove(devNum);
        return false;
    }

    public boolean close(int devNum) {
        UsbDeviceConnection con = this.connection(devNum);
        if (con == null) {
            return false;
        }
        this.mConnection.remove(devNum);
        con.close();
        Log.d((String)TAG, (String)("Close(" + devNum + ")"));
        return true;
    }

    public boolean closeAll() {
        boolean ret = false;
        int i = 0;
        while (i < this.mConnection.size()) {
            UsbDeviceConnection con = (UsbDeviceConnection)this.mConnection.valueAt(i);
            if (con != null) {
                Log.d((String)TAG, (String)("Close(" + this.mConnection.keyAt(i) + ")"));
                con.close();
                ret = true;
            }
            ++i;
        }
        this.mConnection.clear();
        return ret;
    }

    public int getVid(int devNum) {
        UsbDevice dev = this.device(devNum);
        if (dev == null) {
            return 0;
        }
        return dev.getVendorId();
    }

    public int getPid(int devNum) {
        UsbDevice dev = this.device(devNum);
        if (dev == null) {
            return 0;
        }
        return dev.getProductId();
    }

    public String getSerial(int devNum) {
        if (this.connection(devNum) == null) {
            return "";
        }
        return this.connection(devNum).getSerial();
    }

    public void getPermission(UsbDevice device) {
        if (this.mManager == null) {
            return;
        }
        if (device != null && this.mPermissionIntent != null && !this.mManager.hasPermission(device)) {
            Log.d((String)TAG, (String)("Request permission : " + device.toString()));
            this.mManager.requestPermission(device, this.mPermissionIntent);
        }
    }
}

