/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import android.util.SparseArray;
import com.physicaloid.lib.usb.UsbAccessor;
import com.physicaloid.lib.usb.UsbVidPid;

public class UsbCdcConnection {
    private static final boolean DEBUG_SHOW = true;
    private static final String TAG = UsbCdcConnection.class.getSimpleName();
    private UsbAccessor mUsbAccess = UsbAccessor.INSTANCE;
    SparseArray<UsbCdcConnectionEp> mUsbConnectionEp;

    public UsbCdcConnection(Context context) {
        this.mUsbAccess.init(context);
        this.mUsbConnectionEp = new SparseArray();
    }

    public boolean open(UsbVidPid ids) {
        return this.open(ids, false, 0);
    }

    public boolean open(UsbVidPid ids, boolean isCdcAcm) {
        return this.open(ids, isCdcAcm, 0);
    }

    public boolean open(UsbVidPid ids, boolean isCdcAcm, int ch) {
        if (ids == null) {
            return false;
        }
        int devNum = 0;
        int chNum = 0;
        for (UsbDevice usbdev : this.mUsbAccess.manager().getDeviceList().values()) {
            if (usbdev.getVendorId() == ids.getVid() && (ids.getPid() == 0 || ids.getPid() == usbdev.getProductId())) {
                int intfNum = 0;
                while (intfNum < usbdev.getInterfaceCount()) {
                    if ((isCdcAcm && usbdev.getInterface(intfNum).getInterfaceClass() == 10 || !isCdcAcm) && ch == chNum) {
                        if (!this.mUsbAccess.deviceIsConnected(devNum) && this.mUsbAccess.openDevice(devNum, intfNum, ch)) {
                            Log.d((String)TAG, (String)("Find VID:" + Integer.toHexString(usbdev.getVendorId()) + ", PID:" + Integer.toHexString(usbdev.getProductId()) + ", DevNum:" + devNum + ", IntfNum:" + intfNum));
                            this.mUsbConnectionEp.put(ch, (Object)new UsbCdcConnectionEp(this.mUsbAccess.connection(ch), this.getEndpoint(devNum, intfNum, 128), this.getEndpoint(devNum, intfNum, 0)));
                            return true;
                        }
                        ++chNum;
                    }
                    ++intfNum;
                }
            }
            ++devNum;
        }
        Log.d((String)TAG, (String)("Cannot find VID:" + ids.getVid() + ", PID:" + ids.getPid()));
        return false;
    }

    private UsbEndpoint getEndpoint(int devNum, int intfNum, int usbDir) {
        UsbInterface intf = this.mUsbAccess.intface(devNum, intfNum);
        if (intf == null) {
            return null;
        }
        int i = 0;
        while (i < intf.getEndpointCount()) {
            UsbEndpoint ep = this.mUsbAccess.endpoint(devNum, intfNum, i);
            if (ep == null) {
                return null;
            }
            if (ep.getDirection() == usbDir) {
                return ep;
            }
            ++i;
        }
        return null;
    }

    public boolean close() {
        this.mUsbConnectionEp.clear();
        return this.mUsbAccess.closeAll();
    }

    public UsbDeviceConnection getConnection() {
        return this.getConnection(0);
    }

    public UsbDeviceConnection getConnection(int ch) {
        UsbCdcConnectionEp con = (UsbCdcConnectionEp)this.mUsbConnectionEp.get(ch);
        if (con == null) {
            return null;
        }
        return con.connection;
    }

    public UsbEndpoint getEndpointIn() {
        return this.getEndpointIn(0);
    }

    public UsbEndpoint getEndpointIn(int ch) {
        UsbCdcConnectionEp con = (UsbCdcConnectionEp)this.mUsbConnectionEp.get(ch);
        if (con == null) {
            return null;
        }
        return con.endpointIn;
    }

    public UsbEndpoint getEndpointOut() {
        return this.getEndpointOut(0);
    }

    public UsbEndpoint getEndpointOut(int ch) {
        UsbCdcConnectionEp con = (UsbCdcConnectionEp)this.mUsbConnectionEp.get(ch);
        if (con == null) {
            return null;
        }
        return con.endpointOut;
    }

    class UsbCdcConnectionEp {
        public UsbDeviceConnection connection;
        public UsbEndpoint endpointIn;
        public UsbEndpoint endpointOut;

        public UsbCdcConnectionEp(UsbDeviceConnection connection, UsbEndpoint endpointIn, UsbEndpoint endpointOut) {
            this.connection = connection;
            this.endpointIn = endpointIn;
            this.endpointOut = endpointOut;
        }
    }
}

