/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.misc;

public class RingBuffer {
    private static final String TAG = RingBuffer.class.getSimpleName();
    private static final boolean DEBUG_SHOW_ADD = false;
    private static final boolean DEBUG_SHOW_GET = false;
    private int mRingBufSize;
    private byte[] mRingBuf;
    private int mAddIndex;
    private int mGetIndex;

    public RingBuffer(int bufferSize) {
        this.mRingBufSize = bufferSize + 1;
        this.mRingBuf = new byte[this.mRingBufSize];
        this.mAddIndex = 0;
        this.mGetIndex = 0;
    }

    public int getRingBufferSize() {
        return this.mRingBufSize - 1;
    }

    public int getBufferdLength() {
        if (this.mAddIndex >= this.mGetIndex) {
            return this.mAddIndex - this.mGetIndex;
        }
        return this.mAddIndex + (this.mRingBufSize - this.mGetIndex);
    }

    public synchronized int add(byte[] buf, int length) {
        int addLen = length;
        if (this.mAddIndex > this.mGetIndex) {
            if (this.mAddIndex + length >= this.mRingBufSize && this.mRingBufSize - this.mAddIndex + (this.mGetIndex - 1) < length) {
                addLen = this.mRingBufSize - this.mAddIndex + (this.mGetIndex - 1);
            }
        } else if (this.mAddIndex < this.mGetIndex && this.mGetIndex - 1 - this.mAddIndex < length) {
            addLen = this.mGetIndex - 1 - this.mAddIndex;
        }
        if (buf.length < addLen) {
            addLen = buf.length;
        }
        if (this.mAddIndex + addLen >= this.mRingBufSize) {
            int remain = this.mAddIndex + addLen - this.mRingBufSize;
            int copyLen = addLen - remain;
            if (copyLen != 0) {
                System.arraycopy(buf, 0, this.mRingBuf, this.mAddIndex, copyLen);
            }
            this.mAddIndex = 0;
            if (remain != 0) {
                System.arraycopy(buf, copyLen, this.mRingBuf, this.mAddIndex, remain);
                this.mAddIndex = remain;
            }
            return addLen;
        }
        System.arraycopy(buf, 0, this.mRingBuf, this.mAddIndex, addLen);
        this.mAddIndex += addLen;
        return addLen;
    }

    public synchronized int get(byte[] buf, int length) {
        int getLen = length;
        if (this.mAddIndex == this.mGetIndex) {
            return 0;
        }
        if (this.mGetIndex < this.mAddIndex) {
            if (this.mAddIndex - this.mGetIndex < length) {
                getLen = this.mAddIndex - this.mGetIndex;
            }
        } else if (this.mAddIndex + (this.mRingBufSize - this.mGetIndex) < length) {
            getLen = this.mAddIndex + (this.mRingBufSize - this.mGetIndex);
        }
        if (buf.length < getLen) {
            getLen = buf.length;
        }
        if (this.mGetIndex + getLen >= this.mRingBufSize) {
            int remain = this.mGetIndex + getLen - this.mRingBufSize;
            int copyLen = getLen - remain;
            if (copyLen != 0) {
                System.arraycopy(this.mRingBuf, this.mGetIndex, buf, 0, copyLen);
            }
            this.mGetIndex = 0;
            if (remain != 0) {
                System.arraycopy(this.mRingBuf, this.mGetIndex, buf, copyLen, remain);
                this.mGetIndex = remain;
            }
            return getLen;
        }
        System.arraycopy(this.mRingBuf, this.mGetIndex, buf, 0, getLen);
        this.mGetIndex += getLen;
        return getLen;
    }

    public synchronized void clear() {
        this.mAddIndex = 0;
        this.mGetIndex = 0;
    }
}

