Open Note Scanner について
==========================

**© 20XX [Claudemir Todo Bom](http://todobom.com)**

このアプリケーションは素早く手書きのメモやアート、ショッピングのレシートやその他の文書をスキャンして保存する方法を提供します。 また [あらかじめフォーマットされたページ](https://github.com/ctodobom/OpenNoteScanner/raw/master/Page%20Templates/A4%20with%202%20pages.pdf) 画像の自動キャプチャもサポートしています。


ライセンス
----------

このアプリケーションは [GNU GPL バージョン 3](http://www.gnu.org/licenses/gpl.txt) で利用できます。 ソースコードは [GitHub で利用できます](http://github.com/ctodobom/OpenNoteScanner)。

寄付
----

Android アプリケーションを作成することは私の主要な仕事ではありません。私はこのアプリケーションを好奇心から作成しました。同様の目的を持った数十ものアプリケーションがありますが、どれもオープンソースではないからです。

このアプリケーションや私の貢献に価値があり、あなたが支払ってもよいと思っていただくのでであれば、Paypal、Bitcoin、Dogecoin で寄付をしてください。

[Paypal で寄付](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=X6XHVCPMRQEL4)

**注意:** 暗号通貨のリンクは、そのコインのアプリがインストールされている場合にのみ機能します!

[Bitcoin で寄付](bitcoin:1H5tqKZoWdqkR54PGe9w67EzBnLXHBFmt9)

[Dogecoin で寄付](dogecoin:DFBaP724XR3rfs9wFahBd353yFkgkqatvd)


サードパーティの部品と要件
--------------------------

バイナリビルドには、これらの外部プロジェクトのコードが含まれています:

* [OpenCV Library for Android](http://www.opencv.org)
* [MarkdownView from Feras Alnatsheh](https://github.com/falnatsheh/MarkdownView)
* [TouchImageView from Mike Ortiz](https://github.com/MikeOrtiz/TouchImageView)
* [Drag Select Recycler View](https://github.com/afollestad/drag-select-recyclerview)
* [Android Universal Image Loader from Sergey Tarasevich](https://github.com/nostra13/Android-Universal-Image-Loader)

謝辞
----

### 貢献者

オープンソース アプリケーションとして、貢献は常に歓迎です。 コードを提出するすべての人がここにリストされます。

* Nicolas Raoul - 英語の訂正
* Claudio Arseni - イタリア語翻訳
* Francisco Toca - スペイン語翻訳
* [@nebulon42](https://github.com/nebulon42) - ドイツ語翻訳
* Ondřej Míchal - チェコ語翻訳
* [@nigelinux](https://github.com/nigelinux) - 繁体中国語 (zh-rTW) 翻訳
* [@naofum] - 日本語翻訳
* [@nikoss](https://github.com/nikoss) - ギリシャ語への翻訳
* [Arthur Saprunov](https://github.com/Skydragonsz) - オランダ語翻訳
* [@ASMfreaK](https://github.com/ASMfreaK) - ロシア語の翻訳
* [Yaron Shahrabani](https://github.com/yarons) ヘブライ語翻訳
* [@Tobaloidee](https://github.com/Tobaloidee) - アイコンデザイン

[問題の報告](https://github.com/ctodobom/OpenNoteScanner/issues) を提出して支援したり [Telegram グループ](https://telegram.me/joinchat/CGzsxQgjl8CyAZNrTG0qZg) で情報を提供してくれた他の人々。 彼らの支援も高く評価しています。

### 外部コード

このアプリケーションは、コミュニティによって作られた素晴らしい素材がなければ不可能でした。 私はインターネットで入手して、コードに使用した重要な部品の作者に特別な感謝をしたいと思います:

* [Android-er / GridView コードサンプル](http://android-er.blogspot.com.br/2012/07/gridview-loading-photos-from-sd-card.html)
* [Android Hive / フルスクリーン イメージページャ](http://www.androidhive.info/2013/09/android-fullscreen-image-slider-with-swipe-and-pinch-zoom-gestures/)
* [画像の操作方法に関する優れたチュートリアルの pyimagesearch.com の Adrian Rosebrock](http://www.pyimagesearch.com/2014/09/01/build-kick-ass-mobile-document-scanner-just-5-minutes/)
* [Gabriele Mariotti / RecyclerView でセクションの実装方法について](https://gist.github.com/gabrielemariotti/e81e126227f8a4bb339c)
