#ifndef UTIL_H
#define UTIL_H

#include "agg_basics.h"
#include "agg_rendering_buffer.h"
#include "agg_rasterizer_scanline_aa.h"
#include "agg_scanline_u.h"
#include "agg_scanline_p.h"
#include "agg_renderer_scanline.h"
#include "agg_pixfmt_rgb.h"
#include "agg_conv_transform.h"
#include "agg_color_rgba.h"
#include "agg_gsv_text.h"

struct Point
{
   double x;
   double y;
   Point(double x_, double y_): x(x_), y(y_) {}
};

void draw_text(agg::rendering_buffer& rbuf, double x, double y, double size, const char* str)
{
   typedef agg::pixfmt_bgr24 pixfmt_type;
   agg::rasterizer_scanline_aa<> m_ras;
   agg::scanline_p8              m_sl;
   pixfmt_type pf(rbuf);
   agg::renderer_base<pixfmt_type> rb(pf);
   agg::renderer_scanline_aa_solid<agg::renderer_base<pixfmt_type> > ren(rb);

   agg::gsv_text txt;
   agg::conv_stroke<agg::gsv_text> txt_stroke(txt);
   txt_stroke.width(size/6);
   txt_stroke.line_cap(agg::round_cap);
   txt.size(size);
   txt.start_point(x, y);
   txt.text(str);
   m_ras.add_path(txt_stroke);
   ren.color(agg::rgba(0, 0, 0.6, 0.8));
   agg::render_scanlines(m_ras, m_sl, ren);
}

#endif
