#ifndef PENTAGO_AI_H
#define PENTAGO_AI_H

#include "pentago.h"
#include "ai_minmax_search.h"
#include <utility>
#include <vector>
#include <algorithm>

class Pentago_ai: public Pentago
{
public:
   Pentago_ai() :Pentago()
   {
      isSubEmpty[0] = true;
      isSubEmpty[1] = true;
      isSubEmpty[2] = true;
      isSubEmpty[3] = true;
   }
   Pentago_ai(const Pentago_ai& other)
   {
      *this = other;
   }

   int evaluate(int level)
   {
      Point p = (moveNr-level)%2? BLACK: WHITE;
      Point o = (p == BLACK)?     WHITE: BLACK;
      if (haveFive(level%2?p:o))
         return level%2? 100-5*level: -100+5*level;
      return 0;
   }
   int countCenters(Point p)
   {
      int no = 0;
      if (points[1][1] == p) no += 4;
      if (points[1][4] == p) no += 4;
      if (points[4][1] == p) no += 4;
      if (points[4][4] == p) no += 4;

      //if (points[1][2] == p) no += 1;
      //if (points[1][3] == p) no += 1;
      //if (points[2][1] == p) no += 1;
      //if (points[2][2] == p) no += 1;
      //if (points[2][3] == p) no += 1;
      //if (points[3][4] == p) no += 1;
      //if (points[3][1] == p) no += 1;
      //if (points[3][2] == p) no += 1;
      //if (points[3][3] == p) no += 1;
      //if (points[3][4] == p) no += 1;
      //if (points[4][2] == p) no += 1;
      //if (points[4][3] == p) no += 1;
      return no;
   }

   Move* findNextPossible(Move* m, bool reduced = false)
   {
      for (int r = m->rotate; r <= ROTATE_RIGH; r++)
      {
         for (int s = m->square; s < SUB_SQUARES_NR; s++)
         {
            if ((reduced || isEmpty(s)) and (s != 0 or r != ROTATE_LEFT))
            //if ((isEmpty(s)) and (s != 0 or r != ROTATE_LEFT))
            {
               continue;
            }

            for (int it = m->it+1; it < SIZE*SIZE; it++)
            {
               int i = movePerm[it]%6;
               int j = movePerm[it]/6;

               //printf("%d %d, %d %d\n", it, movePerm[it], i, j);
               if (points[i][j] == EMPTY)
               {
                  m->square = s;
                  m->rotate = r;
                  m->first  = i;
                  m->second = j;
                  m->it     = it;
                  return m;
               }
            }
            m->it = -1;
         }
         m->square = 0;
      }
      return NULL;
   }

   bool isEmpty(int s)
   {
      if (not isSubEmpty[s])
         return false;
      for (int i = 0; i < SUB_SQUARES_SZ; i++)
         for (int j = 0; j < SUB_SQUARES_SZ; j++)
         {
            if (i == 1 && j == 1)
               continue;

            int si = topXSquare(s)+i; 
            int sj = topYSquare(s)+j; 
            if (points[si][sj] != EMPTY)
            {
               isSubEmpty[s] = false;
               return false;
            }
         }
      return true;
   }
   
   class iterator
   {
      Pentago_ai* b;
      Move* m;
      bool reduced;
   public:
      Move& operator *()
      {
         return *m;
      }
      void operator++(int)
      {
         m = b->findNextPossible(m, reduced);
      }
      bool operator ==(iterator o)
      {
         return o.m == m;
      }
      bool operator !=(iterator o)
      {
         return o.m != m;
      }
      iterator(Pentago_ai* board, Move* move, bool r = false): b(board), m(move), reduced(r) { }
      iterator(): b(NULL), m(NULL), reduced(false) {}
   };
   iterator begin(bool reduced = false)
   {
      if (endOfTheGame()) return iterator(this, NULL);
      m.it = -1;
      m.first = 0;
      m.second = 0;
      m.rotate = ROTATE_LEFT;
      m.square = 0;
      return iterator(this, findNextPossible(&m), reduced);
   }
   iterator end() { return iterator(this, NULL); }

   int noOfPossibleMoves()
   {
      updatePerm();
      int no = 0;
      for (iterator i = begin(); i != end(); i++) 
         no++;
      return no;
   }

   void updatePerm()
   {
      movePerm.clear();
      movePerm.push_back(1 +6* 1);
      movePerm.push_back(1 +6* 4);
      movePerm.push_back(4 +6* 1);
      movePerm.push_back(4 +6* 4);
      for (int i = 0; i < SIZE*SIZE; ++i)
      {
         if (std::find(movePerm.begin(), movePerm.end(), i) == movePerm.end())
            movePerm.push_back(i);
      }
      std::random_shuffle (movePerm.begin(), movePerm.begin()+4);
      std::random_shuffle (movePerm.begin()+4, movePerm.end());
   }

private:
   Move m;
   bool isSubEmpty[4];
   static std::vector<int> movePerm;
};

Move ai_move(Pentago_ai b, int level, CbFun, void* cbFunData);
#endif
