/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public abstract class ProgressListener {
    public abstract void onProgress(long var1, long var3);

    public long progressInterval() {
        return 500L;
    }

    public static class ProgressHttpEntity
    extends HttpEntityWrapper {
        private final ProgressListener listener;
        private final long length;

        public ProgressHttpEntity(HttpEntity httpEntity, ProgressListener progressListener) {
            super(httpEntity);
            this.listener = progressListener;
            this.length = httpEntity.getContentLength();
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.wrappedEntity.writeTo((OutputStream)new CountingOutputStream(outputStream));
        }

        private class CountingOutputStream
        extends FilterOutputStream {
            private long lastListened;
            private long intervalMs;
            private long transferred;

            public CountingOutputStream(OutputStream outputStream) {
                super(outputStream);
                this.lastListened = 0L;
                this.intervalMs = 0L;
                this.transferred = 0L;
                this.intervalMs = ProgressHttpEntity.this.listener.progressInterval();
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                this.out.write(byArray, n, n2);
                this.transferred += (long)n2;
                long l = System.currentTimeMillis();
                if (l - this.lastListened > this.intervalMs) {
                    this.lastListened = l;
                    ProgressHttpEntity.this.listener.onProgress(this.transferred, ProgressHttpEntity.this.length);
                }
            }

            public void write(int n) throws IOException {
                super.write(n);
                ++this.transferred;
                long l = System.currentTimeMillis();
                if (l - this.lastListened > this.intervalMs) {
                    this.lastListened = l;
                    ProgressHttpEntity.this.listener.onProgress(this.transferred, ProgressHttpEntity.this.length);
                }
            }
        }
    }
}

