/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.jsonextract;

import com.dropbox.client2.jsonextract.JsonBase;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonExtractor;
import com.dropbox.client2.jsonextract.JsonList;
import com.dropbox.client2.jsonextract.JsonMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonThing
extends JsonBase<Object> {
    private static final HashMap<Class, String> TypeNames = new HashMap();

    public JsonThing(Object object, String string) {
        super(object, string);
    }

    public JsonThing(Object object) {
        super(object, null);
    }

    private static String typeNameForClass(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        String string = TypeNames.get(clazz);
        assert (string != null);
        return string;
    }

    private static String typeNameForObject(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Number) {
            return "a number";
        }
        if (object instanceof String) {
            return "a string";
        }
        if (object instanceof Boolean) {
            return "a boolean";
        }
        if (object instanceof Map) {
            return "an object";
        }
        if (object instanceof List) {
            return "an array";
        }
        throw new IllegalArgumentException("not a valid org.json.simple type: " + object.getClass().getName());
    }

    private boolean is(Class<?> clazz) {
        assert (clazz != null);
        return clazz.isInstance(this.internal);
    }

    private <T> T expect(Class<T> clazz) throws JsonExtractionException {
        assert (clazz != null);
        if (clazz.isInstance(this.internal)) {
            Object object = this.internal;
            return (T)object;
        }
        throw this.error("expecting " + JsonThing.typeNameForClass(clazz) + ", found " + JsonThing.typeNameForObject(this.internal));
    }

    public void expectNull() throws JsonExtractionException {
        if (this.internal != null) {
            throw this.error("expecting null");
        }
    }

    public boolean isNull() {
        return this.internal == null;
    }

    public JsonMap expectMap() throws JsonExtractionException {
        Map map = this.expect(Map.class);
        return new JsonMap(map, this.path);
    }

    public boolean isMap() {
        return this.is(Map.class);
    }

    public JsonList expectList() throws JsonExtractionException {
        List list = this.expect(List.class);
        return new JsonList(list, this.path);
    }

    public boolean isList() {
        return this.is(List.class);
    }

    public Number expectNumber() throws JsonExtractionException {
        return this.expect(Number.class);
    }

    public boolean isNumber() {
        return this.is(Number.class);
    }

    public long expectInt64() throws JsonExtractionException {
        if (this.internal instanceof Number) {
            Number number = (Number)this.internal;
            return number.longValue();
        }
        if (this.internal instanceof String) {
            String string = (String)this.internal;
            try {
                return Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.error("couldn't parse string as hex (expecting a 64-bit signed integer value)");
            }
        }
        throw this.error("expecting an integer (or a hex string), found " + JsonThing.typeNameForObject(this.internal));
    }

    public boolean isInt64() {
        try {
            this.expectInt64();
            return true;
        }
        catch (JsonExtractionException jsonExtractionException) {
            return false;
        }
    }

    public String expectString() throws JsonExtractionException {
        return this.expect(String.class);
    }

    public String expectStringOrNull() throws JsonExtractionException {
        if (this.internal == null) {
            return null;
        }
        return this.expect(String.class);
    }

    public boolean isString() {
        return this.is(String.class);
    }

    public boolean expectBoolean() throws JsonExtractionException {
        return this.expect(Boolean.class);
    }

    public boolean isBoolean() {
        return this.is(Boolean.class);
    }

    static String pathConcat(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string + "/" + string2;
    }

    public JsonExtractionException unexpected() {
        return this.error("unexpected type: " + JsonThing.typeNameForObject(this.internal));
    }

    public <T> T optionalExtract(JsonExtractor<T> jsonExtractor) throws JsonExtractionException {
        if (this.isNull()) {
            return null;
        }
        return jsonExtractor.extract(this);
    }

    static {
        TypeNames.put(String.class, "a string");
        TypeNames.put(Number.class, "a number");
        TypeNames.put(Boolean.class, "a boolean");
        TypeNames.put(Map.class, "an object");
        TypeNames.put(List.class, "an array");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OptionalExtractor<T>
    extends JsonExtractor<T> {
        public final JsonExtractor<T> elementExtractor;

        public OptionalExtractor(JsonExtractor<T> jsonExtractor) {
            this.elementExtractor = jsonExtractor;
        }

        @Override
        public T extract(JsonThing jsonThing) throws JsonExtractionException {
            return jsonThing.optionalExtract(this.elementExtractor);
        }
    }
}

