package com.ubuntuone.android.files.fragment;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface.OnClickListener;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

public class AlertDialogFragment extends DialogFragment {
	private int title;
	private int message;
	private OnClickListener onPositiveClickListener;
	private OnClickListener onNegativeClickListener;
	
	public static AlertDialogFragment newInstance(
			int title, int message,
			OnClickListener onPositiveClickListener,
			OnClickListener onNegativeClickListener) {
		AlertDialogFragment f = new AlertDialogFragment(title, message,
				onPositiveClickListener, onNegativeClickListener);
		return f;
	}
	
	public AlertDialogFragment(int title, int message,
			OnClickListener onPositiveClickListener,
			OnClickListener onNegativeClickListener) {
		this.title = title;
		this.message = message;
		this.onPositiveClickListener = onPositiveClickListener;
		this.onNegativeClickListener = onNegativeClickListener;
	}

	@Override
	public Dialog onCreateDialog(Bundle savedInstanceState) {
		final AlertDialog.Builder alert = new AlertDialog.Builder(getActivity())
        		.setIcon(android.R.drawable.ic_dialog_alert);
		if (title != -1)
			alert.setTitle(title);
		if (message != -1)
			alert.setMessage(message);
		if (onPositiveClickListener != null)
			alert.setPositiveButton(android.R.string.ok, onPositiveClickListener);
		if (onNegativeClickListener != null)
			alert.setNegativeButton(android.R.string.cancel, onNegativeClickListener);
		return alert.create();
	}
}
