package com.ubuntuone.android.files.fragment;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

public class ProgressDialogFragment extends DialogFragment {
	private int title;
	private int message;
	
	public static ProgressDialogFragment newInstance(int title, int message) {
		return new ProgressDialogFragment(title, message);
	}
	
	public ProgressDialogFragment(int title, int message) {
		this.title = title;
		this.message = message;
	}
	
	@Override
	public Dialog onCreateDialog(Bundle savedInstanceState) {
		final ProgressDialog dialog = new ProgressDialog(getActivity());
		if (title != -1)
			dialog.setTitle(title);
		if (message != -1)
			dialog.setMessage(getString(message));
		setCancelable(false);
		return dialog;
	}
}
